/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.OptionPageProvider;
import org.jphototagger.domain.metadata.exif.ExifCacheProvider;
import org.jphototagger.exif.ExifSupport;
import org.jphototagger.lib.swing.ObjectsSelectionDialog;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class ExifSettingsPanel
extends JPanel
implements OptionPageProvider {
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private final DefaultListModel<String> excludeSuffixesListModel = new DefaultListModel();
    private final ListSelectionListener suffixListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ExifSettingsPanel.this.setRemoveSuffixesButtonEnabeld();
            }
        }
    };
    private final KeyListener deleteSuffixesKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                ExifSettingsPanel.this.removeExcludeSuffixes();
            }
        }
    };
    private JButton buttonAddExcludeSuffixes;
    private JButton buttonRemoveExcludeSuffixes;
    private JLabel labelExcludeSuffixes;
    private JList<String> listExcludeSuffixes;
    private JPanel panelExcludeSuffixes;
    private JPanel panelExcludeSuffixesContent;
    private JScrollPane scrollPaneExcludeSuffixes;
    private JTabbedPane tabbedPane;

    public ExifSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initExcludeFromReadSuffixesListModel();
        this.listExcludeSuffixes.addListSelectionListener(this.suffixListSelectionListener);
        this.listExcludeSuffixes.addKeyListener(this.deleteSuffixesKeyListener);
    }

    private void initExcludeFromReadSuffixesListModel() {
        if (this.prefs == null) {
            return;
        }
        ArrayList suffixes = new ArrayList(this.prefs.getStringCollection("ExifSettings.ExcludeFromReadSuffixes"));
        Collections.sort(suffixes);
        for (String suffix : suffixes) {
            this.excludeSuffixesListModel.addElement(suffix);
        }
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return Bundle.getString(ExifSettingsPanel.class, (String)"ExifSettingsPanel.Title", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isMiscOptionPage() {
        return true;
    }

    public int getPosition() {
        return 2;
    }

    private void addExcludeSuffixes() {
        ObjectsSelectionDialog dlg = new ObjectsSelectionDialog();
        dlg.setTitle(Bundle.getString(ExifSettingsPanel.class, (String)"ExifSettingsPanel.AddSuffixes.DialogTitle", (Object[])new Object[0]));
        dlg.setObjects(this.getNotExcludeSuffixes());
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            for (String suffix : dlg.getSelectedObjects()) {
                this.excludeSuffixesListModel.addElement(suffix);
            }
            this.prefs.setStringCollection("ExifSettings.ExcludeFromReadSuffixes", this.getExcludeSuffixes());
            this.clearExifCache();
        }
    }

    private List<String> getNotExcludeSuffixes() {
        ArrayList<String> suffixes = new ArrayList<String>(ExifSupport.INSTANCE.getSupportedSuffixes());
        suffixes.removeAll(this.getExcludeSuffixes());
        Collections.sort(suffixes);
        return suffixes;
    }

    private List<String> getExcludeSuffixes() {
        ArrayList<String> suffixes = new ArrayList<String>(this.excludeSuffixesListModel.size());
        Enumeration<String> e = this.excludeSuffixesListModel.elements();
        while (e.hasMoreElements()) {
            suffixes.add(e.nextElement());
        }
        return suffixes;
    }

    private void removeExcludeSuffixes() {
        List<String> suffixes = this.listExcludeSuffixes.getSelectedValuesList();
        if (suffixes.isEmpty()) {
            return;
        }
        for (String suffix : suffixes) {
            this.excludeSuffixesListModel.removeElement(suffix);
        }
        this.prefs.setStringCollection("ExifSettings.ExcludeFromReadSuffixes", this.getExcludeSuffixes());
        this.clearExifCache();
    }

    private void clearExifCache() {
        ExifCacheProvider cache = (ExifCacheProvider)Lookup.getDefault().lookup(ExifCacheProvider.class);
        if (cache != null) {
            cache.clear();
        }
    }

    private void setRemoveSuffixesButtonEnabeld() {
        boolean suffixSelected = this.listExcludeSuffixes.getSelectedIndex() >= 0;
        this.buttonRemoveExcludeSuffixes.setEnabled(suffixSelected);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.panelExcludeSuffixes = new JPanel();
        this.panelExcludeSuffixesContent = new JPanel();
        this.labelExcludeSuffixes = new JLabel();
        this.scrollPaneExcludeSuffixes = new JScrollPane();
        this.listExcludeSuffixes = new JList();
        this.buttonAddExcludeSuffixes = new JButton();
        this.buttonRemoveExcludeSuffixes = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelExcludeSuffixes.setLayout(new GridBagLayout());
        this.panelExcludeSuffixesContent.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/exif/Bundle");
        this.labelExcludeSuffixes.setText(bundle.getString("ExifSettingsPanel.labelExcludeSuffixes.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelExcludeSuffixesContent.add((Component)this.labelExcludeSuffixes, gridBagConstraints);
        this.listExcludeSuffixes.setModel(this.excludeSuffixesListModel);
        this.scrollPaneExcludeSuffixes.setViewportView(this.listExcludeSuffixes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelExcludeSuffixesContent.add((Component)this.scrollPaneExcludeSuffixes, gridBagConstraints);
        this.buttonAddExcludeSuffixes.setText("+");
        this.buttonAddExcludeSuffixes.setToolTipText(bundle.getString("ExifSettingsPanel.buttonAddExcludeSuffixes.toolTipText"));
        this.buttonAddExcludeSuffixes.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddExcludeSuffixes.setPreferredSize(new Dimension(22, 22));
        this.buttonAddExcludeSuffixes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExifSettingsPanel.this.buttonAddExcludeSuffixesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.panelExcludeSuffixesContent.add((Component)this.buttonAddExcludeSuffixes, gridBagConstraints);
        this.buttonRemoveExcludeSuffixes.setText("-");
        this.buttonRemoveExcludeSuffixes.setToolTipText(bundle.getString("ExifSettingsPanel.buttonRemoveExcludeSuffixes.toolTipText"));
        this.buttonRemoveExcludeSuffixes.setEnabled(false);
        this.buttonRemoveExcludeSuffixes.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveExcludeSuffixes.setPreferredSize(new Dimension(22, 22));
        this.buttonRemoveExcludeSuffixes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExifSettingsPanel.this.buttonRemoveExcludeSuffixesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelExcludeSuffixesContent.add((Component)this.buttonRemoveExcludeSuffixes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelExcludeSuffixes.add((Component)this.panelExcludeSuffixesContent, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("ExifSettingsPanel.panelExcludeSuffixes.TabConstraints.tabTitle"), this.panelExcludeSuffixes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    private void buttonAddExcludeSuffixesActionPerformed(ActionEvent evt) {
        this.addExcludeSuffixes();
    }

    private void buttonRemoveExcludeSuffixesActionPerformed(ActionEvent evt) {
        this.removeExcludeSuffixes();
    }
}

