/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.domain.metadata.MetaDataValueProvider;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.exif.ExifDateTimeOriginalMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifFocalLengthMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifIsoSpeedRatingsMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifLensMetaDataValue;
import org.jphototagger.domain.metadata.exif.ExifRecordingEquipmentMetaDataValue;
import org.jphototagger.exif.ExifSupport;

public final class ExifMetaDataValueProvider
implements MetaDataValueProvider {
    private static final List<MetaDataValue> PROVIDED_META_DATA_VALUES = new LinkedList<MetaDataValue>();

    public Collection<MetaDataValue> getProvidedValues() {
        return new ArrayList<MetaDataValue>(PROVIDED_META_DATA_VALUES);
    }

    public Collection<MetaDataValueData> getMetaDataForImageFile(File file) {
        try {
            Exif exif = ExifSupport.INSTANCE.getExifPreferCached(file);
            if (exif == null) {
                return Collections.emptyList();
            }
            ArrayList<MetaDataValueData> metaDataValueData = new ArrayList<MetaDataValueData>(PROVIDED_META_DATA_VALUES.size());
            this.addMetaDataValueDataIfNotNull((MetaDataValue)ExifDateTimeOriginalMetaDataValue.INSTANCE, exif.getDateTimeOriginal(), metaDataValueData);
            this.addMetaDataValueDataIfNotNull((MetaDataValue)ExifFocalLengthMetaDataValue.INSTANCE, exif.getFocalLengthGreaterZeroOrNull(), metaDataValueData);
            this.addMetaDataValueDataIfNotNull((MetaDataValue)ExifIsoSpeedRatingsMetaDataValue.INSTANCE, exif.getIsoSpeedRatings(), metaDataValueData);
            this.addMetaDataValueDataIfNotNull((MetaDataValue)ExifLensMetaDataValue.INSTANCE, exif.getLens(), metaDataValueData);
            this.addMetaDataValueDataIfNotNull((MetaDataValue)ExifRecordingEquipmentMetaDataValue.INSTANCE, exif.getRecordingEquipment(), metaDataValueData);
            return metaDataValueData;
        }
        catch (Throwable t) {
            Logger.getLogger(ExifMetaDataValueProvider.class.getName()).log(Level.SEVERE, null, t);
            return Collections.emptyList();
        }
    }

    private void addMetaDataValueDataIfNotNull(MetaDataValue metaDataValue, Object value, Collection<MetaDataValueData> values) {
        if (value != null) {
            values.add(new MetaDataValueData(metaDataValue, value));
        }
    }

    public int getPosition() {
        return 200;
    }

    static {
        PROVIDED_META_DATA_VALUES.add((MetaDataValue)ExifDateTimeOriginalMetaDataValue.INSTANCE);
        PROVIDED_META_DATA_VALUES.add((MetaDataValue)ExifFocalLengthMetaDataValue.INSTANCE);
        PROVIDED_META_DATA_VALUES.add((MetaDataValue)ExifIsoSpeedRatingsMetaDataValue.INSTANCE);
        PROVIDED_META_DATA_VALUES.add((MetaDataValue)ExifLensMetaDataValue.INSTANCE);
        PROVIDED_META_DATA_VALUES.add((MetaDataValue)ExifRecordingEquipmentMetaDataValue.INSTANCE);
    }
}

