/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jphototagger.exif.ExifMakerNotes;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.formatter.canon.CanonMakerNotes;
import org.jphototagger.exif.formatter.nikon.NikonMakerNotes;

public final class ExifMakerNotesAdder {
    private static final Map<String, ExifMakerNotes> MAKER_NOTES_OF_MAKE = new HashMap<String, ExifMakerNotes>();

    static void addMakerNotesToExifTags(File file, ExifTags exifTags) {
        String makeLowerCase;
        ExifTag makerNoteTag = exifTags.findExifTagByTagId(ExifTag.Properties.MAKER_NOTE.getTagId());
        ExifTag makeTag = exifTags.findExifTagByTagId(ExifTag.Properties.MAKE.getTagId());
        String string = makeLowerCase = makeTag == null ? null : makeTag.getStringValue().toLowerCase();
        if (makeTag != null && makerNoteTag != null) {
            for (String makeSubstringLowercase : MAKER_NOTES_OF_MAKE.keySet()) {
                if (!makeLowerCase.contains(makeSubstringLowercase)) continue;
                ExifMakerNotes makerNotes = MAKER_NOTES_OF_MAKE.get(makeSubstringLowercase);
                makerNotes.add(file, exifTags, makerNoteTag);
            }
        }
    }

    private ExifMakerNotesAdder() {
    }

    static {
        MAKER_NOTES_OF_MAKE.put("nikon", new NikonMakerNotes());
        MAKER_NOTES_OF_MAKE.put("canon", new CanonMakerNotes());
    }
}

