/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.datatype.ExifValueType;

public final class Ensure {
    public static void exifTagId(ExifTag exifTag, ExifTag.Properties expected) throws IllegalArgumentException {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        if (expected == null) {
            throw new NullPointerException("expected == null");
        }
        if (exifTag.getTagId() != expected.getTagId()) {
            throw new IllegalArgumentException("Wrong tag: " + exifTag.getTagId() + ". Expected: " + expected.getTagId());
        }
    }

    public static void exifValueType(ExifTag exifTag, ExifValueType expectedValueType) throws IllegalArgumentException {
        if (exifTag == null) {
            throw new NullPointerException("exifTag == null");
        }
        if (expectedValueType == null) {
            throw new NullPointerException("expectedValueType == null");
        }
        ExifValueType tagValueType = exifTag.parseValueType();
        if (tagValueType != expectedValueType) {
            throw new IllegalArgumentException("Wrong type: " + (Object)((Object)exifTag.parseValueType()) + ". Expected: " + (Object)((Object)expectedValueType));
        }
    }

    public static void zeroOrPositive(long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negativ value: " + value);
        }
    }

    public static void zeroOrPositive(long numerator, long denominator) throws IllegalArgumentException {
        boolean negative;
        boolean bl = negative = numerator < 0L && denominator > 0L || numerator > 0L && denominator < 0L;
        if (negative) {
            throw new IllegalArgumentException("Negative fraction: " + numerator + "/" + denominator);
        }
    }

    public static void noDivisionByZero(long denominator) throws IllegalArgumentException {
        if (denominator == 0L) {
            throw new IllegalArgumentException("Zero division");
        }
    }

    public static void length(byte[] bytes, int length) throws IllegalArgumentException {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        if (bytes.length != length) {
            throw new IllegalArgumentException("Illegal length: " + bytes.length + ". Required: " + length);
        }
    }

    private Ensure() {
    }
}

