/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.exif;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.metadata.exif.ExifInfo;
import org.jphototagger.domain.metadata.exif.ExifMakerNoteTags;
import org.jphototagger.exif.ExifIfd;
import org.jphototagger.exif.ExifSupport;
import org.jphototagger.exif.ExifTag;
import org.jphototagger.exif.ExifTagDisplayComparator;
import org.jphototagger.exif.ExifTagValueFormatter;
import org.jphototagger.exif.ExifTags;
import org.jphototagger.exif.ExifTagsToDisplay;
import org.jphototagger.exif.ExifThumbnailUtil;
import org.jphototagger.exif.tag.ExifGpsAltitude;
import org.jphototagger.exif.tag.ExifGpsLatitude;
import org.jphototagger.exif.tag.ExifGpsLongitude;
import org.jphototagger.exif.tag.ExifGpsMetadata;
import org.jphototagger.exif.tag.ExifGpsUtil;
import org.jphototagger.lib.util.Translation;
import org.openide.util.Lookup;

public final class DefaultExifInfo
implements ExifInfo {
    public static final Translation TAG_ID_TAGNAME_TRANSLATION = new Translation(DefaultExifInfo.class, "ExifTagIdTagNameTranslations");
    public static final Translation TAGNAME_TRANSLATION = new Translation(DefaultExifInfo.class, "ExifTagNameTranslations");
    private static final Logger LOGGER = Logger.getLogger(DefaultExifInfo.class.getName());

    public double getRotationAngleOfEmbeddedThumbnail(File file) {
        ExifTag exifTag;
        ExifTags exifTags = ExifSupport.INSTANCE.getExifTagsPreferCached(file);
        if (exifTags != null && (exifTag = exifTags.findExifTagByTagId(274)) != null) {
            return ExifThumbnailUtil.getThumbnailRotationAngle(exifTag);
        }
        return 0.0;
    }

    public Collection<org.jphototagger.domain.metadata.exif.ExifTag> getExifTags(File file) {
        ExifTags exifTags = ExifSupport.INSTANCE.getExifTags(file);
        if (exifTags == null) {
            return Collections.emptyList();
        }
        return this.convertTags(exifTags);
    }

    public Collection<org.jphototagger.domain.metadata.exif.ExifTag> getExifTagsPreferCached(File file) {
        ExifTags exifTags = ExifSupport.INSTANCE.getExifTagsPreferCached(file);
        if (exifTags == null) {
            return Collections.emptyList();
        }
        return this.convertTags(exifTags);
    }

    private Collection<org.jphototagger.domain.metadata.exif.ExifTag> convertTags(ExifTags exifTags) {
        ArrayList<org.jphototagger.domain.metadata.exif.ExifTag> tags = new ArrayList<org.jphototagger.domain.metadata.exif.ExifTag>();
        this.addExifTags(exifTags.getExifTags(), tags);
        this.addExifTags(exifTags.getInteroperabilityTags(), tags);
        this.addGpsTags(exifTags, tags);
        this.addExifTags(exifTags.getMakerNoteTags(), tags);
        this.addMakerNoteTagsFromService(exifTags, tags);
        return tags;
    }

    private void addExifTags(Collection<? extends ExifTag> source, Collection<org.jphototagger.domain.metadata.exif.ExifTag> target) {
        List<ExifTag> displayableExifTags = ExifTagsToDisplay.getDisplayableExifTagsOf(source);
        if (!displayableExifTags.isEmpty()) {
            Collections.sort(displayableExifTags, ExifTagDisplayComparator.INSTANCE);
            for (ExifTag displayableExifTag : displayableExifTags) {
                String tagValue = displayableExifTag.getStringValue();
                if (tagValue.length() <= 0) continue;
                String nameString = DefaultExifInfo.getTagName(displayableExifTag).trim();
                String valueString = ExifTagValueFormatter.format(displayableExifTag);
                target.add(new org.jphototagger.domain.metadata.exif.ExifTag(nameString, valueString));
            }
        }
    }

    private void addGpsTags(ExifTags source, Collection<org.jphototagger.domain.metadata.exif.ExifTag> target) {
        org.jphototagger.domain.metadata.exif.ExifTag exifTag;
        String valueString;
        String nameString;
        String tagId;
        ExifGpsMetadata exifGpsMetadata = ExifGpsUtil.createGpsMetadataFromExifTags(source);
        ExifGpsLatitude latitude = exifGpsMetadata.getLatitude();
        ExifGpsLongitude longitude = exifGpsMetadata.getLongitude();
        ExifGpsAltitude altitude = exifGpsMetadata.getAltitude();
        if (latitude != null) {
            tagId = Integer.toString(ExifTag.Properties.GPS_LATITUDE.getTagId());
            nameString = TAG_ID_TAGNAME_TRANSLATION.translate(tagId, tagId);
            valueString = exifGpsMetadata.getLatitude().getLocalizedString();
            exifTag = new org.jphototagger.domain.metadata.exif.ExifTag(nameString, valueString);
            target.add(exifTag);
        }
        if (longitude != null) {
            tagId = Integer.toString(ExifTag.Properties.GPS_LONGITUDE.getTagId());
            String tagName = TAG_ID_TAGNAME_TRANSLATION.translate(tagId, tagId);
            valueString = exifGpsMetadata.getLongitude().toLocalizedString();
            exifTag = new org.jphototagger.domain.metadata.exif.ExifTag(tagName, valueString);
            target.add(exifTag);
        }
        if (altitude != null) {
            tagId = Integer.toString(ExifTag.Properties.GPS_ALTITUDE.getTagId());
            nameString = TAG_ID_TAGNAME_TRANSLATION.translate(tagId, tagId);
            valueString = exifGpsMetadata.getAltitude().getLocalizedString();
            exifTag = new org.jphototagger.domain.metadata.exif.ExifTag(nameString, valueString);
            target.add(exifTag);
        }
        if (longitude != null && latitude != null) {
            DefaultExifInfo.addGoogleMapsUrl(target, exifGpsMetadata);
            DefaultExifInfo.addOpenStreetMapUrl(target, exifGpsMetadata);
        }
    }

    private static void addGoogleMapsUrl(Collection<org.jphototagger.domain.metadata.exif.ExifTag> target, ExifGpsMetadata exifGpsMetadata) {
        String nameString = org.jphototagger.domain.metadata.exif.ExifTag.NAME_GOOGLE_MAPS_URL;
        String valueString = ExifGpsUtil.getGoogleMapsUrl(exifGpsMetadata.getLongitude(), exifGpsMetadata.getLatitude());
        org.jphototagger.domain.metadata.exif.ExifTag exifTag = new org.jphototagger.domain.metadata.exif.ExifTag(nameString, valueString);
        target.add(exifTag);
    }

    private static void addOpenStreetMapUrl(Collection<org.jphototagger.domain.metadata.exif.ExifTag> target, ExifGpsMetadata exifGpsMetadata) {
        String nameString = org.jphototagger.domain.metadata.exif.ExifTag.NAME_OPEN_STREET_MAP_URL;
        String valueString = ExifGpsUtil.getOpenStreetMapUrl(exifGpsMetadata.getLongitude(), exifGpsMetadata.getLatitude());
        org.jphototagger.domain.metadata.exif.ExifTag exifTag = new org.jphototagger.domain.metadata.exif.ExifTag(nameString, valueString);
        target.add(exifTag);
    }

    private static String getTagName(ExifTag exifTag) {
        int makerNoteTagId;
        boolean isMakerNoteTag;
        String tagName = exifTag.getName();
        ExifIfd ifdType = exifTag.getIfd();
        boolean isMakerNoteIfd = ifdType.equals((Object)ExifIfd.MAKER_NOTE);
        if (isMakerNoteIfd) {
            return tagName;
        }
        ExifTag.Properties exifTagId = exifTag.parseProperties();
        int tagId = exifTagId.getTagId();
        boolean bl = isMakerNoteTag = tagId >= (makerNoteTagId = ExifTag.Properties.MAKER_NOTE.getTagId());
        if (isMakerNoteTag) {
            boolean canTranslate = TAGNAME_TRANSLATION.canTranslate(tagName);
            if (!canTranslate) {
                LOGGER.log(Level.INFO, "EXIF tag name suggested for translation: ''{0}''", tagName);
            }
            return canTranslate ? TAGNAME_TRANSLATION.translate(tagName) : tagName;
        }
        return TAG_ID_TAGNAME_TRANSLATION.translate(Integer.toString(exifTag.getTagId()), tagName);
    }

    private void addMakerNoteTagsFromService(ExifTags source, Collection<org.jphototagger.domain.metadata.exif.ExifTag> target) {
        ExifTag makerNoteTag = source.findExifTagByTagId(ExifTag.Properties.MAKER_NOTE.getTagId());
        if (makerNoteTag == null) {
            return;
        }
        byte[] makerNoteRawValue = makerNoteTag.getRawValue();
        ExifTag modelTag = source.findExifTagByTagId(ExifTag.Properties.MODEL.getTagId());
        String modelString = modelTag.getStringValue();
        ExifTag makeTag = source.findExifTagByTagId(ExifTag.Properties.MAKE.getTagId());
        String makeString = makeTag.getStringValue();
        Collection makerNoteExifInfos = Lookup.getDefault().lookupAll(ExifMakerNoteTags.class);
        for (ExifMakerNoteTags makerNoteTags : makerNoteExifInfos) {
            target.addAll(makerNoteTags.getMakerNoteTags(makeString, modelString, makerNoteRawValue));
        }
    }

    public long getTimeTakenInMillis(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return ExifSupport.INSTANCE.getTimeTakenInMillis(file);
    }
}

