/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfiletypes;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.userdefinedfiletypes.EditUserDefinedFileTypeDialog;
import org.jphototagger.userdefinedfiletypes.UserDefinedFileTypesListModel;
import org.openide.util.Lookup;

public class UserDefinedFileTypesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton buttonAdd;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JXList list;
    private JPanel panelButtons;
    private JScrollPane scrollPane;

    public UserDefinedFileTypesPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)this);
        this.list.addListSelectionListener((ListSelectionListener)new ButtonEnabler());
    }

    private void addUserDefinedFileType() {
        EditUserDefinedFileTypeDialog dlg = new EditUserDefinedFileTypeDialog();
        dlg.setVisible(true);
    }

    private void editUserDefinedFileType() {
        List<UserDefinedFileType> fileTypes = this.getSelectedUserDefinedFileTypes();
        for (UserDefinedFileType fileType : fileTypes) {
            EditUserDefinedFileTypeDialog dlg = new EditUserDefinedFileTypeDialog();
            dlg.setUserDefinedFileType(fileType);
            dlg.setVisible(true);
        }
    }

    private void deleteUserDefinedFileType() {
        String message = Bundle.getString(UserDefinedFileTypesPanel.class, (String)"UserDefinedFileTypesPanel.Confirm.Delete", (Object[])new Object[0]);
        if (MessageDisplayer.confirmYesNo((Component)this, (String)message)) {
            List<UserDefinedFileType> fileTypes = this.getSelectedUserDefinedFileTypes();
            UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
            for (UserDefinedFileType fileType : fileTypes) {
                repo.deleteUserDefinedFileType(fileType);
            }
        }
    }

    private void editClickedUserDefinedFileType(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick((MouseEvent)evt)) {
            this.editUserDefinedFileType();
        }
    }

    private List<UserDefinedFileType> getSelectedUserDefinedFileTypes() {
        ArrayList<UserDefinedFileType> fileTypes = new ArrayList<UserDefinedFileType>();
        for (Object selectedValue : this.list.getSelectedValues()) {
            if (!(selectedValue instanceof UserDefinedFileType)) continue;
            fileTypes.add((UserDefinedFileType)selectedValue);
        }
        return fileTypes;
    }

    private boolean isListItemSelected() {
        int selectedIndex = this.list.getSelectedIndex();
        return selectedIndex >= 0;
    }

    private void checkDelete(KeyEvent evt) {
        if (evt.getKeyCode() == 127 && this.isListItemSelected()) {
            this.deleteUserDefinedFileType();
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.panelButtons = new JPanel();
        this.buttonAdd = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.list.setModel((ListModel)new UserDefinedFileTypesListModel());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserDefinedFileTypesPanel.this.listMouseClicked(evt);
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                UserDefinedFileTypesPanel.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.panelButtons.setLayout(new GridLayout(1, 0, 3, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/userdefinedfiletypes/Bundle");
        this.buttonAdd.setText(bundle.getString("UserDefinedFileTypesPanel.buttonAdd.text"));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileTypesPanel.this.buttonAddActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonAdd);
        this.buttonEdit.setText(bundle.getString("UserDefinedFileTypesPanel.buttonEdit.text"));
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileTypesPanel.this.buttonEditActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonEdit);
        this.buttonDelete.setText(bundle.getString("UserDefinedFileTypesPanel.buttonDelete.text"));
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileTypesPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.addUserDefinedFileType();
    }

    private void buttonEditActionPerformed(ActionEvent evt) {
        this.editUserDefinedFileType();
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.deleteUserDefinedFileType();
    }

    private void listKeyPressed(KeyEvent evt) {
        this.checkDelete(evt);
    }

    private void listMouseClicked(MouseEvent evt) {
        this.editClickedUserDefinedFileType(evt);
    }

    private class ButtonEnabler
    implements ListSelectionListener {
        private ButtonEnabler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                boolean itemSelected = UserDefinedFileTypesPanel.this.isListItemSelected();
                UserDefinedFileTypesPanel.this.buttonDelete.setEnabled(itemSelected);
                UserDefinedFileTypesPanel.this.buttonEdit.setEnabled(itemSelected);
            }
        }
    }
}

