/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfiletypes;

import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeUpdatedEvent;
import org.openide.util.Lookup;

public final class UserDefinedFileTypesListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);

    public UserDefinedFileTypesListModel() {
        this.addElements();
        this.listen();
    }

    private void addElements() {
        if (this.repo == null) {
            return;
        }
        List fileTypes = this.repo.findAllUserDefinedFileTypes();
        for (UserDefinedFileType fileType : fileTypes) {
            this.addElement(fileType);
        }
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeInsertedEvent.class)
    public void fileTypeInserted(UserDefinedFileTypeInsertedEvent evt) {
        this.addElement(evt.getFileType());
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeUpdatedEvent.class)
    public void fileTypeUpdated(UserDefinedFileTypeUpdatedEvent evt) {
        int index = this.indexOf(evt.getOldFileType());
        if (index >= 0) {
            this.set(index, evt.getNewFileType());
        }
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeDeletedEvent.class)
    public void fileTypeDeleted(UserDefinedFileTypeDeletedEvent evt) {
        this.removeElement(evt.getFileType());
    }
}

