/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfiletypes;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.jphototagger.domain.filefilter.AppFileFilterProvider;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class EditUserDefinedFileTypeDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private UserDefinedFileType userDefinedFileType = new UserDefinedFileType();
    private boolean changed;
    private boolean inAddNew = true;
    private final UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
    private JButton buttonHelp;
    private JButton buttonSave;
    private JCheckBox checkBoxExternalThumbnailCreator;
    private JLabel labelDescription;
    private JLabel labelSuffix;
    private JTextField textFieldDescription;
    private JTextField textFieldSuffix;

    public EditUserDefinedFileTypeDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics((Container)((Object)this));
        this.initSuffixTextField();
        this.listen();
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(EditUserDefinedFileTypeDialog.class, (String)"EditUserDefinedFileTypeDialog.HelpPage", (Object[])new Object[0]));
    }

    private void initSuffixTextField() {
        Document document = this.textFieldSuffix.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new SuffixDocumentFilter());
        }
    }

    private void listen() {
        ChangeListener changeListener = new ChangeListener();
        this.textFieldSuffix.getDocument().addDocumentListener(changeListener);
        this.textFieldDescription.getDocument().addDocumentListener(changeListener);
        this.checkBoxExternalThumbnailCreator.addActionListener(changeListener);
    }

    public void setUserDefinedFileType(UserDefinedFileType userDefinedFileType) {
        if (userDefinedFileType == null) {
            throw new NullPointerException("userDefinedFileType == null");
        }
        this.userDefinedFileType = userDefinedFileType;
        String suffix = userDefinedFileType.getSuffix();
        String description = userDefinedFileType.getDescription();
        boolean externalThumbnailCreator = userDefinedFileType.isExternalThumbnailCreator();
        if (suffix != null) {
            this.textFieldSuffix.setText(suffix);
        }
        if (description != null) {
            this.textFieldDescription.setText(description);
        }
        this.checkBoxExternalThumbnailCreator.setSelected(externalThumbnailCreator);
        this.changed = false;
        this.inAddNew = false;
    }

    private void setGuiToUserDefinedFileType() {
        String suffix = this.getSuffix();
        String description = this.getDescription();
        boolean externalThumbnailCreator = this.isExternalThumbnailCreator();
        this.userDefinedFileType.setSuffix(suffix);
        this.userDefinedFileType.setDescription(description);
        this.userDefinedFileType.setExternalThumbnailCreator(externalThumbnailCreator);
    }

    private String getDescription() {
        return this.textFieldDescription.getText().trim();
    }

    private String getSuffix() {
        return this.textFieldSuffix.getText().trim();
    }

    private boolean isExternalThumbnailCreator() {
        return this.checkBoxExternalThumbnailCreator.isSelected();
    }

    private void save() {
        if (this.checkValid()) {
            UserDefinedFileType oldUserDefinedFileType = new UserDefinedFileType(this.userDefinedFileType);
            this.setGuiToUserDefinedFileType();
            int countUpdated = this.inAddNew ? this.repo.saveUserDefinedFileType(this.userDefinedFileType) : this.repo.updateUserDefinedFileType(oldUserDefinedFileType, this.userDefinedFileType);
            if (countUpdated > 0) {
                this.changed = false;
                this.escape();
            }
        }
    }

    private boolean checkValid() {
        return this.checkNotEmpty() && this.checkUniqueSuffix() && this.checkIsNotAcceptedSuffix();
    }

    private boolean checkNotEmpty() {
        String suffix = this.getSuffix();
        String description = this.getDescription();
        if (suffix.isEmpty() || description.isEmpty()) {
            String message = Bundle.getString(EditUserDefinedFileTypeDialog.class, (String)"EditUserDefinedFileTypeDialog.Error.Empty", (Object[])new Object[0]);
            MessageDisplayer.error((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    private boolean checkIsNotAcceptedSuffix() {
        if (!this.inAddNew) {
            return true;
        }
        String suffix = this.getSuffix();
        File aFile = new File("abc." + suffix);
        AppFileFilterProvider fileFilterProvider = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
        if (fileFilterProvider.isAcceptedImageFile(aFile)) {
            String message = Bundle.getString(EditUserDefinedFileTypeDialog.class, (String)"EditUserDefinedFileTypeDialog.Error.IsAcceptedSuffix", (Object[])new Object[]{suffix});
            MessageDisplayer.error((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    private boolean checkUniqueSuffix() {
        if (!this.inAddNew) {
            return true;
        }
        String suffix = this.getSuffix();
        boolean suffixExists = this.repo.existsUserDefinedFileTypeWithSuffix(suffix);
        if (suffixExists) {
            String message = Bundle.getString(EditUserDefinedFileTypeDialog.class, (String)"EditUserDefinedFileTypeDialog.Error.SuffixExists", (Object[])new Object[]{suffix});
            MessageDisplayer.error((Component)((Object)this), (String)message);
        }
        return !suffixExists;
    }

    protected void escape() {
        if (this.checkDiscardChanges()) {
            super.escape();
        }
    }

    private boolean checkDiscardChanges() {
        if (this.changed) {
            String message = Bundle.getString(EditUserDefinedFileTypeDialog.class, (String)"EditUserDefinedFileTypeDialog.Confirm.DiscardChanges", (Object[])new Object[0]);
            return MessageDisplayer.confirmYesNo((Component)((Object)this), (String)message);
        }
        return true;
    }

    private void initComponents() {
        this.labelSuffix = new JLabel();
        this.textFieldSuffix = new JTextField();
        this.labelDescription = new JLabel();
        this.textFieldDescription = new JTextField();
        this.checkBoxExternalThumbnailCreator = new JCheckBox();
        this.buttonHelp = new JButton();
        this.buttonSave = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/userdefinedfiletypes/Bundle");
        this.setTitle(bundle.getString("EditUserDefinedFileTypeDialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditUserDefinedFileTypeDialog.this.formWindowClosing(evt);
            }
        });
        this.labelSuffix.setLabelFor(this.textFieldSuffix);
        this.labelSuffix.setText(bundle.getString("EditUserDefinedFileTypeDialog.labelSuffix.text"));
        this.labelDescription.setLabelFor(this.textFieldDescription);
        this.labelDescription.setText(bundle.getString("EditUserDefinedFileTypeDialog.labelDescription.text"));
        this.checkBoxExternalThumbnailCreator.setText(bundle.getString("EditUserDefinedFileTypeDialog.checkBoxExternalThumbnailCreator.text"));
        this.buttonHelp.setText(bundle.getString("EditUserDefinedFileTypeDialog.buttonHelp.text"));
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUserDefinedFileTypeDialog.this.buttonHelpActionPerformed(evt);
            }
        });
        this.buttonSave.setText(bundle.getString("EditUserDefinedFileTypeDialog.buttonSave.text"));
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUserDefinedFileTypeDialog.this.buttonSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSuffix).addComponent(this.labelDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldDescription, -1, 299, Short.MAX_VALUE).addComponent(this.textFieldSuffix, -1, 299, Short.MAX_VALUE))).addComponent(this.checkBoxExternalThumbnailCreator).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSave))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSuffix).addComponent(this.textFieldSuffix, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDescription).addComponent(this.textFieldDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkBoxExternalThumbnailCreator).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonSave).addComponent(this.buttonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.escape();
    }

    private void buttonHelpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditUserDefinedFileTypeDialog dialog = new EditUserDefinedFileTypeDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class SuffixDocumentFilter
    extends DocumentFilter {
        private static final String VALID_REGEX_PATTERN = "[\\.\\-A-Za-z0-9]+";
        private final int maxLength;

        SuffixDocumentFilter() {
            UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
            this.maxLength = repo == null ? 45 : repo.getMaxLengthSuffix();
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (string == null) {
                return;
            }
            int oldLength = fb.getDocument().getLength();
            int newLength = oldLength + string.length();
            if (this.isValid(string, newLength)) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            int textLength;
            int oldLength = fb.getDocument().getLength();
            int newLength = oldLength - length + (textLength = text == null ? 0 : text.length());
            if (this.isValid(text, newLength)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean isValid(String text, int newLength) {
            boolean lengthIsValid;
            boolean bl = lengthIsValid = newLength <= this.maxLength;
            return text == null ? lengthIsValid : lengthIsValid && text.matches(VALID_REGEX_PATTERN);
        }
    }

    private class ChangeListener
    implements DocumentListener,
    ActionListener {
        private ChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EditUserDefinedFileTypeDialog.this.changed = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            EditUserDefinedFileTypeDialog.this.changed = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            EditUserDefinedFileTypeDialog.this.changed = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditUserDefinedFileTypeDialog.this.changed = true;
        }
    }
}

