/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.tcc.def.scripts.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jphototagger.api.branding.Branding;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.tcc.def.FileChooser;
import org.jphototagger.tcc.def.SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction;
import org.jphototagger.tcc.def.Util;
import org.openide.util.Lookup;

public class ImageMagickDcrawThumbnailCreatorDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private File dcraw;
    private File convert;
    private File mplayer;
    private final FileChooser dcrawFileChooser = this.createDcrawFileChooser();
    private final FileChooser convertFileChooser = this.createConvertFileChooser();
    private final FileChooser mplayerFileChooser = this.createMPlayerFileChooser();
    private boolean accepted;
    private static final Icon OK_ICON = new ImageIcon(ImageMagickDcrawThumbnailCreatorDialog.class.getResource("/org/jphototagger/tcc/def/icons/icon_ok.png"));
    private static final Icon ERROR_ICON = new ImageIcon(ImageMagickDcrawThumbnailCreatorDialog.class.getResource("/org/jphototagger/tcc/def/icons/icon_error.png"));
    private JButton buttonAddUserDefinedFileTypes;
    private JButton buttonBrowseConvert;
    private JButton buttonBrowseDcraw;
    private JButton buttonBrowserMPlayer;
    private JButton buttonCancel;
    private JButton buttonChooseConvert;
    private JButton buttonChooseDcraw;
    private JButton buttonChooseMPlayer;
    private JButton buttonOk;
    private JLabel labelConvertOk;
    private JLabel labelDcrawOk;
    private JXLabel labelInfo;
    private JXLabel labelInfoVideo;
    private JLabel labelMPlayerOk;
    private JPanel panelContent;
    private JPanel panelImageButtons;
    private JPanel panelOkCancelButtons;
    private JPanel panelVideo;

    public ImageMagickDcrawThumbnailCreatorDialog() {
        super((Frame)null, true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)((Object)this));
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public File getConvert() {
        return this.convert;
    }

    public File getDcraw() {
        return this.dcraw;
    }

    public File getMplayer() {
        return this.mplayer;
    }

    private void chooseDcraw() {
        File file = this.dcrawFileChooser.chooseFileFixedName();
        if (file != null) {
            this.dcraw = file;
        }
        this.labelDcrawOk.setIcon(this.dcraw == null ? ERROR_ICON : OK_ICON);
        this.setEnabledOkButton();
    }

    private void chooseConvert() {
        File file = this.convertFileChooser.chooseFileFixedName();
        if (file != null) {
            this.convert = file;
        }
        this.labelConvertOk.setIcon(this.convert == null ? ERROR_ICON : OK_ICON);
        this.setEnabledOkButton();
    }

    private void chooseMPlayer() {
        File file = this.mplayerFileChooser.chooseFileFixedName();
        if (file != null) {
            this.mplayer = file;
        }
        this.labelMPlayerOk.setIcon(this.mplayer == null ? ERROR_ICON : OK_ICON);
    }

    private void setEnabledOkButton() {
        this.buttonOk.setEnabled(this.dcraw != null && this.convert != null);
    }

    private FileChooser createDcrawFileChooser() {
        List<String> filenames = Arrays.asList("dcraw.exe", "dcrawMS.exe");
        String fileDescription = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.Dcraw.FileChooser.Description", (Object[])new Object[0]);
        String fileChooserTitle = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.Dcraw.FileChooser.Title", (Object[])new Object[0]);
        return this.createFileChooser(new HashSet<String>(filenames), fileDescription, fileChooserTitle);
    }

    private FileChooser createConvertFileChooser() {
        String filename = "convert.exe";
        String fileDescription = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.Convert.FileChooser.Description", (Object[])new Object[0]);
        String fileChooserTitle = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.Convert.FileChooser.Title", (Object[])new Object[0]);
        return this.createFileChooser(new HashSet<String>(Arrays.asList(filename)), fileDescription, fileChooserTitle);
    }

    private FileChooser createMPlayerFileChooser() {
        String filename = "mplayer.exe";
        String fileDescription = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.MPlayer.FileChooser.Description", (Object[])new Object[0]);
        String fileChooserTitle = Bundle.getString(ImageMagickDcrawThumbnailCreatorDialog.class, (String)"ImageMagickDcrawThumbnailCreatorDialog.MPlayer.FileChooser.Title", (Object[])new Object[0]);
        return this.createFileChooser(new HashSet<String>(Arrays.asList(filename)), fileDescription, fileChooserTitle);
    }

    private FileChooser createFileChooser(Set<String> filenames, String fileDescription, String fileChooserTitle) {
        String programsDirectory = System.getenv("ProgramFiles");
        return new FileChooser.Builder(filenames).fileChooserTitle(fileChooserTitle).fileDescription(fileDescription).fileChooserDirPath(programsDirectory == null ? "" : programsDirectory).build();
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.labelInfo = new JXLabel();
        this.panelImageButtons = new JPanel();
        this.labelDcrawOk = new JLabel();
        this.buttonChooseDcraw = new JButton();
        this.buttonBrowseDcraw = new JButton();
        this.labelConvertOk = new JLabel();
        this.buttonChooseConvert = new JButton();
        this.buttonBrowseConvert = new JButton();
        this.panelVideo = new JPanel();
        this.labelInfoVideo = new JXLabel();
        this.buttonAddUserDefinedFileTypes = new JButton();
        this.labelMPlayerOk = new JLabel();
        this.buttonChooseMPlayer = new JButton();
        this.buttonBrowserMPlayer = new JButton();
        this.panelOkCancelButtons = new JPanel();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/tcc/def/scripts/windows/Bundle");
        this.setTitle(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.title"));
        this.setIconImages(((Branding)Lookup.getDefault().lookup(Branding.class)).getAppIcons());
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        this.labelInfo.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.labelInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelContent.add((Component)this.labelInfo, gridBagConstraints);
        this.panelImageButtons.setLayout(new GridBagLayout());
        this.labelDcrawOk.setIcon(ERROR_ICON);
        this.panelImageButtons.add((Component)this.labelDcrawOk, new GridBagConstraints());
        this.buttonChooseDcraw.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonChooseDcraw.text"));
        this.buttonChooseDcraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonChooseDcrawActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelImageButtons.add((Component)this.buttonChooseDcraw, gridBagConstraints);
        this.buttonBrowseDcraw.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonBrowseDcraw.text"));
        this.buttonBrowseDcraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonBrowseDcrawActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelImageButtons.add((Component)this.buttonBrowseDcraw, gridBagConstraints);
        this.labelConvertOk.setIcon(ERROR_ICON);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelImageButtons.add((Component)this.labelConvertOk, gridBagConstraints);
        this.buttonChooseConvert.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonChooseConvert.text"));
        this.buttonChooseConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonChooseConvertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        this.panelImageButtons.add((Component)this.buttonChooseConvert, gridBagConstraints);
        this.buttonBrowseConvert.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonBrowseConvert.text"));
        this.buttonBrowseConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonBrowseConvertActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelImageButtons.add((Component)this.buttonBrowseConvert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelContent.add((Component)this.panelImageButtons, gridBagConstraints);
        this.panelVideo.setBorder(BorderFactory.createTitledBorder(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.panelVideo.border.title")));
        this.panelVideo.setLayout(new GridBagLayout());
        this.labelInfoVideo.setLineWrap(true);
        this.labelInfoVideo.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.labelInfoVideo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelVideo.add((Component)this.labelInfoVideo, gridBagConstraints);
        this.buttonAddUserDefinedFileTypes.setAction(SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction.INSTANCE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelVideo.add((Component)this.buttonAddUserDefinedFileTypes, gridBagConstraints);
        this.labelMPlayerOk.setIcon(ERROR_ICON);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.panelVideo.add((Component)this.labelMPlayerOk, gridBagConstraints);
        this.buttonChooseMPlayer.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonChooseMPlayer.text"));
        this.buttonChooseMPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonChooseMPlayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelVideo.add((Component)this.buttonChooseMPlayer, gridBagConstraints);
        this.buttonBrowserMPlayer.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonBrowserMPlayer.text"));
        this.buttonBrowserMPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonBrowserMPlayerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 5, 5);
        this.panelVideo.add((Component)this.buttonBrowserMPlayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelContent.add((Component)this.panelVideo, gridBagConstraints);
        this.panelOkCancelButtons.setLayout(new GridLayout(1, 0, 3, 0));
        this.buttonOk.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonOk.text"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.panelOkCancelButtons.add(this.buttonOk);
        this.buttonCancel.setText(bundle.getString("ImageMagickDcrawThumbnailCreatorDialog.buttonCancel.text"));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageMagickDcrawThumbnailCreatorDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.panelOkCancelButtons.add(this.buttonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panelContent.add((Component)this.panelOkCancelButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.setVisible(false);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void buttonChooseDcrawActionPerformed(ActionEvent evt) {
        this.chooseDcraw();
    }

    private void buttonChooseConvertActionPerformed(ActionEvent evt) {
        this.chooseConvert();
    }

    private void buttonBrowseDcrawActionPerformed(ActionEvent evt) {
        Util.browse("http://www.cybercom.net/~dcoffin/dcraw/");
    }

    private void buttonBrowseConvertActionPerformed(ActionEvent evt) {
        Util.browse("http://www.imagemagick.org/");
    }

    private void buttonChooseMPlayerActionPerformed(ActionEvent evt) {
        this.chooseMPlayer();
    }

    private void buttonBrowserMPlayerActionPerformed(ActionEvent evt) {
        Util.browse("http://www.mplayerhq.hu/design7/dload.html");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageMagickDcrawThumbnailCreatorDialog dialog = new ImageMagickDcrawThumbnailCreatorDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

