/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.tcc.def.scripts.unix;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jphototagger.api.storage.PreferencesDirectoryProvider;
import org.jphototagger.domain.thumbnails.ExternalThumbnailCreationCommand;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.jphototagger.tcc.def.scripts.ScriptWriter;
import org.jphototagger.tcc.def.scripts.unix.ImageMagickDcrawThumbnailCreatorDialog;
import org.openide.util.Lookup;

public final class ImageMagickDcrawThumbnailCreator
implements ExternalThumbnailCreationCommand {
    public String getThumbnailCreationCommand() {
        ImageMagickDcrawThumbnailCreatorDialog dialog = new ImageMagickDcrawThumbnailCreatorDialog();
        dialog.setVisible(true);
        if (dialog.isAccepted()) {
            File dcraw = dialog.getDcraw();
            File identify = dialog.getIdentify();
            File convert = dialog.getConvert();
            File mplayer = dialog.getMplayer();
            return this.createCommand(dcraw, identify, convert, mplayer);
        }
        return null;
    }

    public String getDisplayName() {
        return Bundle.getString(ImageMagickDcrawThumbnailCreator.class, (String)"ImageMagickDcrawThumbnailCreator.DisplayName", (Object[])new Object[0]);
    }

    public boolean isEnabled() {
        return !SystemUtil.isWindows();
    }

    private String createCommand(File dcraw, File identify, File convert, File mplayer) {
        if (dcraw == null || identify == null || convert == null) {
            return null;
        }
        PreferencesDirectoryProvider provider = (PreferencesDirectoryProvider)Lookup.getDefault().lookup(PreferencesDirectoryProvider.class);
        File userDirectory = provider.getPluginPreferencesDirectory();
        if (userDirectory == null) {
            this.errorMessageUserDirectory();
            return null;
        }
        ScriptWriter scriptWriter = new ScriptWriter();
        String scriptName = mplayer == null ? "image_magick_dcraw.sh" : "image_magick_dcraw_mplayer.sh";
        String scriptPath = userDirectory.getAbsolutePath() + File.separator + scriptName;
        try {
            this.setReplace(scriptWriter, dcraw, identify, convert, mplayer);
            this.writeScript(scriptName, scriptWriter, new File(scriptPath));
            return "\"" + scriptPath + "\" \"%s\" %i";
        }
        catch (Throwable t) {
            Logger.getLogger(ImageMagickDcrawThumbnailCreator.class.getName()).log(Level.SEVERE, null, t);
            return null;
        }
    }

    private void setReplace(ScriptWriter scriptWriter, File dcraw, File identify, File convert, File mplayer) {
        scriptWriter.addReplace("${dcraw}", dcraw.getAbsolutePath());
        scriptWriter.addReplace("${identify}", identify.getAbsolutePath());
        scriptWriter.addReplace("${convert}", convert.getAbsolutePath());
        if (mplayer != null) {
            scriptWriter.addReplace("${mplayer}", mplayer.getAbsolutePath());
        }
    }

    private void writeScript(String templateName, ScriptWriter scriptWriter, File scriptFile) throws Exception {
        try {
            String readScript = scriptWriter.readScript("/org/jphototagger/tcc/def/scripts/unix/" + templateName);
            readScript = scriptWriter.replaceIn(readScript);
            FileUtil.writeStringAsFile((String)readScript, (File)scriptFile);
            scriptFile.setExecutable(true);
        }
        catch (Throwable t) {
            this.errorMessageGetScript();
            throw t;
        }
    }

    private void errorMessageUserDirectory() {
        String message = Bundle.getString(ImageMagickDcrawThumbnailCreator.class, (String)"ImageMagickDcrawThumbnailCreator.Error.UserDirectory", (Object[])new Object[0]);
        String title = Bundle.getString(ImageMagickDcrawThumbnailCreator.class, (String)"ImageMagickDcrawThumbnailCreator.Error.Title", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    private void errorMessageGetScript() {
        String message = Bundle.getString(ImageMagickDcrawThumbnailCreator.class, (String)"ImageMagickDcrawThumbnailCreator.Error.GetScript", (Object[])new Object[0]);
        String title = Bundle.getString(ImageMagickDcrawThumbnailCreator.class, (String)"ImageMagickDcrawThumbnailCreator.Error.Title", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(null, message, title, 0);
    }
}

