/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.tcc.def.scripts;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.util.SystemProperties;

public final class ScriptWriter {
    private final Map<String, String> replacementOf = new HashMap<String, String>();
    private static final String NEWLINE = SystemProperties.getLineSeparator();

    public void addReplace(String replace, String replacement) {
        if (replace == null) {
            throw new NullPointerException("replace == null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement == null");
        }
        this.replacementOf.put(replace, replacement);
    }

    public void writeScript(String scriptSourcePath, File targetFile) throws IOException {
        if (scriptSourcePath == null) {
            throw new NullPointerException("scriptSourcePath == null");
        }
        if (targetFile == null) {
            throw new NullPointerException("targetFile == null");
        }
        FileUtil.getContentAsBytes((File)targetFile);
        String script = this.readScript(scriptSourcePath);
        String scriptWithReplacements = this.replaceIn(script);
        FileUtil.writeStringAsFile((String)scriptWithReplacements, (File)targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readScript(String scriptSourcePath) throws IOException {
        String string;
        BufferedReader br = null;
        try {
            InputStream is = ScriptWriter.class.getResourceAsStream(scriptSourcePath);
            InputStreamReader isr = new InputStreamReader(is);
            StringBuilder sb = new StringBuilder();
            String line = null;
            boolean isFirstLine = true;
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(isFirstLine ? "" : NEWLINE);
                sb.append(line);
                isFirstLine = false;
            }
            if (sb.length() > 0) {
                sb.append(NEWLINE);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IoUtil.close(br);
            throw throwable;
        }
        IoUtil.close((Closeable)br);
        return string;
    }

    public String replaceIn(String s) {
        if (s == null) {
            throw new NullPointerException("s == null");
        }
        if (this.replacementOf.isEmpty()) {
            return s;
        }
        String replaced = s;
        Set<String> replacementOfKeys = this.replacementOf.keySet();
        for (String replace : replacementOfKeys) {
            String replacement = this.replacementOf.get(replace);
            replaced = replaced.replace(replace, replacement);
        }
        return replaced;
    }
}

