/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.tcc.def;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.jphototagger.domain.filetypes.UserDefinedFileType;
import org.jphototagger.domain.repository.UserDefinedFileTypesRepository;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.tcc.def.SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction;
import org.openide.util.Lookup;

public class SaveFileSuffixesAsUserDefinedFileTypesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Collection<UserDefinedFileType> filetypes;

    protected SaveFileSuffixesAsUserDefinedFileTypesAction(Collection<? extends UserDefinedFileType> filetypes) {
        this.filetypes = new ArrayList<UserDefinedFileType>(filetypes);
    }

    static UserDefinedFileType createUserDefinedFileType(String suffix, String description) {
        UserDefinedFileType fileType = new UserDefinedFileType();
        fileType.setSuffix(suffix);
        fileType.setDescription(description);
        fileType.setExternalThumbnailCreator(true);
        return fileType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.confirmSave()) {
            UserDefinedFileTypesRepository repo = (UserDefinedFileTypesRepository)Lookup.getDefault().lookup(UserDefinedFileTypesRepository.class);
            int saveCount = 0;
            for (UserDefinedFileType filetype : this.filetypes) {
                if (repo.existsUserDefinedFileTypeWithSuffix(filetype.getSuffix())) continue;
                repo.saveUserDefinedFileType(filetype);
                ++saveCount;
            }
            this.showInfoAfterSave(saveCount);
        }
    }

    private boolean confirmSave() {
        String title;
        String message = Bundle.getString(SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction.class, (String)"SaveFileSuffixesAsUserDefinedFileTypesAction.ConfirmSave.Message", (Object[])new Object[0]);
        int result = JOptionPane.showConfirmDialog(null, message, title = Bundle.getString(SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction.class, (String)"SaveFileSuffixesAsUserDefinedFileTypesAction.ConfirmSave.Title", (Object[])new Object[0]), 0);
        return result == 0;
    }

    private void showInfoAfterSave(int saveCount) {
        String pattern = Bundle.getString(SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction.class, (String)"SaveFileSuffixesAsUserDefinedFileTypesAction.InfoAfterSave.MessageTemplate", (Object[])new Object[0]);
        String title = Bundle.getString(SaveMPlayerFileSuffixesAsUserDefinedFileTypesAction.class, (String)"SaveFileSuffixesAsUserDefinedFileTypesAction.InfoAfterSave.Title", (Object[])new Object[0]);
        String message = MessageFormat.format(pattern, saveCount);
        int messageType = 1;
        JOptionPane.showMessageDialog(null, message, title, messageType);
    }
}

