/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.tcc.def;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.jphototagger.domain.thumbnails.ExternalThumbnailCreationCommand;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.jphototagger.tcc.def.FileChooser;
import org.jphototagger.tcc.def.ImageMagickThumbnailCreatorDialog;
import org.jphototagger.tcc.def.Util;

public final class ImageMagickThumbnailCreator
implements ExternalThumbnailCreationCommand {
    private static final String COMMANDLINE_PARAMETERS = "-thumbnail %ix%i -auto-orient \"%s\" jpg:-";
    private final FileChooser fileChooser = this.createFileChooser();

    public String getThumbnailCreationCommand() {
        ImageMagickThumbnailCreatorDialog dialog = new ImageMagickThumbnailCreatorDialog();
        dialog.setVisible(true);
        if (dialog.isBrowse()) {
            Util.browse("http://www.imagemagick.org/");
            return null;
        }
        if (dialog.isChooseConvert()) {
            File convertExecutable = this.fileChooser.chooseFileFixedName();
            return this.createCommand(convertExecutable);
        }
        return null;
    }

    public String getDisplayName() {
        return Bundle.getString(ImageMagickThumbnailCreator.class, (String)"ImageMagickThumbnailCreator.DisplayName", (Object[])new Object[0]);
    }

    public boolean isEnabled() {
        return true;
    }

    private String createCommand(File file) {
        if (file == null) {
            return null;
        }
        return "\"" + file.getAbsolutePath() + "\" " + COMMANDLINE_PARAMETERS;
    }

    private FileChooser createFileChooser() {
        String convertFileName = this.getConvertFileName();
        String convertFileDescription = this.getConvertFileDescription();
        String fileChooserTitle = Bundle.getString(ImageMagickThumbnailCreator.class, (String)"ImageMagickThumbnailCreator.ChooseFile.Dialogtitle", (Object[])new Object[0]);
        return new FileChooser.Builder(new HashSet<String>(Arrays.asList(convertFileName))).fileChooserTitle(fileChooserTitle).fileDescription(convertFileDescription).build();
    }

    private String getConvertFileName() {
        return SystemUtil.isWindows() ? "convert.exe" : "convert";
    }

    private String getConvertFileDescription() {
        String bundleKeyDescription = SystemUtil.isWindows() ? "ImageMagickThumbnailCreator.FileFilter.Description.Windows" : "ImageMagickThumbnailCreator.FileFilter.Description.OtherOS";
        return Bundle.getString(ImageMagickThumbnailCreator.class, (String)bundleKeyDescription, (Object[])new Object[0]);
    }
}

