/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.laf.jgoodies;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.laf.jgoodies.JGoodiesMiscLookAndFeelProvider;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemUtil;
import org.openide.util.Lookup;

public class JGoodiesMiscLookAndFeelSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> PREF_KEY_CLASSNAMES = new LinkedHashMap<String, String>();
    public static final String WINDOWS_LAF_CLASSNAME = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    private boolean listen = true;
    private final ComboBoxModel<String> classnamesComboBoxModel = new DefaultComboBoxModel<String>(){
        private static final long serialVersionUID = 1L;
        {
            for (String key : PREF_KEY_CLASSNAMES.keySet()) {
                String classname = (String)PREF_KEY_CLASSNAMES.get(key);
                boolean isWindowsLafClassname = JGoodiesMiscLookAndFeelSettingsPanel.WINDOWS_LAF_CLASSNAME.equals(classname);
                boolean add = !isWindowsLafClassname || isWindowsLafClassname && SystemUtil.isWindows();
                if (!add) continue;
                this.addElement(classname);
            }
        }
    };
    private final ListCellRenderer<String> classnamesListCellRenderer = new ListCellRenderer<String>(){
        private final DefaultListCellRenderer delegate = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setText(Bundle.getString(JGoodiesMiscLookAndFeelSettingsPanel.class, (String)value, (Object[])new Object[0]));
            return label;
        }
    };
    private JComboBox<String> comboBoxClassNames;
    private JLabel labelClassNames;

    public JGoodiesMiscLookAndFeelSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.restoreLookAndFeel();
    }

    private void changeLookAndFeel() {
        this.persistLookAndFeel();
        JGoodiesMiscLookAndFeelProvider provider = new JGoodiesMiscLookAndFeelProvider();
        provider.setLookAndFeel();
        EventBus.publish((Object)new LookAndFeelChangedEvent((Object)this, (Object)provider));
    }

    private void persistLookAndFeel() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("JGoodiesMiscLookAndFeelProvider.LookAndFeel", (String)this.comboBoxClassNames.getSelectedItem());
    }

    private void restoreLookAndFeel() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        String laf = prefs.containsKey("JGoodiesMiscLookAndFeelProvider.LookAndFeel") ? prefs.getString("JGoodiesMiscLookAndFeelProvider.LookAndFeel") : "com.jgoodies.looks.plastic.PlasticLookAndFeel";
        this.listen = false;
        this.comboBoxClassNames.setSelectedItem(laf);
        this.listen = true;
    }

    private void initComponents() {
        this.labelClassNames = new JLabel();
        this.comboBoxClassNames = new JComboBox();
        this.labelClassNames.setLabelFor(this.comboBoxClassNames);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/laf/jgoodies/Bundle");
        this.labelClassNames.setText(bundle.getString("JGoodiesMiscLookAndFeelSettingsPanel.labelClassNames.text"));
        this.comboBoxClassNames.setModel(this.classnamesComboBoxModel);
        this.comboBoxClassNames.setRenderer(this.classnamesListCellRenderer);
        this.comboBoxClassNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGoodiesMiscLookAndFeelSettingsPanel.this.comboBoxClassNamesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelClassNames).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboBoxClassNames, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoxClassNames, -2, -1, -2).addComponent(this.labelClassNames)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void comboBoxClassNamesActionPerformed(ActionEvent evt) {
        if (this.listen) {
            this.changeLookAndFeel();
        }
    }

    static {
        PREF_KEY_CLASSNAMES.put("JGoodiesMiscLookAndFeel.PlasticLookAndFeel", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        PREF_KEY_CLASSNAMES.put("JGoodiesMiscLookAndFeel.Plastic3DLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        PREF_KEY_CLASSNAMES.put("JGoodiesMiscLookAndFeel.PlasticXPLookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        PREF_KEY_CLASSNAMES.put("JGoodiesMiscLookAndFeel.WindowsLookAndFeel", WINDOWS_LAF_CLASSNAME);
    }
}

