/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.laf.defaults;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.jphototagger.api.windows.LookAndFeelProvider;
import org.jphototagger.laf.LafUtil;
import org.jphototagger.laf.defaults.SystemLookAndFeelProvider;
import org.jphototagger.lib.util.Bundle;

public final class CrossPlatformLookAndFeelProvider
implements LookAndFeelProvider {
    private static final String LAF_CLASSNAME = UIManager.getCrossPlatformLookAndFeelClassName();
    private static final Logger LOGGER = Logger.getLogger(SystemLookAndFeelProvider.class.getName());

    public String getDisplayname() {
        return Bundle.getString(CrossPlatformLookAndFeelProvider.class, (String)"CrossPlatformLookAndFeelProvider.Displayname", (Object[])new Object[0]);
    }

    public String getDescription() {
        return Bundle.getString(CrossPlatformLookAndFeelProvider.class, (String)"CrossPlatformLookAndFeelProvider.Description", (Object[])new Object[0]);
    }

    public Component getPreferencesComponent() {
        return null;
    }

    public String getPreferencesKey() {
        return "CrossPlatformLookuAndFeelProvider";
    }

    public boolean canInstall() {
        return LafUtil.canInstall(LAF_CLASSNAME);
    }

    public void setLookAndFeel() {
        LOGGER.info("Setting Cross Platform Look and Feel");
        try {
            MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            UIManager.setLookAndFeel(LAF_CLASSNAME);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, null, t);
        }
    }

    public int getPosition() {
        return 0;
    }
}

