/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.laf;

import javax.swing.UIManager;

public final class LafUtil {
    public static boolean canInstall(String classname) {
        if (classname == null) {
            throw new NullPointerException("classname == null");
        }
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!classname.equals(info.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static String findLookuAndFeel(String classNameWithoutPackagePath, String defaultPath) {
        if (defaultPath == null) {
            throw new NullPointerException("defaultPath == null");
        }
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            String lafClassName = info.getClassName();
            if (!lafClassName.toLowerCase().endsWith('.' + classNameWithoutPackagePath.toLowerCase())) continue;
            return lafClassName;
        }
        return defaultPath;
    }

    private LafUtil() {
    }
}

