/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.api.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class PreferencesHints {
    private final List<String> excludedKeys = new ArrayList<String>();
    private final Set<Option> options;

    public PreferencesHints() {
        this.options = EnumSet.noneOf(Option.class);
    }

    public PreferencesHints(Option ... options) {
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        this.options = options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options));
    }

    public void addKeyToExclude(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.excludedKeys.add(key);
    }

    public boolean isExclude(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.excludedKeys.contains(key);
    }

    public boolean isOption(Option option) {
        if (option == null) {
            throw new NullPointerException("option == null");
        }
        return this.options.contains((Object)option);
    }

    public static enum Option {
        SET_TABBED_PANE_CONTENT;

    }
}

