/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.api.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PropertyEvent {
    private final Object source;
    private final Map<Class<?>, Object> properties = Collections.synchronizedMap(new HashMap());

    public PropertyEvent(Object source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public <T> void putProperty(Class<T> key, T property) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.put(key, property);
    }

    public <T> T removeProperty(Class<T> key, T property) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return (T)this.properties.remove(key);
    }

    public boolean containsProperty(Class<?> key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.properties.containsKey(key);
    }

    public <T> T getProperty(Class<T> key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return (T)this.properties.get(key);
    }
}

