/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.iviewsshow;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.storage.CacheDirectoryProvider;
import org.jphototagger.lib.io.FileUtil;
import org.openide.util.Lookup;

final class TemporaryStorage {
    private final String cacheDirectoryPathname = this.getCacheDirectoryPathname();
    static final TemporaryStorage INSTANCE = new TemporaryStorage();

    private TemporaryStorage() {
        this.createCacheDirectoryIfAbsent();
    }

    private String getCacheDirectoryPathname() {
        CacheDirectoryProvider provider = (CacheDirectoryProvider)Lookup.getDefault().lookup(CacheDirectoryProvider.class);
        return provider.getCacheDirectory("IrfanViewSlideshow").getAbsolutePath();
    }

    private void createCacheDirectoryIfAbsent() {
        try {
            FileUtil.ensureDirectoryExists((File)new File(this.cacheDirectoryPathname));
        }
        catch (Throwable t) {
            Logger.getLogger(TemporaryStorage.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    File getNotExistingSlideshowFile() {
        String basename = this.cacheDirectoryPathname + File.separator + "slideshow.txt";
        File notExistingFile = FileUtil.getNotExistingFile((File)new File(basename));
        String filename = notExistingFile.getAbsolutePath();
        return new File(filename);
    }

    void cleanup() {
        File[] files = new File(this.cacheDirectoryPathname).listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            boolean deleted = file.delete();
            if (deleted) {
                Logger.getLogger(TemporaryStorage.class.getName()).log(Level.INFO, "Deleted temporary slideshow file ''{0}''", file);
                continue;
            }
            Logger.getLogger(TemporaryStorage.class.getName()).log(Level.WARNING, "Couldn''t delete temporary slideshow file ''{0}''", file);
        }
    }
}

