/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.iviewsshow;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.lib.io.filefilter.AcceptExactFilenamesFileFilter;
import org.jphototagger.lib.swing.FileChooserHelper;
import org.jphototagger.lib.swing.FileChooserProperties;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

final class IrfanViewSlideshowCommand {
    private String irfanViewExecutablePath;
    private static final String PROGRAM_FILES_DIRECTORY_PATH = System.getenv("ProgramFiles");
    private boolean isReloadOnLoop;
    private static final Set<String> VALID_IRFAN_VIEW_EXECUTABLE_NAMES = new HashSet<String>();

    IrfanViewSlideshowCommand() {
        this.setReloadOnLoop();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    private void setReloadOnLoop() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        this.isReloadOnLoop = prefs.getBoolean("IrfanViewSlideshow.ReloadOnLoop");
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPropertyChanged(PreferencesChangedEvent evt) {
        String propertyKey = evt.getKey();
        if ("IrfanViewSlideshow.ReloadOnLoop".equals(propertyKey)) {
            this.isReloadOnLoop = (Boolean)evt.getNewValue();
        }
    }

    String[] getCommandArrayForFile(String filepath) {
        if (!this.ensureExecutablePathExists()) {
            return null;
        }
        String reloadOnLoopParam = this.isReloadOnLoop ? " /reloadonloop" : "";
        String slideshowParam = "/slideshow=\"" + filepath + "\"";
        return new String[]{this.irfanViewExecutablePath, slideshowParam, reloadOnLoopParam};
    }

    private boolean ensureExecutablePathExists() {
        if (this.irfanViewExecutablePath != null) {
            return true;
        }
        this.irfanViewExecutablePath = this.lookupRepositoryForExecutablePath();
        if (this.irfanViewExecutablePath != null) {
            return true;
        }
        this.irfanViewExecutablePath = this.chooseIrfanViewExcecutable();
        return this.irfanViewExecutablePath != null;
    }

    private String lookupRepositoryForExecutablePath() {
        ProgramsRepository repo = (ProgramsRepository)Lookup.getDefault().lookup(ProgramsRepository.class);
        List programs = repo.findAllPrograms(ProgramType.PROGRAM);
        for (Program program : programs) {
            File programFile = program.getFile();
            boolean irfanViewProgramExists = VALID_IRFAN_VIEW_EXECUTABLE_NAMES.contains(programFile.getName());
            if (!irfanViewProgramExists) continue;
            return programFile.getAbsolutePath();
        }
        return null;
    }

    private String chooseIrfanViewExcecutable() {
        File irfanViewExecutable = this.chooseIrfanViewExecutable();
        if (irfanViewExecutable == null) {
            return null;
        }
        ProgramsRepository repo = (ProgramsRepository)Lookup.getDefault().lookup(ProgramsRepository.class);
        Program program = new Program(irfanViewExecutable, "IrfanView");
        repo.saveProgram(program);
        return irfanViewExecutable.getAbsolutePath();
    }

    private File chooseIrfanViewExecutable() {
        if (!MessageDisplayer.confirmYesNo(null, (String)Bundle.getString(IrfanViewSlideshowCommand.class, (String)"IrfanViewSlideshowCommand.Confirm.ChooseExecutable", (Object[])new Object[0]))) {
            return null;
        }
        FileChooserProperties fcProps = new FileChooserProperties();
        fcProps.dialogTitle(Bundle.getString(IrfanViewSlideshowCommand.class, (String)"IrfanViewSlideshowCommand.FileChooser.Title", (Object[])new Object[0]));
        fcProps.currentDirectoryPath(PROGRAM_FILES_DIRECTORY_PATH == null ? "" : PROGRAM_FILES_DIRECTORY_PATH);
        fcProps.multiSelectionEnabled(false);
        fcProps.fileFilter(this.createFileFilter());
        fcProps.fileSelectionMode(0);
        return FileChooserHelper.chooseFile((FileChooserProperties)fcProps);
    }

    private FileFilter createFileFilter() {
        AcceptExactFilenamesFileFilter filter = new AcceptExactFilenamesFileFilter(VALID_IRFAN_VIEW_EXECUTABLE_NAMES);
        String fileFilterDescription = Bundle.getString(IrfanViewSlideshowCommand.class, (String)"IrfanViewSlideshowCommand.FileFilterDescription", (Object[])new Object[0]);
        return filter.forFileChooser(fileFilterDescription);
    }

    static {
        VALID_IRFAN_VIEW_EXECUTABLE_NAMES.add("i_view32.exe");
    }
}

