/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.flickrupload;

import com.aetrion.flickr.uploader.UploadMetaData;
import com.aetrion.flickr.uploader.Uploader;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.plugin.fileprocessor.FileProcessedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingFinishedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessingStartedEvent;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.domain.thumbnails.ThumbnailProvider;
import org.jphototagger.image.util.ImageUtil;
import org.jphototagger.lib.help.HelpContentProvider;
import org.jphototagger.lib.io.IoUtil;
import org.jphototagger.lib.plugin.AbstractFileProcessorPlugin;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.plugin.flickrupload.Authorization;
import org.jphototagger.plugin.flickrupload.FlickrImageInfoDialog;
import org.jphototagger.plugin.flickrupload.FlickrImageInfoPanel;
import org.jphototagger.plugin.flickrupload.Settings;
import org.jphototagger.plugin.flickrupload.SettingsPanel;
import org.jphototagger.xmp.XmpProperties;
import org.openide.util.Lookup;

public final class FlickrUpload
extends AbstractFileProcessorPlugin
implements Serializable,
HelpContentProvider {
    private static final long serialVersionUID = 1L;
    private static final Icon icon = IconUtil.getImageIcon(FlickrUpload.class, (String)"flickr.png");
    private static final String PROGRESS_BAR_STRING = Bundle.getString(FlickrUpload.class, (String)"FlickrUpload.ProgressBar.String", (Object[])new Object[0]);
    private ProgressHandle progressHandle;

    public String getDisplayName() {
        return Bundle.getString(FlickrUpload.class, (String)"FlickrUpload.Name", (Object[])new Object[0]);
    }

    public String getDescription() {
        return Bundle.getString(FlickrUpload.class, (String)"FlickrUpload.Description", (Object[])new Object[0]);
    }

    public Component getSettingsComponent() {
        return new SettingsPanel();
    }

    public String getHelpContentUrl() {
        return "/org/jphototagger/plugin/flickrupload/help/contents.xml";
    }

    public int getPosition() {
        return 200;
    }

    public Icon getSmallIcon() {
        return icon;
    }

    public void processFiles(Collection<? extends File> files) {
        new Upload(files).start();
    }

    public boolean isAvailable() {
        return true;
    }

    private class Upload
    extends Thread {
        private final Collection<? extends File> files;
        private final Object pBarOwner = this;

        Upload(Collection<? extends File> files) {
            this.files = new ArrayList<File>(files);
            this.setName("Uploading images to Flickr  @ " + FlickrUpload.class.getSimpleName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!new Authorization().authenticate()) {
                return;
            }
            Uploader uploader = this.createUploader();
            FlickrImageInfoDialog dlg = new FlickrImageInfoDialog();
            this.addImages(dlg);
            dlg.setVisible(true);
            if (!dlg.isUpload()) {
                return;
            }
            List<FlickrImageInfoPanel.ImageInfo> uploadImages = dlg.getUploadImages();
            int countOfImagesToUpload = uploadImages.size();
            int countOfProcessedImages = 0;
            FileInputStream is = null;
            boolean success = true;
            EventBus.publish(new FileProcessingStartedEvent((Object)this));
            FlickrUpload.this.progressHandle = ((ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class)).createProgressHandle();
            FlickrUpload.this.progressHandle.progressStarted(this.createStartProgressEvent(countOfImagesToUpload));
            File imageFile = null;
            for (FlickrImageInfoPanel.ImageInfo imageInfo : uploadImages) {
                try {
                    imageFile = imageInfo.getImageFile();
                    is = new FileInputStream(imageFile);
                    uploader.upload(is, this.getUploadMetaData(imageInfo));
                    is.close();
                    EventBus.publish(new FileProcessedEvent((Object)this, imageFile, false));
                    FlickrUpload.this.progressHandle.progressPerformed(this.createPerformedProgressEvent(countOfImagesToUpload, ++countOfProcessedImages));
                }
                catch (Throwable t) {
                    try {
                        this.logDisplayUploadException(t, imageFile);
                        success = false;
                    }
                    catch (Throwable throwable) {
                        IoUtil.close(is);
                        throw throwable;
                    }
                    IoUtil.close((Closeable)is);
                    break;
                }
                IoUtil.close((Closeable)is);
            }
            this.uploadFinished(countOfProcessedImages, success);
        }

        private Uploader createUploader() {
            return new Uploader("1efba3cf4198b683047512bec1429f19", "b58bc39d8aedd4c5");
        }

        private ProgressEvent createStartProgressEvent(int maximum) {
            return new ProgressEvent.Builder().source(this.pBarOwner).minimum(0).maximum(maximum).value(0).stringPainted(true).stringToPaint(PROGRESS_BAR_STRING).build();
        }

        private ProgressEvent createPerformedProgressEvent(int maximum, int value) {
            return new ProgressEvent.Builder().source(this.pBarOwner).minimum(0).maximum(maximum).value(value).stringPainted(true).stringToPaint(PROGRESS_BAR_STRING).build();
        }

        private void uploadFinished(int countOfUploadedImages, boolean success) throws HeadlessException {
            FlickrUpload.this.progressHandle.progressEnded();
            JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(FlickrUpload.class, (String)"FlickrUpload.Info.UploadCount", (Object[])new Object[]{countOfUploadedImages}));
            EventBus.publish(new FileProcessingFinishedEvent((Object)this, success));
        }

        private void logDisplayUploadException(Throwable t, File imageFile) throws HeadlessException {
            Logger.getLogger(FlickrUpload.class.getName()).log(Level.SEVERE, null, t);
            JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(FlickrUpload.class, (String)"FlickrUpload.Error.Upload", (Object[])new Object[]{imageFile}));
        }

        private UploadMetaData getUploadMetaData(FlickrImageInfoPanel.ImageInfo imageInfo) {
            List<String> tags;
            String title;
            UploadMetaData umd = new UploadMetaData();
            String description = imageInfo.getDescription();
            if (!description.isEmpty()) {
                umd.setDescription(description);
            }
            if (!(title = imageInfo.getTitle()).isEmpty()) {
                umd.setTitle(title);
            }
            if (!(tags = imageInfo.getTags()).isEmpty()) {
                umd.setTags(tags);
            }
            return umd;
        }

        private Image getThumbnail(File imageFile) {
            Image thumbnail;
            ThumbnailProvider thumbnailProvider = (ThumbnailProvider)Lookup.getDefault().lookup(ThumbnailProvider.class);
            if (thumbnailProvider != null && (thumbnail = thumbnailProvider.getThumbnail(imageFile)) != null) {
                return ImageUtil.getScaledInstance((Image)thumbnail, (int)150);
            }
            return null;
        }

        private FlickrImageInfoPanel.ImageInfo getImageInfo(File imageFile, Settings settings) {
            List values;
            String value;
            File sidecarFile = XmpProperties.getSidecarfileOf((File)imageFile);
            Image image = this.getThumbnail(imageFile);
            FlickrImageInfoPanel.ImageInfo emptyImageInfo = this.getEmptyImageInfo(image, imageFile);
            if (sidecarFile == null) {
                return emptyImageInfo;
            }
            List pInfos = XmpProperties.getPropertyInfosOfSidecarFile((File)sidecarFile);
            if (pInfos == null) {
                return emptyImageInfo;
            }
            String description = "";
            String title = "";
            List tags = Collections.emptyList();
            if (settings.isAddDcDescription() && (value = XmpProperties.getPropertyValueFrom((Collection)pInfos, (XmpProperties.PropertyValue)XmpProperties.PropertyValue.DC_DESCRIPTION)) != null && !value.isEmpty()) {
                description = value;
            }
            if (settings.isAddPhotoshopHeadline() && (value = XmpProperties.getPropertyValueFrom((Collection)pInfos, (XmpProperties.PropertyValue)XmpProperties.PropertyValue.PHOTOSHOP_HEADLINE)) != null && !value.isEmpty()) {
                title = value;
            }
            if (settings.isAddDcSubjects() && !(values = XmpProperties.getPropertyValuesFrom((Collection)pInfos, (XmpProperties.PropertyValue)XmpProperties.PropertyValue.DC_SUBJECT)).isEmpty()) {
                tags = values;
            }
            return new FlickrImageInfoPanel.ImageInfo(image, imageFile, title, description, tags);
        }

        private FlickrImageInfoPanel.ImageInfo getEmptyImageInfo(Image image, File imageFile) {
            return new FlickrImageInfoPanel.ImageInfo(image, imageFile, "", "", Collections.emptyList());
        }

        private void addImages(FlickrImageInfoDialog dlg) {
            Settings settings = new Settings();
            for (File file : this.files) {
                dlg.addImage(this.getImageInfo(file, settings));
            }
        }
    }
}

