/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.flickrupload;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jphototagger.lib.swing.ImagePanel;
import org.jphototagger.lib.swing.TabOrEnterLeavingTextArea;

public final class FlickrImageInfoPanel
extends JPanel {
    public static final int IMAGE_WIDTH = 150;
    private static final long serialVersionUID = 1L;
    private static final String TAGS_DELIM = ";";
    private File imageFile;
    private JCheckBox checkBoxUpload;
    private JLabel labelDescription;
    private JLabel labelFilename;
    private JLabel labelTags;
    private JLabel labelTitle;
    private ImagePanel panelImage;
    private JScrollPane scrollPaneDescription;
    private JScrollPane scrollPaneTags;
    private JTextArea textAreaDescription;
    private JTextArea textAreaTags;
    private JTextField textFieldTitle;

    public FlickrImageInfoPanel() {
        this.initComponents();
    }

    public FlickrImageInfoPanel(ImageInfo imageInfo) {
        this.initComponents();
        this.setImage(imageInfo.getImage());
        this.setImageFile(imageInfo.getImageFile());
        this.setTitle(imageInfo.getTitle());
        this.setTags(imageInfo.getTags());
        this.setDescription(imageInfo.getDescription());
    }

    public void setFocusToTitle() {
        this.textFieldTitle.requestFocusInWindow();
    }

    public ImageInfo getImageInfo() {
        return new ImageInfo(null, this.imageFile, this.getTitle(), this.getDescription(), this.getTags());
    }

    public void setImageFile(File imageFile) {
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        this.imageFile = imageFile;
        this.setLabelFilename();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    private void setLabelFilename() {
        String name = this.imageFile.getName();
        if (name.length() > 35) {
            name = name.substring(0, 32) + "...";
        }
        this.labelFilename.setText(name);
    }

    public void setTags(Collection<? extends String> tags) {
        if (tags == null) {
            throw new NullPointerException("tags == null");
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String string : tags) {
            sb.append(index == 0 ? "" : TAGS_DELIM);
            sb.append(string);
            ++index;
        }
        this.textAreaTags.setText(sb.toString());
    }

    public List<String> getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.textAreaTags.getText().trim(), TAGS_DELIM);
        while (st.hasMoreTokens()) {
            tags.add(st.nextToken().trim());
        }
        return tags;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("description == null");
        }
        this.textAreaDescription.setText(description);
    }

    public String getDescription() {
        return this.textAreaDescription.getText().trim();
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title == null");
        }
        this.textFieldTitle.setText(title);
    }

    public String getTitle() {
        return this.textFieldTitle.getText().trim();
    }

    public void setUpload(boolean upload) {
        this.checkBoxUpload.setSelected(upload);
    }

    public boolean isUpload() {
        return this.checkBoxUpload.isSelected();
    }

    public void setImage(Image image) {
        this.panelImage.setImage(image);
    }

    private void initComponents() {
        this.checkBoxUpload = new JCheckBox();
        this.panelImage = new ImagePanel();
        this.labelFilename = new JLabel();
        this.labelTitle = new JLabel();
        this.textFieldTitle = new JTextField();
        this.labelDescription = new JLabel();
        this.scrollPaneDescription = new JScrollPane();
        this.textAreaDescription = new TabOrEnterLeavingTextArea();
        this.labelTags = new JLabel();
        this.scrollPaneTags = new JScrollPane();
        this.textAreaTags = new TabOrEnterLeavingTextArea();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.checkBoxUpload.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/plugin/flickrupload/Bundle");
        this.checkBoxUpload.setText(bundle.getString("FlickrImageInfoPanel.checkBoxUpload.text"));
        this.checkBoxUpload.setName("checkBoxUpload");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.checkBoxUpload, gridBagConstraints);
        this.panelImage.setMaximumSize(new Dimension(150, 150));
        this.panelImage.setMinimumSize(new Dimension(150, 150));
        this.panelImage.setName("panelImage");
        this.panelImage.setPreferredSize(new Dimension(150, 150));
        GroupLayout panelImageLayout = new GroupLayout((Container)this.panelImage);
        this.panelImage.setLayout((LayoutManager)panelImageLayout);
        panelImageLayout.setHorizontalGroup(panelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        panelImageLayout.setVerticalGroup(panelImageLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.panelImage, gridBagConstraints);
        this.labelFilename.setText(bundle.getString("FlickrImageInfoPanel.labelFilename.text"));
        this.labelFilename.setName("labelFilename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.add((Component)this.labelFilename, gridBagConstraints);
        this.labelTitle.setLabelFor(this.textFieldTitle);
        this.labelTitle.setText(bundle.getString("FlickrImageInfoPanel.labelTitle.text"));
        this.labelTitle.setName("labelTitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.labelTitle, gridBagConstraints);
        this.textFieldTitle.setColumns(25);
        this.textFieldTitle.setName("textFieldTitle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.textFieldTitle, gridBagConstraints);
        this.labelDescription.setLabelFor(this.textAreaDescription);
        this.labelDescription.setText(bundle.getString("FlickrImageInfoPanel.labelDescription.text"));
        this.labelDescription.setName("labelDescription");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.labelDescription, gridBagConstraints);
        this.scrollPaneDescription.setName("scrollPaneDescription");
        this.textAreaDescription.setColumns(20);
        this.textAreaDescription.setRows(2);
        this.textAreaDescription.setName("textAreaDescription");
        this.scrollPaneDescription.setViewportView(this.textAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.scrollPaneDescription, gridBagConstraints);
        this.labelTags.setLabelFor(this.textAreaTags);
        this.labelTags.setText(bundle.getString("FlickrImageInfoPanel.labelTags.text"));
        this.labelTags.setName("labelTags");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.labelTags, gridBagConstraints);
        this.scrollPaneTags.setName("scrollPaneTags");
        this.textAreaTags.setColumns(20);
        this.textAreaTags.setRows(2);
        this.textAreaTags.setName("textAreaTags");
        this.scrollPaneTags.setViewportView(this.textAreaTags);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.scrollPaneTags, gridBagConstraints);
    }

    public static final class ImageInfo {
        private final Image image;
        private final File imageFile;
        private final String title;
        private final String description;
        private final List<String> tags;

        public ImageInfo(Image image, File imageFile, String title, String description, List<String> tags) {
            if (imageFile == null) {
                throw new NullPointerException("imageFile == null");
            }
            if (title == null) {
                throw new NullPointerException("title == null");
            }
            if (description == null) {
                throw new NullPointerException("description == null");
            }
            if (tags == null) {
                throw new NullPointerException("tags == null");
            }
            this.image = image;
            this.imageFile = imageFile;
            this.title = title;
            this.description = description;
            this.tags = tags;
        }

        public Image getImage() {
            return this.image;
        }

        public String getDescription() {
            return this.description;
        }

        public File getImageFile() {
            return this.imageFile;
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(this.tags);
        }

        public String getTitle() {
            return this.title;
        }
    }
}

