/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.flickrupload;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.plugin.flickrupload.FlickrImageInfoPanel;
import org.openide.util.Lookup;

public class FlickrImageInfoDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final List<FlickrImageInfoPanel.ImageInfo> imageInfos = new ArrayList<FlickrImageInfoPanel.ImageInfo>();
    private boolean upload;
    private JButton buttonCancel;
    private JButton buttonSelectAll;
    private JButton buttonSelectNone;
    private JButton buttonUpload;
    private JPanel panelImageInfos;
    private JScrollPane scrollPane;

    public FlickrImageInfoDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)((Object)this));
    }

    public void addImage(FlickrImageInfoPanel.ImageInfo imageInfo) {
        if (imageInfo == null) {
            throw new NullPointerException("imageInfo == null");
        }
        this.imageInfos.add(imageInfo);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.addImageInfoPanels();
            this.readPersistent();
        } else {
            this.writePersistent();
        }
        super.setVisible(visible);
    }

    private void writePersistent() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.setSize(FlickrImageInfoDialog.class.getName(), (Component)((Object)this));
            prefs.setLocation(FlickrImageInfoDialog.class.getName(), (Component)((Object)this));
        }
    }

    private void readPersistent() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.applySize(FlickrImageInfoDialog.class.getName(), (Component)((Object)this));
            prefs.applyLocation(FlickrImageInfoDialog.class.getName(), (Component)((Object)this));
        }
    }

    private void addImageInfoPanels() {
        int size = this.imageInfos.size();
        int gridy = -1;
        for (int i = 0; i < size; ++i) {
            FlickrImageInfoPanel panel = new FlickrImageInfoPanel(this.imageInfos.get(i));
            boolean even = i % 2 != 0;
            int gridx = even ? 1 : 0;
            gridy = even ? gridy : gridy + 1;
            GridBagConstraints gbc = this.getConstraints(gridx, gridy);
            if (i >= size - 2) {
                gbc.gridheight = 0;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(10, gridx == 0 ? 10 : 5, 10, 10);
            }
            this.panelImageInfos.add((Component)panel, gbc);
        }
    }

    private GridBagConstraints getConstraints(int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 0.5;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = new Insets(10, gridx == 0 ? 10 : 5, 0, 10);
        gbc.fill = 2;
        return gbc;
    }

    public boolean isUpload() {
        return this.upload;
    }

    public List<FlickrImageInfoPanel.ImageInfo> getUploadImages() {
        ArrayList<FlickrImageInfoPanel.ImageInfo> infos = new ArrayList<FlickrImageInfoPanel.ImageInfo>();
        if (this.upload) {
            int count = this.panelImageInfos.getComponentCount();
            for (int i = 0; i < count; ++i) {
                FlickrImageInfoPanel panel = (FlickrImageInfoPanel)this.panelImageInfos.getComponent(i);
                if (!panel.isUpload()) continue;
                infos.add(panel.getImageInfo());
            }
        }
        return infos;
    }

    private void selectImages(boolean select) {
        int count = this.panelImageInfos.getComponentCount();
        for (int i = 0; i < count; ++i) {
            FlickrImageInfoPanel panel = (FlickrImageInfoPanel)this.panelImageInfos.getComponent(i);
            panel.setUpload(select);
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.panelImageInfos = new JPanel();
        this.buttonCancel = new JButton();
        this.buttonUpload = new JButton();
        this.buttonSelectAll = new JButton();
        this.buttonSelectNone = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/plugin/flickrupload/Bundle");
        this.setTitle(bundle.getString("FlickrImageInfoDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FlickrImageInfoDialog.this.formWindowClosing(evt);
            }
        });
        this.scrollPane.setName("scrollPane");
        this.panelImageInfos.setName("panelImageInfos");
        this.panelImageInfos.setLayout(new GridBagLayout());
        this.scrollPane.setViewportView(this.panelImageInfos);
        this.buttonCancel.setText(bundle.getString("FlickrImageInfoDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlickrImageInfoDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonUpload.setText(bundle.getString("FlickrImageInfoDialog.buttonUpload.text"));
        this.buttonUpload.setName("buttonUpload");
        this.buttonUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlickrImageInfoDialog.this.buttonUploadActionPerformed(evt);
            }
        });
        this.buttonSelectAll.setText(bundle.getString("FlickrImageInfoDialog.buttonSelectAll.text"));
        this.buttonSelectAll.setName("buttonSelectAll");
        this.buttonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlickrImageInfoDialog.this.buttonSelectAllActionPerformed(evt);
            }
        });
        this.buttonSelectNone.setText(bundle.getString("FlickrImageInfoDialog.buttonSelectNone.text"));
        this.buttonSelectNone.setName("buttonSelectNone");
        this.buttonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlickrImageInfoDialog.this.buttonSelectNoneActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 494, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonSelectNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUpload))).addContainerGap()));
        layout.linkSize(0, this.buttonCancel, this.buttonSelectAll, this.buttonSelectNone, this.buttonUpload);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 354, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonUpload).addComponent(this.buttonCancel).addComponent(this.buttonSelectAll).addComponent(this.buttonSelectNone)).addContainerGap()));
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void buttonUploadActionPerformed(ActionEvent evt) {
        this.upload = true;
        this.setVisible(false);
    }

    private void buttonSelectAllActionPerformed(ActionEvent evt) {
        this.selectImages(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    private void buttonSelectNoneActionPerformed(ActionEvent evt) {
        this.selectImages(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlickrImageInfoDialog dialog = new FlickrImageInfoDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

