/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.flickrupload;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.auth.Auth;
import com.aetrion.flickr.auth.AuthInterface;
import com.aetrion.flickr.auth.Permission;
import java.awt.Desktop;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

final class Authorization {
    private static final String KEY_TOKEN = "org.jphototagger.plugin.flickrupload.FlickrToken";
    private RequestContext requestContext;
    private String frob;
    private String token;
    private AuthInterface authInterface;
    private boolean authenticated;
    private Auth auth;

    Authorization() {
    }

    public AuthInterface getAuthInterface() {
        assert (this.authenticated);
        return this.authInterface;
    }

    public void deleteToken() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.removeKey(KEY_TOKEN);
        }
    }

    private String getToken() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs == null ? "" : prefs.getString(KEY_TOKEN);
    }

    private void setToken(String token) {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            prefs.setString(KEY_TOKEN, token);
        }
    }

    public boolean authenticate() {
        try {
            Flickr flickr = new Flickr("1efba3cf4198b683047512bec1429f19", "b58bc39d8aedd4c5", new REST());
            Flickr.debugStream = false;
            this.requestContext = RequestContext.getRequestContext();
            this.authInterface = flickr.getAuthInterface();
            this.frob = this.authInterface.getFrob();
            this.token = this.getToken();
            if (this.token == null) {
                this.authenticateViaWebBrowser();
            } else {
                this.auth = new Auth();
                this.auth.setToken(this.token);
            }
            this.requestContext.setAuth(this.auth);
            this.authenticated = true;
            return true;
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, t);
            JOptionPane.showMessageDialog(null, Bundle.getString(Authorization.class, (String)"Auth.Error", (Object[])new Object[0]));
            return false;
        }
    }

    private void authenticateViaWebBrowser() throws Exception {
        URL url = this.authInterface.buildAuthenticationUrl(Permission.DELETE, this.frob);
        JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(Authorization.class, (String)"Auth.Info.GetToken.Browse", (Object[])new Object[0]));
        Desktop.getDesktop().browse(url.toURI());
        JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(Authorization.class, (String)"Auth.Info.GetToken.Confirm", (Object[])new Object[0]));
        this.auth = this.authInterface.getToken(this.frob);
        this.token = this.auth.getToken();
        this.setToken(this.token);
    }
}

