/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.dfwm;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.SelectionItemSelectedEvent;
import org.jphototagger.dfwm.DisplayFilesWithoutMetaDataAction;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.NoMetadataValues;
import org.jphototagger.lib.lookup.SelectedListItemsLookup;
import org.openide.util.Lookup;

public final class FilesWithoutMetaDataPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final SelectedListItemsLookup selectedListItemsLookup;
    private final DisplayFilesWithoutMetaDataAction displayFilesWithoutMetaDataAction;
    private final FilesWithoutMetaDataMetadataListModel listModel = new FilesWithoutMetaDataMetadataListModel();
    private static final String PREFERENCES_KEY = "org.jphototagger.program.app.ui.AppPanel.listNoMetadata";
    private volatile boolean clearingSelection;
    private final ListSelectionListener sectionItemSelectedEventPublisher = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!FilesWithoutMetaDataPanel.this.clearingSelection && !e.getValueIsAdjusting()) {
                EventBus.publish((Object)new SelectionItemSelectedEvent((Object)FilesWithoutMetaDataPanel.this.list, Arrays.asList(FilesWithoutMetaDataPanel.this.list.getSelectedValues())));
            }
        }
    };
    private JXList list;
    private JScrollPane scrollPane;

    public FilesWithoutMetaDataPanel() {
        this.initComponents();
        this.selectedListItemsLookup = new SelectedListItemsLookup((JList)this.list);
        this.displayFilesWithoutMetaDataAction = new DisplayFilesWithoutMetaDataAction(this.selectedListItemsLookup.getLookup());
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.readPreferences();
        this.list.addListSelectionListener(this.sectionItemSelectedEventPublisher);
        AnnotationProcessor.process((Object)this);
    }

    public void readPreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.applySelectedIndices(PREFERENCES_KEY, (JList)this.list);
    }

    public void writePreferences() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        prefs.setSelectedIndices(PREFERENCES_KEY, (JList)this.list);
    }

    @EventSubscriber(eventClass=SelectionItemSelectedEvent.class)
    public void sectionItemSelected(SelectionItemSelectedEvent evt) {
        Object source = evt.getSource();
        if (source != this.list) {
            this.clearingSelection = true;
            this.list.clearSelection();
            this.clearingSelection = false;
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.setName("Form");
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)new FilesWithoutMetaDataListCellRenderer());
        this.list.setName("list");
        this.scrollPane.setViewportView((Component)this.list);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 400, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE)));
    }

    private static class FilesWithoutMetaDataListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private FilesWithoutMetaDataListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof MetaDataValue) {
                MetaDataValue metaDataValue = (MetaDataValue)value;
                label.setText(metaDataValue.getDescription());
                label.setIcon(metaDataValue.getCategoryIcon());
            }
            return label;
        }
    }

    private class FilesWithoutMetaDataMetadataListModel
    extends DefaultListModel<Object> {
        private static final long serialVersionUID = 1L;

        private FilesWithoutMetaDataMetadataListModel() {
            this.addMetaDataValues();
        }

        private void addMetaDataValues() {
            for (MetaDataValue value : NoMetadataValues.get()) {
                this.addElement(value);
            }
        }
    }
}

