/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.dfwm;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.ObjectUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class DisplayFilesWithoutMetaDataAction
implements LookupListener {
    private static final long serialVersionUID = 1L;
    private final Lookup.Result<? extends MetaDataValue> lookupResult;
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final ThumbnailsDisplayer tnDisplayer = (ThumbnailsDisplayer)Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
    private MetaDataValue selectedMetaDataValue;

    public DisplayFilesWithoutMetaDataAction(Lookup lookup) {
        this.lookupResult = lookup.lookupResult(MetaDataValue.class);
        this.listen();
    }

    private void listen() {
        this.lookupResult.addLookupListener((LookupListener)this);
        this.resultChanged(null);
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        if (this.selectedMetaDataValue != null) {
            this.displaySelectedMetaDataValue(evt.getThumbnailsPanelSettings());
        }
    }

    public void resultChanged(LookupEvent evt) {
        Collection metaDataValues = this.lookupResult.allInstances();
        MetaDataValue metaDataValue = this.selectedMetaDataValue = metaDataValues.size() == 1 ? (MetaDataValue)CollectionUtil.getFirstElement((Collection)metaDataValues) : null;
        if (this.selectedMetaDataValue != null) {
            this.displaySelectedMetaDataValue(null);
        }
    }

    private void displaySelectedMetaDataValue(ThumbnailsPanelSettings settings) {
        if (this.selectedMetaDataValue == null) {
            return;
        }
        WaitDisplayer waitDisplayer = (WaitDisplayer)Lookup.getDefault().lookup(WaitDisplayer.class);
        waitDisplayer.show();
        this.setTitle();
        this.displayThumbnails(settings);
        waitDisplayer.hide();
    }

    private void displayThumbnails(ThumbnailsPanelSettings settings) {
        List imageFiles = this.repo.findImageFilesWithoutDataValue(this.selectedMetaDataValue);
        this.tnDisplayer.displayFiles((Collection)imageFiles, OriginOfDisplayedThumbnails.FILES_MATCHING_MISSING_METADATA);
        if (settings != null) {
            this.tnDisplayer.applyThumbnailsPanelSettings(settings);
        }
    }

    private void setTitle() {
        MainWindowManager mainWindowManager = (MainWindowManager)Lookup.getDefault().lookup(MainWindowManager.class);
        mainWindowManager.setMainWindowTitle(Bundle.getString(DisplayFilesWithoutMetaDataAction.class, (String)"FilesWithoutMetaDataDisplayAction.MainWindowTitle", (Object[])new Object[]{this.selectedMetaDataValue.getDescription()}));
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.update(evt.getImageFile(), evt.getXmp(), false);
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.update(evt.getImageFile(), evt.getXmp(), true);
    }

    private void update(File imageFile, Xmp xmp, boolean deleted) {
        if (this.selectedMetaDataValue == null) {
            return;
        }
        boolean containsMdv = !deleted && xmp.contains(this.selectedMetaDataValue);
        boolean imageDisplayed = this.tnDisplayer.isDisplayFile(imageFile);
        if (imageDisplayed && containsMdv || !imageDisplayed && !containsMdv) {
            this.displaySelectedMetaDataValue(this.createThumbnailsPanelSettings());
        }
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        Object updatedValue;
        if (this.selectedMetaDataValue == null) {
            return;
        }
        Object oldValue = evt.getOldXmp().getValue(this.selectedMetaDataValue);
        if (!ObjectUtil.equals((Object)oldValue, (Object)(updatedValue = evt.getUpdatedXmp().getValue(this.selectedMetaDataValue)))) {
            this.displaySelectedMetaDataValue(this.createThumbnailsPanelSettings());
        }
    }

    public ThumbnailsPanelSettings createThumbnailsPanelSettings() {
        ThumbnailsPanelSettings settings = new ThumbnailsPanelSettings(this.tnDisplayer.getViewPosition(), Collections.emptyList());
        settings.setSelectedFiles(this.tnDisplayer.getSelectedFiles());
        return settings;
    }
}

