/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.findduplicates;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.event.FileDeletedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.findduplicates.FileDuplicatesFinder;
import org.jphototagger.findduplicates.FileDuplicatesListener;
import org.jphototagger.findduplicates.FileDuplicatesPanel;
import org.jphototagger.findduplicates.FindDuplicatesAction;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.FileSystemViewListCellRenderer;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.SystemProperties;
import org.openide.util.Lookup;

public class FindDuplicatesDialog
extends Dialog {
    private static final String KEY_SOURCE_DIRS = "FindDuplicatesDialog.SourceDirectories";
    private static final String KEY_SOURCE_DIRS_RECURSIVE = "FindDuplicatesDialog.SourceDirectoriesRecursive";
    private static final String KEY_COMPARE_ONLY_EQUAL_FILENAMES = "FindDuplicatesDialog.CompareOnlyEqualFilenames";
    private static final String KEY_COMPARE_ONLY_EQUAL_DATES = "FindDuplicatesDialog.CompareOnlyEqualDates";
    private static final String KEY_DIR_CHOOSER_START_DIRECTORY = "FindDuplicatesDialog.DirChooserStartDir";
    private static final Logger LOGGER = Logger.getLogger(FindDuplicatesDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private final SourceDirectoriesListModel sourceDirectoriesListModel = new SourceDirectoriesListModel();
    private final FileDuplicatesPanel panelFileDuplicates = new FileDuplicatesPanel();
    private static final Comparator<File> DIR_SORT_COMPARATOR = new Comparator<File>(){
        private final Comparator<String> delegate = String.CASE_INSENSITIVE_ORDER;

        @Override
        public int compare(File o1, File o2) {
            String pathname1 = o1.getAbsolutePath();
            String pathname2 = o2.getAbsolutePath();
            return this.delegate.compare(pathname1, pathname2);
        }
    };
    private JButton buttonAddSourceDirectory;
    private JButton buttonDeleteSelectedFiles;
    private JButton buttonRemoveSourceDirectories;
    private JToggleButton buttonSearch;
    private JCheckBox checkBoxCompareOnlyEqualDates;
    private JCheckBox checkBoxCompareOnlyEqualFilenames;
    private JCheckBox checkBoxSourceDirsRecursive;
    private JLabel labelInfo;
    private JList<File> listSourceDirectories;
    private JPanel panelContent;
    private JPanel panelOptions;
    private JPanel panelResult;
    private JPanel panelResultActions;
    private JPanel panelSearchActions;
    private JPanel panelSourceDirectories;
    private JPanel panelSourceDirectoriesActions;
    private JProgressBar progressBarSearch;
    private JScrollPane scrollPaneResult;
    private JScrollPane scrollPaneSourceDirectories;

    FindDuplicatesDialog() {
        super(ComponentUtil.findFrameWithIcon(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.buttonRemoveSourceDirectories.setAction(new RemoveSelectedSourceDirsAction());
        this.buttonSearch.setAction(new SearchAction());
        this.buttonDeleteSelectedFiles.setAction(new DeleteSelectedFilesAction());
        this.addFileDuplicatesPanel();
        MnemonicUtil.setMnemonics((Container)((Object)this));
        AnnotationProcessor.process((Object)((Object)this));
    }

    private void addFileDuplicatesPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.weightx = 1.0;
        panel.add((Component)this.panelFileDuplicates, gbc);
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        panel.add((Component)new JPanel(), gbc);
        this.scrollPaneResult.setViewportView(panel);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.isVisible()) {
                this.toFront();
                return;
            }
            this.restore();
        } else {
            this.persist();
        }
        super.setVisible(visible);
    }

    private void persist() {
        if (this.prefs != null) {
            this.prefs.setBoolean(KEY_SOURCE_DIRS_RECURSIVE, this.checkBoxSourceDirsRecursive.isSelected());
            this.prefs.setBoolean(KEY_COMPARE_ONLY_EQUAL_DATES, this.checkBoxCompareOnlyEqualDates.isSelected());
            this.prefs.setBoolean(KEY_COMPARE_ONLY_EQUAL_FILENAMES, this.checkBoxCompareOnlyEqualFilenames.isSelected());
            this.prefs.setStringCollection(KEY_SOURCE_DIRS, (Collection)FileUtil.getAbsolutePathnames((Collection)this.sourceDirectoriesListModel.getDirs()));
        }
    }

    private void restore() {
        if (this.prefs != null) {
            this.checkBoxSourceDirsRecursive.setSelected(this.prefs.containsKey(KEY_SOURCE_DIRS_RECURSIVE) ? this.prefs.getBoolean(KEY_SOURCE_DIRS_RECURSIVE) : true);
            this.checkBoxCompareOnlyEqualFilenames.setSelected(this.prefs.containsKey(KEY_COMPARE_ONLY_EQUAL_FILENAMES) ? this.prefs.getBoolean(KEY_COMPARE_ONLY_EQUAL_FILENAMES) : false);
            this.checkBoxCompareOnlyEqualDates.setSelected(this.prefs.containsKey(KEY_COMPARE_ONLY_EQUAL_DATES) ? this.prefs.getBoolean(KEY_COMPARE_ONLY_EQUAL_DATES) : false);
            this.sourceDirectoriesListModel.setDirs(FileUtil.getStringsAsFiles((Collection)this.prefs.getStringCollection(KEY_SOURCE_DIRS)));
        }
    }

    protected void escape() {
        this.persist();
        super.escape();
    }

    private void addSourceDirectories() {
        DirectoryChooser dirChooser = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), this.getStartDirectory(), new DirectoryChooser.Option[]{DirectoryChooser.Option.MULTI_SELECTION});
        dirChooser.setVisible(true);
        if (dirChooser.isAccepted()) {
            List selDirs = dirChooser.getSelectedDirectories();
            this.sourceDirectoriesListModel.add(selDirs);
            if (!selDirs.isEmpty()) {
                this.prefs.setString(KEY_DIR_CHOOSER_START_DIRECTORY, ((File)selDirs.get(0)).getAbsolutePath());
            }
        }
    }

    private File getStartDirectory() {
        String userHomeName = SystemProperties.getUserHome();
        File dir = new File(this.prefs.containsKey(KEY_DIR_CHOOSER_START_DIRECTORY) ? this.prefs.getString(KEY_DIR_CHOOSER_START_DIRECTORY) : "");
        return dir.isDirectory() ? dir : (userHomeName != null && new File(userHomeName).isDirectory() ? new File(userHomeName) : new File(""));
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.labelInfo = new JLabel();
        this.panelSourceDirectories = new JPanel();
        this.scrollPaneSourceDirectories = new JScrollPane();
        this.listSourceDirectories = new JList();
        this.panelSourceDirectoriesActions = new JPanel();
        this.checkBoxSourceDirsRecursive = new JCheckBox();
        this.buttonAddSourceDirectory = new JButton();
        this.buttonRemoveSourceDirectories = new JButton();
        this.panelOptions = new JPanel();
        this.checkBoxCompareOnlyEqualFilenames = new JCheckBox();
        this.checkBoxCompareOnlyEqualDates = new JCheckBox();
        this.panelSearchActions = new JPanel();
        this.progressBarSearch = new JProgressBar();
        this.buttonSearch = new JToggleButton();
        this.panelResult = new JPanel();
        this.scrollPaneResult = new JScrollPane();
        this.panelResultActions = new JPanel();
        this.buttonDeleteSelectedFiles = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/findduplicates/Bundle");
        this.setTitle(bundle.getString("FindDuplicatesDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        this.labelInfo.setFont(new Font("Tahoma", 1, 12));
        this.labelInfo.setText(bundle.getString("FindDuplicatesDialog.labelInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.panelContent.add((Component)this.labelInfo, gridBagConstraints);
        this.panelSourceDirectories.setBorder(BorderFactory.createTitledBorder(bundle.getString("FindDuplicatesDialog.panelSourceDirectories.border.title")));
        this.panelSourceDirectories.setLayout(new GridBagLayout());
        this.listSourceDirectories.setModel(this.sourceDirectoriesListModel);
        this.listSourceDirectories.setCellRenderer((ListCellRenderer<File>)new FileSystemViewListCellRenderer(false));
        this.scrollPaneSourceDirectories.setViewportView(this.listSourceDirectories);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelSourceDirectories.add((Component)this.scrollPaneSourceDirectories, gridBagConstraints);
        this.panelSourceDirectoriesActions.setLayout(new GridBagLayout());
        this.checkBoxSourceDirsRecursive.setText(bundle.getString("FindDuplicatesDialog.checkBoxSourceDirsRecursive.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSourceDirectoriesActions.add((Component)this.checkBoxSourceDirsRecursive, gridBagConstraints);
        this.buttonAddSourceDirectory.setText(bundle.getString("FindDuplicatesDialog.buttonAddSourceDirectory.text"));
        this.buttonAddSourceDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDuplicatesDialog.this.buttonAddSourceDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSourceDirectoriesActions.add((Component)this.buttonAddSourceDirectory, gridBagConstraints);
        this.buttonRemoveSourceDirectories.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSourceDirectoriesActions.add((Component)this.buttonRemoveSourceDirectories, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelSourceDirectories.add((Component)this.panelSourceDirectoriesActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelSourceDirectories, gridBagConstraints);
        this.panelOptions.setBorder(BorderFactory.createTitledBorder(bundle.getString("FindDuplicatesDialog.panelOptions.border.title")));
        this.panelOptions.setLayout(new GridBagLayout());
        this.checkBoxCompareOnlyEqualFilenames.setText(bundle.getString("FindDuplicatesDialog.checkBoxCompareOnlyEqualFilenames.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelOptions.add((Component)this.checkBoxCompareOnlyEqualFilenames, gridBagConstraints);
        this.checkBoxCompareOnlyEqualDates.setText(bundle.getString("FindDuplicatesDialog.checkBoxCompareOnlyEqualDates.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelOptions.add((Component)this.checkBoxCompareOnlyEqualDates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelOptions, gridBagConstraints);
        this.panelSearchActions.setLayout(new GridBagLayout());
        this.progressBarSearch.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSearchActions.add((Component)this.progressBarSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSearchActions.add((Component)this.buttonSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelSearchActions, gridBagConstraints);
        this.panelResult.setBorder(BorderFactory.createTitledBorder(bundle.getString("FindDuplicatesDialog.panelResult.border.title")));
        this.panelResult.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelResult.add((Component)this.scrollPaneResult, gridBagConstraints);
        this.panelResultActions.setLayout(new GridBagLayout());
        this.buttonDeleteSelectedFiles.setEnabled(false);
        this.panelResultActions.add((Component)this.buttonDeleteSelectedFiles, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelResult.add((Component)this.panelResultActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.panelContent.add((Component)this.panelResult, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void buttonAddSourceDirectoryActionPerformed(ActionEvent evt) {
        this.addSourceDirectories();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindDuplicatesDialog dialog = new FindDuplicatesDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private final class DeleteSelectedFilesAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final XmpSidecarFileResolver xmpSidecarFileResolver;

        private DeleteSelectedFilesAction() {
            super(Bundle.getString(FindDuplicatesDialog.class, (String)"FindDuplicatesDialog.DeleteSelectedFilesAction.Name", (Object[])new Object[0]));
            this.xmpSidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
            this.init();
        }

        private void init() {
            FindDuplicatesDialog.this.panelFileDuplicates.addPropertyChangeListener("fileSelected", this);
            this.setEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String message = Bundle.getString(FindDuplicatesDialog.class, (String)"FindDuplicatesDialog.DeleteSelectedFilesAction.ConfirmDelete", (Object[])new Object[0]);
            if (MessageDisplayer.confirmYesNo((Component)((Object)FindDuplicatesDialog.this), (String)message)) {
                for (File file : FindDuplicatesDialog.this.panelFileDuplicates.getSelectedFiles()) {
                    if (file.delete()) {
                        EventBus.publish((Object)new FileDeletedEvent((Object)this, file));
                        File xmp = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(file);
                        if (xmp != null) {
                            if (xmp.delete()) {
                                EventBus.publish((Object)new FileDeletedEvent((Object)this, xmp));
                            } else {
                                LOGGER.log(Level.WARNING, "Sidecar file ''{0}'' couldn''t be deleted", xmp);
                            }
                        }
                        FindDuplicatesDialog.this.panelFileDuplicates.removeFile(file);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "File ''{0}'' couldn''t be deleted", file);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled();
        }

        private void setEnabled() {
            this.setEnabled(FindDuplicatesDialog.this.panelFileDuplicates.isFileSelected());
        }
    }

    private class SearchAction
    extends AbstractAction
    implements FileDuplicatesListener,
    ListDataListener {
        private static final long serialVersionUID = 1L;
        private boolean listen = true;
        private final String START_SEARCH_NAME = Bundle.getString(FindDuplicatesAction.class, (String)"FindDuplicatesDialog.SearchAction.Name.StartSearch", (Object[])new Object[0]);
        private final String CANCEL_SEARCH_NAME = Bundle.getString(FindDuplicatesAction.class, (String)"FindDuplicatesDialog.SearchAction.Name.CancelSearch", (Object[])new Object[0]);
        private FileDuplicatesFinder duplicatesFinder;

        private SearchAction() {
            this.init();
        }

        private void init() {
            this.setName(false);
            this.setEnabled();
            FindDuplicatesDialog.this.sourceDirectoriesListModel.addListDataListener(this);
        }

        private void setName(boolean started) {
            this.putValue("Name", started ? this.CANCEL_SEARCH_NAME : this.START_SEARCH_NAME);
            MnemonicUtil.setMnemonics((Container)FindDuplicatesDialog.this.buttonSearch);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.listen) {
                return;
            }
            if (FindDuplicatesDialog.this.buttonSearch.isSelected()) {
                this.startSearch();
            } else {
                this.stopSearch();
            }
        }

        private void startSearch() {
            FindDuplicatesDialog.this.progressBarSearch.setIndeterminate(true);
            this.duplicatesFinder = new FileDuplicatesFinder(FindDuplicatesDialog.this.sourceDirectoriesListModel.getDirs(), FindDuplicatesDialog.this.checkBoxSourceDirsRecursive.isSelected());
            this.duplicatesFinder.setCompareOnlyEqualDates(FindDuplicatesDialog.this.checkBoxCompareOnlyEqualDates.isSelected());
            this.duplicatesFinder.setCompareOnlyEqualFilenames(FindDuplicatesDialog.this.checkBoxCompareOnlyEqualFilenames.isSelected());
            this.duplicatesFinder.addFileDuplicateListener(this);
            FindDuplicatesDialog.this.panelFileDuplicates.clear();
            FindDuplicatesDialog.this.buttonDeleteSelectedFiles.setEnabled(false);
            Thread searchThread = new Thread(this.duplicatesFinder);
            searchThread.setName("JPhotoTagger: Searching duplicates");
            searchThread.start();
        }

        private void stopSearch() {
            if (this.duplicatesFinder != null) {
                this.duplicatesFinder.stop();
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.setEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.setEnabled();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.setEnabled();
        }

        private void setEnabled() {
            boolean srcDirsExisting = FindDuplicatesDialog.this.sourceDirectoriesListModel.getSize() > 0;
            this.setEnabled(srcDirsExisting);
        }

        @Override
        public void setMessage(String message) {
            FindDuplicatesDialog.this.progressBarSearch.setString(message);
        }

        @Override
        public void duplicatesFound(final Collection<? extends File> duplicates) {
            EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FindDuplicatesDialog.this.panelFileDuplicates.addDuplicates(duplicates);
                    FindDuplicatesDialog.this.panelFileDuplicates.revalidate();
                }
            });
        }

        @Override
        public void searchStarted() {
            EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SearchAction.this.setName(true);
                }
            });
        }

        @Override
        public void searchFinished(boolean wasCancelled) {
            EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SearchAction.this.listen = false;
                    FindDuplicatesDialog.this.buttonSearch.setSelected(false);
                    SearchAction.this.listen = true;
                    SearchAction.this.setName(false);
                    FindDuplicatesDialog.this.progressBarSearch.setString("");
                    FindDuplicatesDialog.this.progressBarSearch.setIndeterminate(false);
                }
            });
        }
    }

    private class RemoveSelectedSourceDirsAction
    extends AbstractAction
    implements ListSelectionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;

        private RemoveSelectedSourceDirsAction() {
            this.init();
        }

        private void init() {
            this.putValue("Name", Bundle.getString(FindDuplicatesDialog.class, (String)"FindDuplicatesDialog.RemoveSelectedSourceDirsAction.Name", (Object[])new Object[0]));
            FindDuplicatesDialog.this.listSourceDirectories.addListSelectionListener(this);
            FindDuplicatesDialog.this.listSourceDirectories.addKeyListener(this);
            this.setEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (File selDir : FindDuplicatesDialog.this.listSourceDirectories.getSelectedValuesList()) {
                FindDuplicatesDialog.this.sourceDirectoriesListModel.remove(selDir);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.setEnabled();
            }
        }

        private void setEnabled() {
            boolean dirSelected = FindDuplicatesDialog.this.listSourceDirectories.getSelectedIndex() >= 0;
            this.setEnabled(dirSelected);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                this.actionPerformed(null);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private static class SourceDirectoriesListModel
    implements ListModel<File> {
        private final DefaultListModel<File> delegate = new DefaultListModel();

        private SourceDirectoriesListModel() {
        }

        @Override
        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public File getElementAt(int index) {
            return this.delegate.getElementAt(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.delegate.addListDataListener(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.delegate.removeListDataListener(l);
        }

        private void remove(File dir) {
            this.delegate.removeElement(dir);
        }

        private void add(File dir) {
            if (dir.isDirectory() && !this.delegate.contains(dir)) {
                this.delegate.addElement(dir);
                ListUtil.sort(this.delegate, (Comparator)DIR_SORT_COMPARATOR);
            }
        }

        private void add(Collection<? extends File> dirs) {
            for (File file : dirs) {
                this.add(file);
            }
        }

        private List<File> getDirs() {
            return ListUtil.getElements(this.delegate);
        }

        private void setDirs(List<File> dirs) {
            this.delegate.clear();
            for (File dir : dirs) {
                this.add(dir);
            }
        }
    }
}

