/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.findduplicates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.runtime.External;
import org.jphototagger.lib.runtime.RuntimeUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.ImagePanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class FileDuplicatesPanel
extends JPanel {
    public static final String PROPERTY_FILE_SELECTED = "fileSelected";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FileDuplicatesPanel.class.getName());
    private static final Image ERROR_THUMBNAIL = IconUtil.getIconImage((String)"/org/jphototagger/findduplicates/thumbnail_not_rendered.png");
    private int fileSelectionCount;
    private int rowCount;
    private static final Comparator<File> FILE_SORT_COMPARATOR = new Comparator<File>(){
        private final Comparator<String> delegate = String.CASE_INSENSITIVE_ORDER;

        @Override
        public int compare(File o1, File o2) {
            String pathname1 = o1.getAbsolutePath();
            String pathname2 = o2.getAbsolutePath();
            return this.delegate.compare(pathname1, pathname2);
        }
    };
    private final Action fileSelectedAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("Name", Bundle.getString(FileDuplicatesPanel.this.getClass(), (String)"FileDuplicatesPanel.SelectFile", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            boolean selected = button.isSelected();
            if (selected) {
                FileDuplicatesPanel.this.fileSelectionCount++;
            } else {
                FileDuplicatesPanel.this.fileSelectionCount--;
            }
            FileDuplicatesPanel.this.firePropertyChange(FileDuplicatesPanel.PROPERTY_FILE_SELECTED, !selected, selected);
        }
    };

    public FileDuplicatesPanel() {
        this.initComponents();
    }

    public boolean isFileSelected() {
        return this.fileSelectionCount > 0;
    }

    public void clear() {
        this.rowCount = 0;
        this.fileSelectionCount = 0;
        this.removeAll();
    }

    public int getFileSelectionCount() {
        return this.fileSelectionCount;
    }

    public List<File> getSelectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        List filePanels = ComponentUtil.getAllOf((Container)this, FilePanel.class);
        for (FilePanel filePanel : filePanels) {
            if (!filePanel.isFileSelected()) continue;
            files.add(filePanel.getFile());
        }
        return files;
    }

    public void removeFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        for (FilePanel panel : ComponentUtil.getAllOf((Container)this, FilePanel.class)) {
            if (!panel.getFile().equals(file)) continue;
            panel.getParent().remove(panel);
            if (panel.isFileSelected()) {
                panel.checkBoxFileSelected.removeActionListener(this.fileSelectedAction);
                --this.fileSelectionCount;
                this.firePropertyChange(PROPERTY_FILE_SELECTED, true, false);
            }
            ComponentUtil.forceRepaint((Component)this);
        }
    }

    public void addDuplicates(Collection<? extends File> duplicates) {
        ArrayList<? extends File> dups = new ArrayList<File>(duplicates);
        Collections.sort(dups, FILE_SORT_COMPARATOR);
        JPanel panel = new JPanel(new GridBagLayout());
        boolean first = true;
        for (File file : dups) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, first ? 0 : 10, 0, 0);
            first = false;
            panel.add((Component)new FilePanel(file), gbc);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(this.rowCount == 0 ? 0 : 10, 0, 0, 0);
        gbc.gridwidth = 0;
        this.add((Component)panel, gbc);
        ++this.rowCount;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private final class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ProgramsRepository repo = (ProgramsRepository)Lookup.getDefault().lookup(ProgramsRepository.class);
        private final File file;

        private OpenFileAction(File file) {
            this.file = file;
            this.putValue("Name", Bundle.getString(OpenDirectoryAction.class, (String)"OpenFileAction.Name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Program program = this.findProgramForFile(FileUtil.getSuffix((File)this.file));
            if (program == null) {
                LOGGER.log(Level.INFO, "Open file ''{0}'' with Desktop because no default program is defined", this.file);
                DesktopUtil.open((File)this.file, (String)"FileDuplicatesPanel.OpenFileAction.OpenCommand");
            } else {
                String command = RuntimeUtil.quoteForCommandLine((File[])new File[]{program.getFile(), this.file});
                External.execute((String)command);
            }
        }

        private Program findProgramForFile(String suffix) {
            Program program = this.repo.findDefaultProgram(suffix);
            return program == null ? this.repo.findDefaultImageOpenProgram() : null;
        }
    }

    private final class OpenDirectoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final File directory;

        private OpenDirectoryAction(File directory) {
            this.directory = directory;
            this.putValue("Name", Bundle.getString(OpenDirectoryAction.class, (String)"OpenDirectoryAction.Name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesktopUtil.open((File)this.directory, (String)"FileDuplicatesPanel.OpenDirectoryAction.OpenCommand");
        }
    }

    private final class FilePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JCheckBox checkBoxFileSelected;
        private final File file;

        private FilePanel(File file) {
            this.checkBoxFileSelected = new JCheckBox(FileDuplicatesPanel.this.fileSelectedAction);
            this.file = file;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEtchedBorder());
            Image thumbnail = ThumbnailCreatorService.INSTANCE.createThumbnail(this.file);
            if (thumbnail == null) {
                thumbnail = ERROR_THUMBNAIL;
            }
            ImagePanel imagePanel = new ImagePanel();
            imagePanel.setPreferredSize(new Dimension(thumbnail.getWidth(null), thumbnail.getHeight(null)));
            imagePanel.setImage(thumbnail);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(5, 5, 0, 5);
            this.add((Component)imagePanel, gbc);
            gbc.insets = new Insets(5, 5, 0, 5);
            JLabel labelFilepath = new JLabel();
            labelFilepath.setText(this.getShortFilepath());
            labelFilepath.setToolTipText(this.file.getAbsolutePath());
            this.add((Component)labelFilepath, gbc);
            gbc.insets = new Insets(5, 5, 5, 0);
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 0);
            this.add((Component)this.checkBoxFileSelected, gbc);
            gbc.anchor = 13;
            JButton buttonOpenFile = new JButton(new OpenFileAction(this.file));
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)buttonOpenFile, gbc);
            JButton buttonOpenDir = new JButton(new OpenDirectoryAction(this.file.getParentFile()));
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)buttonOpenDir, gbc);
        }

        private String getShortFilepath() {
            String path = this.file.getAbsolutePath();
            int maxLength = 45;
            int pathLength = path.length();
            if (pathLength > maxLength) {
                return path.substring(0, 11) + "..." + path.substring(pathLength - maxLength + 14);
            }
            return path;
        }

        private boolean isFileSelected() {
            return this.checkBoxFileSelected.isSelected();
        }

        private File getFile() {
            return this.file;
        }
    }
}

