/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.findduplicates;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.filefilter.AppFileFilterProvider;
import org.jphototagger.findduplicates.FileDuplicatesListener;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class FileDuplicatesFinder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(FileDuplicatesFinder.class.getName());
    private final List<FileDuplicatesListener> fileDuplicatesListeners = new CopyOnWriteArrayList<FileDuplicatesListener>();
    private final List<File> sourceDirectories;
    private final boolean recursive;
    private final AppFileFilterProvider fileFilter = (AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class);
    private final Map<Long, Set<File>> filesOfSameSize = new HashMap<Long, Set<File>>();
    private int filecount;
    private volatile boolean compareOnlyEqualFilenames;
    private volatile boolean compareOnlyEqualDates;
    private volatile boolean stop;
    private final FileVisitor<Path> fileVisitor = new FileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return this.isVisit();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileDuplicatesFinder.this.addFile(file.toFile());
            return this.isVisit();
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return this.isVisit();
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return this.isVisit();
        }

        private FileVisitResult isVisit() {
            return FileDuplicatesFinder.this.stop ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
        }
    };

    public FileDuplicatesFinder(List<File> sourceDirectories, boolean recursive) {
        if (sourceDirectories == null) {
            throw new NullPointerException("sourceDirectories == null");
        }
        this.sourceDirectories = new ArrayList<File>(sourceDirectories);
        this.recursive = recursive;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isCompareOnlyEqualFilenames() {
        return this.compareOnlyEqualFilenames;
    }

    public void setCompareOnlyEqualFilenames(boolean compareOnlyEqualFilenames) {
        this.compareOnlyEqualFilenames = compareOnlyEqualFilenames;
    }

    public boolean isCompareOnlyEqualDates() {
        return this.compareOnlyEqualDates;
    }

    public void setCompareOnlyEqualDates(boolean compareOnlyEqualDates) {
        this.compareOnlyEqualDates = compareOnlyEqualDates;
    }

    public void addFileDuplicateListener(FileDuplicatesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.fileDuplicatesListeners.add(listener);
    }

    public void removeFileDuplicateListener(FileDuplicatesListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.fileDuplicatesListeners.remove(listener);
    }

    @Override
    public void run() {
        this.notifySearchStarted();
        this.findFilesOfSameSize();
        this.findDuplicates();
        this.notifySearchFinished();
    }

    private void findFilesOfSameSize() {
        this.filecount = 0;
        int dirCount = this.sourceDirectories.size();
        LOGGER.log(Level.INFO, "Searching {0}{1} directories for files of same size", new Object[]{this.recursive ? "recursively " : "", dirCount});
        this.messageFindFilesOfSameSize();
        for (int dirIndex = 0; dirIndex < dirCount && !this.stop; ++dirIndex) {
            File dir = this.sourceDirectories.get(dirIndex);
            if (!dir.isDirectory()) continue;
            if (this.recursive) {
                try {
                    LOGGER.log(Level.FINE, "Searching directory ''{0}'' recursively for files of same size", dir);
                    Files.walkFileTree(dir.toPath(), this.fileVisitor);
                }
                catch (IOException ex) {
                    Logger.getLogger(FileDuplicatesFinder.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "Searching directory ''{0}'' for files of same size", dir);
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (int fileIndex = 0; fileIndex < files.length && !this.stop; ++fileIndex) {
                this.addFile(files[fileIndex]);
            }
        }
    }

    private void findDuplicates() {
        LOGGER.log(Level.INFO, "Comparing files with same size to find duplicates. Total file count is {0}.", this.filecount);
        this.messageFindDuplicates();
        ArrayList<Long> filesizes = new ArrayList<Long>(this.filesOfSameSize.keySet());
        int fcount = filesizes.size();
        for (int fileIndex = 0; !this.stop && fileIndex < fcount; ++fileIndex) {
            long filesize = (Long)filesizes.get(fileIndex);
            HashSet<File> duplicates = new HashSet<File>();
            ArrayList sameSizedFiles = new ArrayList(this.filesOfSameSize.get(filesize));
            int sameSizedCount = sameSizedFiles.size();
            for (int i = 0; !this.stop && i < sameSizedCount - 1; ++i) {
                File select = (File)sameSizedFiles.get(i);
                for (int j = i + 1; !this.stop && j < sameSizedCount; ++j) {
                    File candidate = (File)sameSizedFiles.get(j);
                    if (!this.isCompare(select, candidate)) continue;
                    LOGGER.log(Level.FINEST, "Comparing file ''{0}'' with ''{1}''", new Object[]{select, candidate});
                    if (!this.equals(select, candidate)) continue;
                    duplicates.add(select);
                    duplicates.add(candidate);
                }
            }
            if (duplicates.size() <= 1) continue;
            this.notifyDuplicatesFound(duplicates);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean equals(File file1, File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCompare(File file1, File file2) {
        assert (file1.length() == file2.length());
        if (this.compareOnlyEqualFilenames && !file1.getName().equals(file2.getName())) {
            return false;
        }
        return !this.compareOnlyEqualDates || file1.lastModified() == file2.lastModified();
    }

    private void notifySearchStarted() {
        for (FileDuplicatesListener listener : this.fileDuplicatesListeners) {
            listener.searchStarted();
        }
    }

    private void notifySearchFinished() {
        LOGGER.log(Level.INFO, "Stopping finding duplicates. Cancelled: {0}", this.stop);
        for (FileDuplicatesListener listener : this.fileDuplicatesListeners) {
            listener.searchFinished(this.stop);
        }
    }

    private void notifyDuplicatesFound(Collection<? extends File> duplicates) {
        for (FileDuplicatesListener listener : this.fileDuplicatesListeners) {
            listener.duplicatesFound(duplicates);
        }
    }

    private void messageFindFilesOfSameSize() {
        for (FileDuplicatesListener listener : this.fileDuplicatesListeners) {
            listener.setMessage(Bundle.getString(FileDuplicatesFinder.class, (String)"FileDuplicatesFinder.MessageFindFilesOfSameSize", (Object[])new Object[0]));
        }
    }

    private void messageFindDuplicates() {
        for (FileDuplicatesListener listener : this.fileDuplicatesListeners) {
            listener.setMessage(Bundle.getString(FileDuplicatesFinder.class, (String)"FileDuplicatesFinder.MessageFindDuplicates", (Object[])new Object[]{this.filecount}));
        }
    }

    private void addFile(File file) {
        if (file.isFile() && this.fileFilter.isAcceptedImageFile(file)) {
            Long size = file.length();
            Set<File> sameSizedFiles = this.filesOfSameSize.get(size);
            if (sameSizedFiles == null) {
                sameSizedFiles = new HashSet<File>();
                this.filesOfSameSize.put(size, sameSizedFiles);
            }
            sameSizedFiles.add(file);
            ++this.filecount;
        }
    }
}

