/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.synonyms;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.synonyms.SynonymsListModel;
import org.openide.util.Lookup;

public class SynonymsPanel
extends JPanel
implements ListSelectionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private final SynonymsListModel modelWords = new SynonymsListModel(SynonymsListModel.Role.WORDS);
    private final SynonymsListModel modelSynonyms = new SynonymsListModel(SynonymsListModel.Role.SYNONYMS);
    private Autocomplete autocomplete;
    private boolean listenToDocuments = true;
    private final ImageFilesRepository repo = (ImageFilesRepository)Lookup.getDefault().lookup(ImageFilesRepository.class);
    private JButton buttonAddAllKeywords;
    private JButton buttonAddSynonym;
    private JButton buttonAddWord;
    private JButton buttonChangeSynonym;
    private JButton buttonChangeWord;
    private JButton buttonRemoveSynonym;
    private JButton buttonRemoveWord;
    private JLabel labelInfoAddSynonym;
    private JLabel labelListSynonyms;
    private JLabel labelListWords;
    private JLabel labelTextAreaWord;
    private JLabel labelTextFieldSynonym;
    private JXList listSynonyms;
    private JXList listWords;
    private JMenuItem menuItemChangeSynonym;
    private JMenuItem menuItemChangeWord;
    private JMenuItem menuItemRemoveSynonym;
    private JMenuItem menuItemRemoveWord;
    private JPanel panelAddedSynonyms;
    private JPanel panelAddedWords;
    private JPanel panelEditInputSynonyms;
    private JPanel panelEditInputWord;
    private JPanel panelSynonyms;
    private JPanel panelWords;
    private JPopupMenu popupMenuSynonyms;
    private JPopupMenu popupMenuWords;
    private JScrollPane scrollPaneListSynonyms;
    private JScrollPane scrollPaneListWords;
    private JScrollPane scrollPaneTextAreaWords;
    private JTextArea textAreaWords;
    private JTextField textFieldSynonyms;

    public SynonymsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.listWords.addListSelectionListener((ListSelectionListener)this);
        this.listSynonyms.addListSelectionListener((ListSelectionListener)this);
        this.textAreaWords.getDocument().addDocumentListener(this);
        this.textFieldSynonyms.getDocument().addDocumentListener(this);
        MnemonicUtil.setMnemonics((Container)this);
        this.setAutocomplete();
        this.setEnabled();
    }

    private void setAutocomplete() {
        if (this.isAutocomplete()) {
            this.autocomplete = new Autocomplete(this.isAutocompleteFastSearchIgnoreCase());
            this.autocomplete.decorate(this.textAreaWords, AutoCompleteDataOfMetaDataValue.INSTANCE.get((MetaDataValue)XmpDcSubjectsSubjectMetaDataValue.INSTANCE).get(), true);
        }
    }

    private boolean isAutocompleteFastSearchIgnoreCase() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.Autocomplete.IgnoreCase") ? prefs.getBoolean("UserSettings.Autocomplete.IgnoreCase") : false;
    }

    private boolean isAutocomplete() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs == null ? false : (prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            if (evt.getSource() == this.listWords) {
                this.setSynonyms();
            }
            this.setEnabled();
        }
    }

    private void setSynonyms() {
        Object o = this.listWords.getSelectedValue();
        if (o instanceof String) {
            String word = (String)o;
            if (word.trim().isEmpty()) {
                this.modelSynonyms.removeAllElements();
            } else {
                this.modelSynonyms.setWord(word.trim());
            }
        }
    }

    private void setEnabled() {
        this.setEnabledAdd();
        this.setEnabledRemove();
        this.setEnabledChange();
    }

    private void setEnabledAdd() {
        boolean wordExists = !this.textAreaWords.getText().trim().isEmpty();
        boolean synonymExists = !this.textFieldSynonyms.getText().trim().isEmpty();
        boolean wordSelected = this.listWords.getSelectedValue() != null;
        this.buttonAddWord.setEnabled(wordExists);
        this.buttonAddSynonym.setEnabled(synonymExists && wordSelected);
    }

    private void setEnabledRemove() {
        boolean wordSel = this.listWords.getSelectedValue() != null;
        boolean synonymSel = this.listSynonyms.getSelectedValue() != null;
        this.buttonRemoveWord.setEnabled(wordSel);
        this.menuItemRemoveWord.setEnabled(wordSel);
        this.buttonRemoveSynonym.setEnabled(synonymSel);
        this.menuItemRemoveSynonym.setEnabled(synonymSel);
    }

    private void setEnabledChange() {
        boolean wordSel = this.listWords.getSelectedValue() != null;
        boolean synonymSel = this.listSynonyms.getSelectedValue() != null;
        this.buttonChangeWord.setEnabled(wordSel);
        this.menuItemChangeWord.setEnabled(wordSel);
        this.buttonChangeSynonym.setEnabled(synonymSel);
        this.menuItemChangeSynonym.setEnabled(synonymSel);
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (!this.listenToDocuments) {
            return;
        }
        this.setEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (!this.listenToDocuments) {
            return;
        }
        this.setEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        if (!this.listenToDocuments) {
            return;
        }
        this.setEnabled();
    }

    private void addWord() {
        String word = this.textAreaWords.getText().trim();
        if (!word.isEmpty()) {
            this.modelWords.addWord(word);
            this.listenToDocuments = false;
            this.textAreaWords.setText("");
            this.listenToDocuments = true;
            this.setEnabled();
            this.textAreaWords.requestFocusInWindow();
        }
    }

    private void removeWord() {
        Object o = this.listWords.getSelectedValue();
        if (o instanceof String) {
            String word = (String)o;
            String message = Bundle.getString(SynonymsPanel.class, (String)"SynonymsPanel.Confirm.RemoveWord", (Object[])new Object[]{word});
            if (MessageDisplayer.confirmYesNo((Component)this, (String)message)) {
                this.modelWords.removeWord(word);
                this.modelSynonyms.removeAllElements();
            }
        }
    }

    private void changeWord() {
        Object o = this.listWords.getSelectedValue();
        if (o instanceof String) {
            String oldWord = (String)o;
            String info = Bundle.getString(SynonymsPanel.class, (String)"SynonymsPanel.Info.ChangeWord", (Object[])new Object[0]);
            String newWord = MessageDisplayer.input((String)info, (String)oldWord);
            if (newWord != null && !newWord.equals(oldWord)) {
                this.modelWords.changeWord(oldWord, newWord);
                this.modelSynonyms.setWord(newWord);
            }
        }
    }

    private void addSynonym() {
        String synonym = this.textFieldSynonyms.getText().trim();
        if (!synonym.isEmpty()) {
            this.modelSynonyms.addSynonym(synonym);
            this.listenToDocuments = false;
            this.textFieldSynonyms.setText("");
            this.listenToDocuments = true;
            this.setEnabled();
            this.textFieldSynonyms.requestFocusInWindow();
        }
    }

    private void removeSynonym() {
        Object o = this.listSynonyms.getSelectedValue();
        if (o instanceof String) {
            String synonym = (String)o;
            String message = Bundle.getString(SynonymsPanel.class, (String)"SynonymsPanel.Confirm.RemoveSynonym", (Object[])new Object[]{synonym});
            if (MessageDisplayer.confirmYesNo((Component)this, (String)message)) {
                this.modelSynonyms.removeSynonym(synonym);
            }
        }
    }

    private void changeSynonym() {
        Object o = this.listSynonyms.getSelectedValue();
        if (o instanceof String) {
            String oldSynonym = (String)o;
            String info = Bundle.getString(SynonymsPanel.class, (String)"SynonymsPanel.Info.ChangeSynonym", (Object[])new Object[0]);
            String newSynonym = MessageDisplayer.input((String)info, (String)oldSynonym);
            if (newSynonym != null && !newSynonym.equals(oldSynonym)) {
                this.modelSynonyms.changeSynonym(oldSynonym, newSynonym);
            }
        }
    }

    private void addAllKeywords() {
        for (String word : this.repo.findAllDcSubjects()) {
            this.modelWords.addWord(word);
        }
        String message = Bundle.getString(SynonymsPanel.class, (String)"SynonymsPanel.Info.AddAllKeywords", (Object[])new Object[0]);
        MessageDisplayer.information((Component)this, (String)message);
    }

    private void handleListSynonymsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeSynonym();
        } else if (evt.getKeyCode() == 113) {
            this.changeSynonym();
        }
    }

    private void handleListSynonymsMouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick((MouseEvent)evt)) {
            this.changeSynonym();
        }
    }

    private void handleListWordsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeWord();
        } else if (evt.getKeyCode() == 113) {
            this.changeWord();
        }
    }

    private void handleListWordsMouseClicked(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick((MouseEvent)evt)) {
            this.changeWord();
        }
    }

    private void handleTextAreaWordsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.addWord();
        }
    }

    private void handleTextFieldSynonymsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.listWords.getSelectedValue() != null) {
            this.addSynonym();
        }
    }

    private void initComponents() {
        this.popupMenuWords = new JPopupMenu();
        this.menuItemChangeWord = new JMenuItem();
        this.menuItemRemoveWord = new JMenuItem();
        this.popupMenuSynonyms = new JPopupMenu();
        this.menuItemChangeSynonym = new JMenuItem();
        this.menuItemRemoveSynonym = new JMenuItem();
        this.panelWords = new JPanel();
        this.panelEditInputWord = new JPanel();
        this.labelTextAreaWord = new JLabel();
        this.scrollPaneTextAreaWords = new JScrollPane();
        this.textAreaWords = new JTextArea();
        this.buttonAddWord = new JButton();
        this.panelAddedWords = new JPanel();
        this.labelListWords = new JLabel();
        this.scrollPaneListWords = new JScrollPane();
        this.listWords = new JXList();
        this.buttonRemoveWord = new JButton();
        this.buttonChangeWord = new JButton();
        this.buttonAddAllKeywords = new JButton();
        this.panelSynonyms = new JPanel();
        this.panelEditInputSynonyms = new JPanel();
        this.labelTextFieldSynonym = new JLabel();
        this.textFieldSynonyms = new JTextField();
        this.buttonAddSynonym = new JButton();
        this.panelAddedSynonyms = new JPanel();
        this.labelListSynonyms = new JLabel();
        this.scrollPaneListSynonyms = new JScrollPane();
        this.listSynonyms = new JXList();
        this.buttonRemoveSynonym = new JButton();
        this.buttonChangeSynonym = new JButton();
        this.labelInfoAddSynonym = new JLabel();
        this.popupMenuWords.setName("popupMenuWords");
        this.menuItemChangeWord.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuItemChangeWord.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_rename.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/synonyms/Bundle");
        this.menuItemChangeWord.setText(bundle.getString("SynonymsPanel.menuItemChangeWord.text"));
        this.menuItemChangeWord.setName("menuItemChangeWord");
        this.menuItemChangeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.menuItemChangeWordActionPerformed(evt);
            }
        });
        this.popupMenuWords.add(this.menuItemChangeWord);
        this.menuItemRemoveWord.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemRemoveWord.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        this.menuItemRemoveWord.setText(bundle.getString("SynonymsPanel.menuItemRemoveWord.text"));
        this.menuItemRemoveWord.setName("menuItemRemoveWord");
        this.menuItemRemoveWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.menuItemRemoveWordActionPerformed(evt);
            }
        });
        this.popupMenuWords.add(this.menuItemRemoveWord);
        this.popupMenuSynonyms.setName("popupMenuSynonyms");
        this.menuItemChangeSynonym.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.menuItemChangeSynonym.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_rename.png")));
        this.menuItemChangeSynonym.setText(bundle.getString("SynonymsPanel.menuItemChangeSynonym.text"));
        this.menuItemChangeSynonym.setName("menuItemChangeSynonym");
        this.menuItemChangeSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.menuItemChangeSynonymActionPerformed(evt);
            }
        });
        this.popupMenuSynonyms.add(this.menuItemChangeSynonym);
        this.menuItemRemoveSynonym.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemRemoveSynonym.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete.png")));
        this.menuItemRemoveSynonym.setText(bundle.getString("SynonymsPanel.menuItemRemoveSynonym.text"));
        this.menuItemRemoveSynonym.setName("menuItemRemoveSynonym");
        this.menuItemRemoveSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.menuItemRemoveSynonymActionPerformed(evt);
            }
        });
        this.popupMenuSynonyms.add(this.menuItemRemoveSynonym);
        this.setName("Form");
        this.setLayout(new GridLayout(1, 2, 10, 0));
        this.panelWords.setName("panelWords");
        this.panelWords.setLayout(new GridBagLayout());
        this.panelEditInputWord.setName("panelEditInputWord");
        this.panelEditInputWord.setLayout(new GridBagLayout());
        this.labelTextAreaWord.setLabelFor(this.textAreaWords);
        this.labelTextAreaWord.setText(bundle.getString("SynonymsPanel.labelTextAreaWord.text"));
        this.labelTextAreaWord.setName("labelTextAreaWord");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelEditInputWord.add((Component)this.labelTextAreaWord, gridBagConstraints);
        this.scrollPaneTextAreaWords.setHorizontalScrollBarPolicy(31);
        this.scrollPaneTextAreaWords.setVerticalScrollBarPolicy(21);
        this.scrollPaneTextAreaWords.setMinimumSize(new Dimension(7, 18));
        this.scrollPaneTextAreaWords.setName("scrollPaneTextAreaWords");
        this.textAreaWords.setColumns(20);
        this.textAreaWords.setRows(1);
        this.textAreaWords.setName("JPhotoTagger text area for a word with a synonym");
        this.textAreaWords.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SynonymsPanel.this.textAreaWordsKeyPressed(evt);
            }
        });
        this.scrollPaneTextAreaWords.setViewportView(this.textAreaWords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelEditInputWord.add((Component)this.scrollPaneTextAreaWords, gridBagConstraints);
        this.buttonAddWord.setText("+");
        this.buttonAddWord.setToolTipText(bundle.getString("SynonymsPanel.buttonAddWord.toolTipText"));
        this.buttonAddWord.setEnabled(false);
        this.buttonAddWord.setMargin(new Insets(0, 2, 0, 2));
        this.buttonAddWord.setName("buttonAddWord");
        this.buttonAddWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonAddWordActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelEditInputWord.add((Component)this.buttonAddWord, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelWords.add((Component)this.panelEditInputWord, gridBagConstraints);
        this.panelAddedWords.setName("panelAddedWords");
        this.panelAddedWords.setLayout(new GridBagLayout());
        this.labelListWords.setLabelFor((Component)this.listWords);
        this.labelListWords.setText(bundle.getString("SynonymsPanel.labelListWords.text"));
        this.labelListWords.setName("labelListWords");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelAddedWords.add((Component)this.labelListWords, gridBagConstraints);
        this.scrollPaneListWords.setName("scrollPaneListWords");
        this.listWords.setModel((ListModel)this.modelWords);
        this.listWords.setSelectionMode(0);
        this.listWords.setComponentPopupMenu(this.popupMenuWords);
        this.listWords.setName("listWords");
        this.listWords.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SynonymsPanel.this.listWordsMouseClicked(evt);
            }
        });
        this.listWords.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SynonymsPanel.this.listWordsKeyPressed(evt);
            }
        });
        this.scrollPaneListWords.setViewportView((Component)this.listWords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelAddedWords.add((Component)this.scrollPaneListWords, gridBagConstraints);
        this.buttonRemoveWord.setText("-");
        this.buttonRemoveWord.setToolTipText(bundle.getString("SynonymsPanel.buttonRemoveWord.toolTipText"));
        this.buttonRemoveWord.setEnabled(false);
        this.buttonRemoveWord.setMargin(new Insets(0, 2, 0, 2));
        this.buttonRemoveWord.setName("buttonRemoveWord");
        this.buttonRemoveWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonRemoveWordActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelAddedWords.add((Component)this.buttonRemoveWord, gridBagConstraints);
        this.buttonChangeWord.setText("C");
        this.buttonChangeWord.setToolTipText(bundle.getString("SynonymsPanel.buttonChangeWord.toolTipText"));
        this.buttonChangeWord.setEnabled(false);
        this.buttonChangeWord.setMargin(new Insets(0, 2, 0, 2));
        this.buttonChangeWord.setName("buttonChangeWord");
        this.buttonChangeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonChangeWordActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelAddedWords.add((Component)this.buttonChangeWord, gridBagConstraints);
        this.buttonAddAllKeywords.setText(bundle.getString("SynonymsPanel.buttonAddAllKeywords.text"));
        this.buttonAddAllKeywords.setToolTipText(bundle.getString("SynonymsPanel.buttonAddAllKeywords.toolTipText"));
        this.buttonAddAllKeywords.setName("buttonAddAllKeywords");
        this.buttonAddAllKeywords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonAddAllKeywordsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelAddedWords.add((Component)this.buttonAddAllKeywords, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelWords.add((Component)this.panelAddedWords, gridBagConstraints);
        this.add(this.panelWords);
        this.panelSynonyms.setName("panelSynonyms");
        this.panelSynonyms.setLayout(new GridBagLayout());
        this.panelEditInputSynonyms.setName("panelEditInputSynonyms");
        this.panelEditInputSynonyms.setLayout(new GridBagLayout());
        this.labelTextFieldSynonym.setLabelFor(this.textFieldSynonyms);
        this.labelTextFieldSynonym.setText(bundle.getString("SynonymsPanel.labelTextFieldSynonym.text"));
        this.labelTextFieldSynonym.setName("labelTextFieldSynonym");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelEditInputSynonyms.add((Component)this.labelTextFieldSynonym, gridBagConstraints);
        this.textFieldSynonyms.setName("JPhotoTagger text area for a synonym of a word");
        this.textFieldSynonyms.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SynonymsPanel.this.textFieldSynonymsKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelEditInputSynonyms.add((Component)this.textFieldSynonyms, gridBagConstraints);
        this.buttonAddSynonym.setText("+");
        this.buttonAddSynonym.setToolTipText(bundle.getString("SynonymsPanel.buttonAddSynonym.toolTipText"));
        this.buttonAddSynonym.setEnabled(false);
        this.buttonAddSynonym.setMargin(new Insets(0, 2, 0, 2));
        this.buttonAddSynonym.setName("buttonAddSynonym");
        this.buttonAddSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonAddSynonymActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelEditInputSynonyms.add((Component)this.buttonAddSynonym, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelSynonyms.add((Component)this.panelEditInputSynonyms, gridBagConstraints);
        this.panelAddedSynonyms.setName("panelAddedSynonyms");
        this.panelAddedSynonyms.setLayout(new GridBagLayout());
        this.labelListSynonyms.setLabelFor((Component)this.listSynonyms);
        this.labelListSynonyms.setText(bundle.getString("SynonymsPanel.labelListSynonyms.text"));
        this.labelListSynonyms.setName("labelListSynonyms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelAddedSynonyms.add((Component)this.labelListSynonyms, gridBagConstraints);
        this.scrollPaneListSynonyms.setName("scrollPaneListSynonyms");
        this.listSynonyms.setModel((ListModel)this.modelSynonyms);
        this.listSynonyms.setSelectionMode(0);
        this.listSynonyms.setComponentPopupMenu(this.popupMenuSynonyms);
        this.listSynonyms.setName("listSynonyms");
        this.listSynonyms.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SynonymsPanel.this.listSynonymsMouseClicked(evt);
            }
        });
        this.listSynonyms.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SynonymsPanel.this.listSynonymsKeyPressed(evt);
            }
        });
        this.scrollPaneListSynonyms.setViewportView((Component)this.listSynonyms);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelAddedSynonyms.add((Component)this.scrollPaneListSynonyms, gridBagConstraints);
        this.buttonRemoveSynonym.setText("-");
        this.buttonRemoveSynonym.setToolTipText(bundle.getString("SynonymsPanel.buttonRemoveSynonym.toolTipText"));
        this.buttonRemoveSynonym.setEnabled(false);
        this.buttonRemoveSynonym.setMargin(new Insets(0, 2, 0, 2));
        this.buttonRemoveSynonym.setName("buttonRemoveSynonym");
        this.buttonRemoveSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonRemoveSynonymActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelAddedSynonyms.add((Component)this.buttonRemoveSynonym, gridBagConstraints);
        this.buttonChangeSynonym.setText("C");
        this.buttonChangeSynonym.setToolTipText(bundle.getString("SynonymsPanel.buttonChangeSynonym.toolTipText"));
        this.buttonChangeSynonym.setEnabled(false);
        this.buttonChangeSynonym.setMargin(new Insets(0, 2, 0, 2));
        this.buttonChangeSynonym.setName("buttonChangeSynonym");
        this.buttonChangeSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynonymsPanel.this.buttonChangeSynonymActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelAddedSynonyms.add((Component)this.buttonChangeSynonym, gridBagConstraints);
        this.labelInfoAddSynonym.setText(bundle.getString("SynonymsPanel.labelInfoAddSynonym.text"));
        this.labelInfoAddSynonym.setName("labelInfoAddSynonym");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelAddedSynonyms.add((Component)this.labelInfoAddSynonym, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelSynonyms.add((Component)this.panelAddedSynonyms, gridBagConstraints);
        this.add(this.panelSynonyms);
    }

    private void buttonAddWordActionPerformed(ActionEvent evt) {
        this.addWord();
    }

    private void buttonRemoveWordActionPerformed(ActionEvent evt) {
        this.removeWord();
    }

    private void buttonChangeWordActionPerformed(ActionEvent evt) {
        this.changeWord();
    }

    private void buttonAddSynonymActionPerformed(ActionEvent evt) {
        this.addSynonym();
    }

    private void buttonRemoveSynonymActionPerformed(ActionEvent evt) {
        this.removeSynonym();
    }

    private void buttonChangeSynonymActionPerformed(ActionEvent evt) {
        this.changeSynonym();
    }

    private void textAreaWordsKeyPressed(KeyEvent evt) {
        this.handleTextAreaWordsKeyPressed(evt);
    }

    private void textFieldSynonymsKeyPressed(KeyEvent evt) {
        this.handleTextFieldSynonymsKeyPressed(evt);
    }

    private void listSynonymsKeyPressed(KeyEvent evt) {
        this.handleListSynonymsKeyPressed(evt);
    }

    private void listWordsMouseClicked(MouseEvent evt) {
        this.handleListWordsMouseClicked(evt);
    }

    private void listSynonymsMouseClicked(MouseEvent evt) {
        this.handleListSynonymsMouseClicked(evt);
    }

    private void listWordsKeyPressed(KeyEvent evt) {
        this.handleListWordsKeyPressed(evt);
    }

    private void buttonAddAllKeywordsActionPerformed(ActionEvent evt) {
        this.addAllKeywords();
    }

    private void menuItemChangeWordActionPerformed(ActionEvent evt) {
        this.changeWord();
    }

    private void menuItemRemoveWordActionPerformed(ActionEvent evt) {
        this.removeWord();
    }

    private void menuItemRemoveSynonymActionPerformed(ActionEvent evt) {
        this.removeSynonym();
    }

    private void menuItemChangeSynonymActionPerformed(ActionEvent evt) {
        this.changeSynonym();
    }
}

