/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.synonyms;

import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.SynonymsRepository;
import org.jphototagger.domain.repository.event.synonyms.SynonymInsertedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymOfWordDeletedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymOfWordRenamedEvent;
import org.jphototagger.domain.repository.event.synonyms.SynonymRenamedEvent;
import org.jphototagger.domain.repository.event.synonyms.WordDeletedEvent;
import org.jphototagger.domain.repository.event.synonyms.WordRenamedEvent;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class SynonymsListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private boolean listen = true;
    private final Role role;
    private String word;
    private final SynonymsRepository synonymsRepo = (SynonymsRepository)Lookup.getDefault().lookup(SynonymsRepository.class);

    public SynonymsListModel(Role role) {
        if (role == null) {
            throw new NullPointerException("role == null");
        }
        this.role = role;
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    private boolean isRoleSynonymForWord(String word) {
        return this.role.equals((Object)Role.SYNONYMS) && this.word != null && this.word.equals(word);
    }

    public void addWord(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        assert (this.role.equals((Object)Role.WORDS));
        if (this.role.equals((Object)Role.WORDS) && !this.contains(word)) {
            this.addElement(word);
        }
    }

    public void removeWord(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        assert (this.role.equals((Object)Role.WORDS));
        if (this.role.equals((Object)Role.WORDS) && this.contains(word)) {
            this.listen = false;
            this.synonymsRepo.deleteWord(word);
            this.listen = true;
            this.removeElement(word);
        }
    }

    public void changeWord(String oldWord, String newWord) {
        if (oldWord == null) {
            throw new NullPointerException("oldWord == null");
        }
        if (newWord == null) {
            throw new NullPointerException("newWord == null");
        }
        assert (this.role.equals((Object)Role.WORDS) && !oldWord.equals(newWord));
        if (this.role.equals((Object)Role.WORDS) && this.contains(oldWord)) {
            this.listen = false;
            this.synonymsRepo.updateWord(oldWord, newWord);
            this.listen = true;
            this.setElementAt(newWord, this.indexOf(oldWord));
        }
    }

    public void addSynonym(String synonym) {
        if (synonym == null) {
            throw new NullPointerException("synonym == null");
        }
        assert (this.role.equals((Object)Role.SYNONYMS) && this.word != null);
        if (this.role.equals((Object)Role.SYNONYMS) && this.word != null && !this.contains(synonym)) {
            this.listen = false;
            if (this.synonymsRepo.saveSynonym(this.word, synonym) == 1) {
                this.addElement(synonym);
            } else {
                String message = Bundle.getString(SynonymsListModel.class, (String)"SynonymsListModel.Error.AddSynonym", (Object[])new Object[]{this.word, synonym});
                MessageDisplayer.error(null, (String)message);
            }
            this.listen = true;
        }
    }

    public void removeSynonym(String synonym) {
        if (synonym == null) {
            throw new NullPointerException("synonym == null");
        }
        assert (this.role.equals((Object)Role.SYNONYMS) && this.word != null);
        if (this.role.equals((Object)Role.SYNONYMS) && this.word != null && this.contains(synonym)) {
            this.listen = false;
            if (this.synonymsRepo.deleteSynonym(this.word, synonym) == 1) {
                this.removeElement(synonym);
            }
            this.listen = true;
        }
    }

    public void changeSynonym(String oldSynonym, String newSynonym) {
        if (newSynonym == null) {
            throw new NullPointerException("newSynonym == null");
        }
        if (newSynonym == null) {
            throw new NullPointerException("newSynonym == null");
        }
        assert (this.role.equals((Object)Role.SYNONYMS) && this.word != null && !oldSynonym.equals(newSynonym));
        if (this.role.equals((Object)Role.SYNONYMS) && this.word != null && this.contains(oldSynonym)) {
            this.listen = false;
            if (this.synonymsRepo.updateSynonymOfWord(this.word, oldSynonym, newSynonym) == 1) {
                this.setElementAt(newSynonym, this.indexOf(oldSynonym));
            }
            this.listen = true;
        }
    }

    public void setWord(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        SynonymsListModel model = this;
        assert (this.role.equals((Object)Role.SYNONYMS));
        if (this.role.equals((Object)Role.SYNONYMS) && (model.word == null || !model.word.equals(word))) {
            model.word = word;
            this.addElements();
        }
    }

    private void addElements() {
        Repository repo = (Repository)Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        this.removeAllElements();
        this.listen = false;
        if (this.role.equals((Object)Role.WORDS)) {
            for (String w : this.synonymsRepo.findAllWords()) {
                this.addElement(w);
            }
        } else if (this.role.equals((Object)Role.SYNONYMS) && this.word != null) {
            for (String s : this.synonymsRepo.findSynonymsOfWord(this.word)) {
                this.addElement(s);
            }
        }
        this.listen = true;
    }

    private void insertSynonym(String word, String synonym) {
        if (this.listen && this.role.equals((Object)Role.WORDS) && !this.contains(word)) {
            this.addElement(word);
        } else if (this.listen && this.isRoleSynonymForWord(word) && !this.contains(synonym)) {
            this.addElement(synonym);
        }
    }

    private void deleteSynonymOfWord(String word, String synonym) {
        if (this.listen && this.isRoleSynonymForWord(word) && this.contains(synonym)) {
            this.removeElement(synonym);
        } else if (this.listen && this.role.equals((Object)Role.WORDS) && this.contains(word) && !this.synonymsRepo.existsWord(word)) {
            this.removeElement(word);
        }
    }

    private void deleteWord(String word) {
        if (this.listen && this.role.equals((Object)Role.WORDS) && this.contains(word)) {
            this.removeElement(word);
        } else if (this.listen && this.isRoleSynonymForWord(word)) {
            this.removeAllElements();
        }
    }

    private void renameSynonymOfWord(String word, String oldSynonymName, String newSynonymName) {
        if (this.listen && this.isRoleSynonymForWord(word) && this.contains(oldSynonymName)) {
            this.setElementAt(newSynonymName, this.indexOf(oldSynonymName));
        }
    }

    private void renameSynonym(String oldSynonymName, String newSynonymName) {
        if (this.listen && this.role.equals((Object)Role.SYNONYMS) && this.contains(oldSynonymName)) {
            this.setElementAt(newSynonymName, this.indexOf(oldSynonymName));
        }
    }

    private void renameWord(String fromName, String toName) {
        if (this.listen && this.role.equals((Object)Role.WORDS) && this.contains(fromName)) {
            this.setElementAt(toName, this.indexOf(fromName));
        }
    }

    @EventSubscriber(eventClass=SynonymOfWordDeletedEvent.class)
    public void synonymOfWordDeleted(SynonymOfWordDeletedEvent evt) {
        this.deleteSynonymOfWord(this.word, evt.getSynonym());
    }

    @EventSubscriber(eventClass=SynonymInsertedEvent.class)
    public void synonymInserted(SynonymInsertedEvent evt) {
        this.insertSynonym(this.word, evt.getSynonym());
    }

    @EventSubscriber(eventClass=SynonymOfWordRenamedEvent.class)
    public void synonymOfWordRenamed(SynonymOfWordRenamedEvent evt) {
        this.renameSynonymOfWord(this.word, evt.getOldSynonymName(), evt.getNewSynonymName());
    }

    @EventSubscriber(eventClass=SynonymRenamedEvent.class)
    public void synonymRenamed(SynonymRenamedEvent evt) {
        this.renameSynonym(evt.getOldSynonymName(), evt.getNewSynonymName());
    }

    @EventSubscriber(eventClass=WordDeletedEvent.class)
    public void wordDeleted(WordDeletedEvent evt) {
        this.deleteWord(this.word);
    }

    @EventSubscriber(eventClass=WordRenamedEvent.class)
    public void wordRenamed(WordRenamedEvent evt) {
        this.renameWord(evt.getFromName(), evt.getToName());
    }

    public static enum Role {
        WORDS,
        SYNONYMS;

    }
}

