/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles.filerenamers;

import java.io.File;
import java.text.DecimalFormat;
import org.jphototagger.api.file.FileRenameStrategy;
import org.jphototagger.importfiles.NameUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.util.Bundle;

public final class DateSequenceNumberFileRenameStrategy
implements FileRenameStrategy {
    private static final DecimalFormat SEQUENCE_NUMBER_FORMAT = new DecimalFormat();
    private String lastDateString = "";
    private int sequenceNumber;

    public void init() {
        this.sequenceNumber = 0;
        this.lastDateString = "";
    }

    public File suggestNewFile(File sourceFile, String targetDirectoryPath) {
        return this.findNextFile(sourceFile, targetDirectoryPath);
    }

    private File findNextFile(File sourceFile, String targetDirectoryPath) {
        String dateString = NameUtil.getDateString(sourceFile);
        if (!this.lastDateString.equals(dateString)) {
            this.lastDateString = dateString;
            this.sequenceNumber = 0;
        }
        String filenameSuffix = FileUtil.getSuffix((File)sourceFile);
        String dirPathname = targetDirectoryPath + File.separator;
        ++this.sequenceNumber;
        String filePathname = dirPathname + dateString + "-" + SEQUENCE_NUMBER_FORMAT.format(this.sequenceNumber) + '.' + filenameSuffix;
        return new File(filePathname);
    }

    public String getDisplayName() {
        return Bundle.getString(DateSequenceNumberFileRenameStrategy.class, (String)"DateSequenceNumberFileRenameStrategy.DisplayName", (Object[])new Object[0]);
    }

    public int getPosition() {
        return 100;
    }

    static {
        SEQUENCE_NUMBER_FORMAT.setMinimumIntegerDigits(3);
        SEQUENCE_NUMBER_FORMAT.setGroupingUsed(false);
    }
}

