/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.jphototagger.domain.metadata.exif.ExifInfo;
import org.openide.util.Lookup;

public final class NameUtil {
    private static final DecimalFormat DAY_MONTH_FORMAT = new DecimalFormat();
    private static final ExifInfo EXIF_INFO = (ExifInfo)Lookup.getDefault().lookup(ExifInfo.class);

    public static String getDateString(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Calendar calendar = Calendar.getInstance();
        long timeTakenInMillis = EXIF_INFO.getTimeTakenInMillis(file);
        calendar.setTimeInMillis(timeTakenInMillis);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        String delimiter = "-";
        return String.valueOf(year) + delimiter + DAY_MONTH_FORMAT.format(month) + delimiter + DAY_MONTH_FORMAT.format(day);
    }

    private NameUtil() {
    }

    static {
        DAY_MONTH_FORMAT.setMinimumIntegerDigits(2);
    }
}

