/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.swingx.JXPanel;
import org.jphototagger.api.applifecycle.generics.Functor;
import org.jphototagger.api.file.FileRenameStrategy;
import org.jphototagger.api.file.SubdirectoryCreateStrategy;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.editors.RenameTemplatesEditor;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpEditor;
import org.jphototagger.importfiles.ImagePreviewPanel;
import org.jphototagger.importfiles.ImportData;
import org.jphototagger.importfiles.filerenamers.FileRenameStrategyComboBoxModel;
import org.jphototagger.importfiles.subdircreators.SubdirectoryCreateStrategyComboBoxModel;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.PreviousSelectedFiles;
import org.jphototagger.lib.io.filefilter.DirectoryFilter;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.DirectoryChooser;
import org.jphototagger.lib.swing.DisplayNameListCellRenderer;
import org.jphototagger.lib.swing.FileChooserHelper;
import org.jphototagger.lib.swing.FileChooserProperties;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComboBoxUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class ImportImageFilesDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private static final Icon ERROR_ICON = IconUtil.getImageIcon(ImportImageFilesDialog.class, (String)"error.png");
    private static final String KEY_LAST_SRC_DIR = "ImportImageFiles.LastSrcDir";
    private static final String KEY_LAST_TARGET_DIR = "ImportImageFiles.LastTargetDir";
    private static final String KEY_DEL_SRC_AFTER_COPY = "ImportImageFiles.DelSrcAfterCopy";
    private static final String KEY_LAST_SCRIPT_DIR = "ImportImageFiles.LastScriptDir";
    private static final String KEY_SOURCE_STRATEGY = "ImportImageFiles.SourceStrategy";
    private static final String KEY_SCRIPT_FILE = "ImportImageFiles.LastScriptFile";
    private static final String KEY_SUBDIRECTORY_CREATE_STRATEGY = "ImportImageFiles.SubdirectoryCreateStrategy";
    private static final String KEY_FILE_RENAME_STRATEGY = "ImportImageFiles.RenameStrategy";
    private static final String KEY_SKIP_DUPLICATES = "ImportImageFiles.SkipDuplicates";
    private static final Color LABEL_FOREGROUND = ImportImageFilesDialog.getLabelForeground();
    private final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private final PreviousSelectedFiles prevSelectedSourceDirs = new PreviousSelectedFiles("IportImageFilesDialog.SourceDirs", 10);
    private final PreviousSelectedFiles prevSelectedTargetDirs = new PreviousSelectedFiles("IportImageFilesDialog.TargetDirs", 10);
    private File sourceDirectory = new File(this.prefs.getString("ImportImageFiles.LastSrcDir"));
    private File targetDirectory = new File(this.prefs.getString("ImportImageFiles.LastTargetDir"));
    private File scriptFile;
    private Xmp xmp;
    private String lastChoosenScriptDir = "";
    private final List<File> sourceFiles = new ArrayList<File>();
    private final Map<Integer, Component> panelOfSourceStrategyCbIndex = new HashMap<Integer, Component>();
    private Component currentPanelOfSourceStrategy;
    private boolean filesChoosed;
    private boolean accepted;
    private boolean deleteSourceFilesAfterCopying;
    private boolean listenToCheckBox = true;
    private final Action chooseSourceDirAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("Name", Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.ChooseSourceDirAction.Name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportImageFilesDialog.this.chooseSourceDir();
        }
    };
    private final Action chooseTargetDirAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("Name", Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.ChooseTargetDirAction.Name", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportImageFilesDialog.this.chooseTargetDir();
        }
    };
    private final Functor<File> setSourceDirFunctor = new Functor<File>(){

        public void execute(File file) {
            if (file.isDirectory()) {
                ImportImageFilesDialog.this.setSourceDir(file);
            }
        }
    };
    private final Functor<File> setTargetDirFunctor = new Functor<File>(){

        public void execute(File file) {
            if (file.isDirectory()) {
                ImportImageFilesDialog.this.setTargetDir(file);
            }
        }
    };
    private JButton buttonCancel;
    private JButton buttonChooseFiles;
    private JButton buttonChooseScriptFile;
    private JButton buttonChooseSourceDir;
    private JButton buttonChooseTargetDir;
    private JButton buttonEditMetadata;
    private JButton buttonEditRenameTemplates;
    private JButton buttonExpertSettings;
    private JButton buttonOk;
    private JButton buttonRemoveScriptFile;
    private JCheckBox checkBoxDeleteAfterCopy;
    private JCheckBox checkBoxSkipDuplicates;
    private JComboBox<Object> comboBoxFileRenameStrategy;
    private JComboBox<Object> comboBoxSourceStrategy;
    private JComboBox<Object> comboBoxSubdirectoryCreateStrategy;
    private JDialog dialogExpertSettings;
    private JLabel labelChoosenFiles;
    private JLabel labelScriptFileInfo;
    private JLabel labelSourceDir;
    private JLabel labelTargetDir;
    private JPanel panelContent;
    private JXPanel panelDialogControlButtons;
    private JPanel panelExpertSettingsContent;
    private JPanel panelExpertSettingsFill;
    private JPanel panelFileRenameStrategy;
    private JXPanel panelScriptFile;
    private JXPanel panelSelectedFiles;
    private JXPanel panelSourceDirectory;
    private JPanel panelSourceStrategy;
    private JXPanel panelTargetDir;
    private JLabel scriptFileLabel;

    public ImportImageFilesDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics((Container)this.panelSourceDirectory);
        MnemonicUtil.setMnemonics((Container)this.panelSelectedFiles);
        MnemonicUtil.setMnemonics((Container)this.dialogExpertSettings);
        MnemonicUtil.setMnemonics((Container)((Object)this));
        this.initSourceStrategyComboBox();
        this.initDirectories();
        this.lookupPersistedScriptFile();
        this.lookupPersistedLastChoosenScriptDir();
        this.lookupSubdirectoryCreateStrategy();
        this.lookupFileRenameStrategy();
        this.lookupSkipDuplicates();
    }

    private void initDirectories() {
        if (this.sourceDirectory.isDirectory()) {
            this.setDirLabel(this.labelSourceDir, this.sourceDirectory);
        } else {
            this.labelSourceDir.setIcon(ERROR_ICON);
        }
        if (this.targetDirectory.isDirectory()) {
            this.setDirLabel(this.labelTargetDir, this.targetDirectory);
        } else {
            this.labelTargetDir.setIcon(ERROR_ICON);
        }
        this.buttonOk.setEnabled(this.dirsValid());
        this.initDeleteSourceFilesAfterCopying();
    }

    private void initSourceStrategyComboBox() {
        this.panelOfSourceStrategyCbIndex.put(0, (Component)this.panelSourceDirectory);
        this.panelOfSourceStrategyCbIndex.put(1, (Component)this.panelSelectedFiles);
        if (this.prefs.containsKey(KEY_SOURCE_STRATEGY)) {
            int index = this.prefs.getInt(KEY_SOURCE_STRATEGY);
            if (index >= 0 && index < this.comboBoxSourceStrategy.getItemCount()) {
                this.comboBoxSourceStrategy.setSelectedIndex(index);
            }
        } else {
            this.comboBoxSourceStrategy.setSelectedIndex(0);
        }
    }

    private void setSourceStrategy() {
        int index = this.comboBoxSourceStrategy.getSelectedIndex();
        Component c = this.panelOfSourceStrategyCbIndex.get(index);
        if (c == this.currentPanelOfSourceStrategy) {
            return;
        }
        if (this.currentPanelOfSourceStrategy != null) {
            this.panelSourceStrategy.remove(this.currentPanelOfSourceStrategy);
        }
        this.currentPanelOfSourceStrategy = c;
        this.panelSourceStrategy.add(this.currentPanelOfSourceStrategy, this.getSourceStrategyGbc());
        this.pack();
        ComponentUtil.forceRepaint((Component)((Object)this));
        this.prefs.setInt(KEY_SOURCE_STRATEGY, index);
    }

    private GridBagConstraints getSourceStrategyGbc() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.fill = 2;
        return gbc;
    }

    private static Color getLabelForeground() {
        Color foreground = UIManager.getColor("Label.foreground");
        return foreground == null ? Color.BLACK : foreground;
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.HelpPage", (Object[])new Object[0]));
    }

    private void initDeleteSourceFilesAfterCopying() {
        this.listenToCheckBox = false;
        this.checkBoxDeleteAfterCopy.setSelected(this.prefs.getBoolean(KEY_DEL_SRC_AFTER_COPY));
        this.deleteSourceFilesAfterCopying = this.checkBoxDeleteAfterCopy.isSelected();
        this.listenToCheckBox = true;
    }

    public boolean isDeleteSourceFilesAfterCopying() {
        return this.deleteSourceFilesAfterCopying;
    }

    public void setSourceDirectory(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir == null");
        }
        this.sourceDirectory = dir;
        this.initDirectories();
        this.comboBoxSourceStrategy.setSelectedIndex(0);
    }

    public void setTargetDirectory(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir == null");
        }
        this.targetDirectory = dir;
        this.initDirectories();
        this.comboBoxSourceStrategy.setSelectedIndex(1);
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void setAccepted(boolean accepted) {
        this.accepted = accepted;
        this.setVisible(false);
    }

    private void chooseSourceDir() {
        File dir = this.chooseDir(this.sourceDirectory);
        if (dir != null) {
            this.setSourceDir(dir);
        }
    }

    private void setSourceDir(File dir) {
        boolean sourceDirNotEqualsTargetDir;
        boolean bl = sourceDirNotEqualsTargetDir = !this.targetDirectory.exists() || this.checkDirsDifferent(dir, this.targetDirectory);
        if (sourceDirNotEqualsTargetDir) {
            this.sourceDirectory = dir;
            this.filesChoosed = false;
            this.sourceFiles.clear();
            this.persistFilePath(KEY_LAST_SRC_DIR, dir);
            this.prevSelectedSourceDirs.add(dir);
            this.resetLabelChoosedFiles();
            this.setDirLabel(this.labelSourceDir, dir);
        }
        this.setEnabledOkButton();
    }

    private void chooseSourceFiles() {
        JFileChooser fileChooser = new JFileChooser(this.sourceDirectory);
        ImagePreviewPanel imgPanel = new ImagePreviewPanel();
        fileChooser.setAccessory(imgPanel);
        fileChooser.addPropertyChangeListener(imgPanel);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(imgPanel.getFileFilter());
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.sourceFiles.clear();
            File[] selFiles = fileChooser.getSelectedFiles();
            if (selFiles == null || selFiles.length < 1) {
                return;
            }
            this.sourceFiles.addAll(Arrays.asList(selFiles));
            this.sourceDirectory = selFiles[0].getParentFile();
            this.persistFilePath(KEY_LAST_SRC_DIR, this.sourceDirectory);
            this.filesChoosed = true;
            this.resetLabelSourceDir();
            this.setFileLabel(selFiles[0], selFiles.length > 1);
        }
        this.setEnabledOkButton();
    }

    public List<File> getSourceFiles() {
        if (this.filesChoosed) {
            return new ArrayList<File>(this.sourceFiles);
        }
        LinkedList<File> sourceDirectoriesRecursive = new LinkedList<File>();
        sourceDirectoriesRecursive.add(this.sourceDirectory);
        sourceDirectoriesRecursive.addAll(FileUtil.getSubDirectoriesRecursive((File)this.sourceDirectory, null, (DirectoryFilter.Option[])new DirectoryFilter.Option[0]));
        return FileFilterUtil.getImageFilesOfDirectories(sourceDirectoriesRecursive);
    }

    public ImportData createImportData() {
        return new ImportData.Builder(this.getSourceFiles(), this.targetDirectory).deleteSourceFilesAfterCopying(this.deleteSourceFilesAfterCopying).fileRenameStrategy(this.getFileRenameStrategy()).subdirectoryCreateStrategy(this.getSubdirectoryCreateStrategy()).scriptFile(this.scriptFile).xmp(this.xmp).skipDuplicates(this.checkBoxSkipDuplicates.isSelected()).build();
    }

    public boolean filesChoosed() {
        return this.filesChoosed;
    }

    private void chooseTargetDir() {
        File dir = this.chooseDir(this.targetDirectory);
        if (dir != null) {
            this.setTargetDir(dir);
        }
    }

    private void setTargetDir(File dir) {
        boolean targetDirNotEqualsSourceDir;
        boolean bl = targetDirNotEqualsSourceDir = !this.sourceDirectory.exists() || this.checkDirsDifferent(this.sourceDirectory, dir);
        if (targetDirNotEqualsSourceDir) {
            this.targetDirectory = dir;
            this.persistFilePath(KEY_LAST_TARGET_DIR, dir);
            this.prevSelectedTargetDirs.add(dir);
            this.setDirLabel(this.labelTargetDir, dir);
        }
        this.setEnabledOkButton();
    }

    private void setDir(AbstractButton button, Action chooseAction, PreviousSelectedFiles psf, Functor<File> chooseFunctor) {
        JPopupMenu popupMenu = psf.createPopupMenu(chooseFunctor, new File[]{this.sourceDirectory, this.targetDirectory});
        if (popupMenu.getComponentCount() < 1) {
            chooseAction.actionPerformed(null);
        } else {
            popupMenu.add(chooseAction);
            popupMenu.show(button, 0, button.getHeight());
        }
    }

    private void lookupPersistedScriptFile() {
        if (this.prefs.containsKey(KEY_SCRIPT_FILE)) {
            String scriptFilePath = this.prefs.getString(KEY_SCRIPT_FILE);
            File persistedScriptFile = new File(scriptFilePath);
            this.scriptFileLabel.setText(scriptFilePath);
            boolean scriptFileExists = persistedScriptFile.isFile();
            if (scriptFileExists) {
                this.scriptFile = persistedScriptFile;
                this.buttonRemoveScriptFile.setEnabled(true);
            }
            this.scriptFileLabel.setIcon(scriptFileExists ? this.fileSystemView.getSystemIcon(this.scriptFile) : ERROR_ICON);
            this.scriptFileLabel.setForeground(scriptFileExists ? LABEL_FOREGROUND : Color.RED);
        }
    }

    private void chooseAndSetScriptFile() {
        File choosenScriptFile = this.chooseScriptFile();
        if (choosenScriptFile == null) {
            return;
        }
        this.scriptFile = choosenScriptFile;
        String scriptFilePath = this.scriptFile.getAbsolutePath();
        this.persistScriptFile(scriptFilePath);
        this.scriptFileLabel.setText(scriptFilePath);
        this.scriptFileLabel.setIcon(this.fileSystemView.getSystemIcon(this.scriptFile));
        this.buttonRemoveScriptFile.setEnabled(true);
    }

    private void persistScriptFile(String scriptFilePath) {
        this.prefs.setString(KEY_SCRIPT_FILE, scriptFilePath);
    }

    private File chooseScriptFile() {
        String dirOfScriptFile;
        File choosenScriptFile = FileChooserHelper.chooseFile((FileChooserProperties)this.createFileChooserPropertiesForScriptFile());
        if (choosenScriptFile != null && (dirOfScriptFile = choosenScriptFile.getParent()) != null) {
            this.persistLastChoosenScriptDir(dirOfScriptFile);
        }
        return choosenScriptFile;
    }

    private FileChooserProperties createFileChooserPropertiesForScriptFile() {
        FileChooserProperties props = new FileChooserProperties();
        props.currentDirectoryPath(this.lastChoosenScriptDir);
        props.dialogTitle(Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.ChooseScriptFile.FileChooser.Title", (Object[])new Object[0]));
        props.multiSelectionEnabled(false);
        props.fileSelectionMode(0);
        props.propertyKeyPrefix("ImportImageFilesDialog.ChooseScriptFile.FileChooser");
        return props;
    }

    private void persistLastChoosenScriptDir(String scriptDir) {
        this.lastChoosenScriptDir = scriptDir;
        this.prefs.setString(KEY_LAST_SCRIPT_DIR, this.lastChoosenScriptDir);
    }

    private void lookupPersistedLastChoosenScriptDir() {
        if (this.prefs.containsKey(KEY_LAST_SCRIPT_DIR)) {
            this.lastChoosenScriptDir = this.prefs.getString(KEY_LAST_SCRIPT_DIR);
        }
    }

    private void lookupSubdirectoryCreateStrategy() {
        int index;
        if (this.prefs.containsKey(KEY_SUBDIRECTORY_CREATE_STRATEGY) && (index = this.prefs.getInt(KEY_SUBDIRECTORY_CREATE_STRATEGY)) >= 0 && index < this.comboBoxSubdirectoryCreateStrategy.getItemCount()) {
            this.comboBoxSubdirectoryCreateStrategy.setSelectedIndex(index);
        }
    }

    private void persistSubdirectoryCreateStrategy() {
        int selectedIndex = this.comboBoxSubdirectoryCreateStrategy.getSelectedIndex();
        this.prefs.setInt(KEY_SUBDIRECTORY_CREATE_STRATEGY, selectedIndex);
    }

    private void lookupFileRenameStrategy() {
        int index;
        if (this.prefs.containsKey(KEY_FILE_RENAME_STRATEGY) && (index = this.prefs.getInt(KEY_FILE_RENAME_STRATEGY)) >= 0 && index < this.comboBoxFileRenameStrategy.getItemCount()) {
            this.comboBoxFileRenameStrategy.setSelectedIndex(index);
        }
    }

    private void persistFileRenameStrategy() {
        int selectedIndex = this.comboBoxFileRenameStrategy.getSelectedIndex();
        this.prefs.setInt(KEY_FILE_RENAME_STRATEGY, selectedIndex);
    }

    private void lookupSkipDuplicates() {
        this.checkBoxSkipDuplicates.setSelected(this.prefs.containsKey(KEY_SKIP_DUPLICATES) ? this.prefs.getBoolean(KEY_SKIP_DUPLICATES) : true);
    }

    private void persistSkipDuplicates() {
        this.prefs.setBoolean(KEY_SKIP_DUPLICATES, this.checkBoxSkipDuplicates.isSelected());
    }

    private void removeScriptFile() {
        this.scriptFile = null;
        this.scriptFileLabel.setText("");
        this.scriptFileLabel.setIcon(null);
        this.buttonRemoveScriptFile.setEnabled(false);
        this.prefs.removeKey(KEY_SCRIPT_FILE);
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public Xmp getXmp() {
        return this.xmp;
    }

    private void persistFilePath(String key, File file) {
        this.prefs.setString(key, file.getAbsolutePath());
    }

    private File chooseDir(File startDir) {
        DirectoryChooser.Option showHiddenDirs = this.getDirChooserOptionShowHiddenDirs();
        DirectoryChooser dlg = new DirectoryChooser(ComponentUtil.findFrameWithIcon(), startDir, new DirectoryChooser.Option[]{showHiddenDirs});
        dlg.setPreferencesKey("ImportImageFilesDialog.DirChooser");
        dlg.setVisible(true);
        this.toFront();
        return dlg.isAccepted() ? (File)dlg.getSelectedDirectories().get(0) : null;
    }

    private DirectoryChooser.Option getDirChooserOptionShowHiddenDirs() {
        return this.isAcceptHiddenDirectories() ? DirectoryChooser.Option.DISPLAY_HIDDEN_DIRECTORIES : DirectoryChooser.Option.NO_OPTION;
    }

    private boolean isAcceptHiddenDirectories() {
        return this.prefs.containsKey("UserSettings.IsAcceptHiddenDirectories") ? this.prefs.getBoolean("UserSettings.IsAcceptHiddenDirectories") : false;
    }

    private void setDirLabel(JLabel label, File dir) {
        label.setIcon(this.fileSystemView.getSystemIcon(dir));
        label.setText(dir.getAbsolutePath());
    }

    private void setFileLabel(File file, boolean multipleFiles) {
        this.labelChoosenFiles.setIcon(this.fileSystemView.getSystemIcon(file));
        this.labelChoosenFiles.setText(StringUtil.getPrefixDotted((String)file.getName(), (int)20) + (multipleFiles ? ", ..." : ""));
    }

    private void resetLabelChoosedFiles() {
        this.labelChoosenFiles.setIcon(null);
        this.labelChoosenFiles.setText("");
    }

    private void resetLabelSourceDir() {
        this.labelSourceDir.setText("");
        this.labelSourceDir.setIcon(null);
    }

    private void setEnabledOkButton() {
        this.buttonOk.setEnabled(this.dirsValid());
    }

    private boolean dirsValid() {
        if (this.filesChoosed) {
            return !this.sourceFiles.isEmpty() && this.targetDirectory.isDirectory() && this.dirsDifferent();
        }
        return this.existsBothDirs() && this.dirsDifferent();
    }

    private boolean dirsDifferent() {
        return !this.sourceDirectory.equals(this.targetDirectory);
    }

    private boolean existsBothDirs() {
        return this.sourceDirectory.isDirectory() && this.targetDirectory.isDirectory();
    }

    private boolean checkDirsDifferent(File src, File tgt) {
        if (src.equals(tgt)) {
            String message = Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.Error.DirsEquals", (Object[])new Object[0]);
            MessageDisplayer.error((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    private void handleCheckBoxDeleteAfterCopyPerformed() {
        String message;
        if (!this.listenToCheckBox) {
            return;
        }
        boolean selected = this.checkBoxDeleteAfterCopy.isSelected();
        if (selected && !MessageDisplayer.confirmYesNo((Component)((Object)this), (String)(message = Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.Confirm.DeleteAfterCopy", (Object[])new Object[0])))) {
            this.listenToCheckBox = false;
            selected = false;
            this.checkBoxDeleteAfterCopy.setSelected(false);
            this.listenToCheckBox = true;
        }
        this.deleteSourceFilesAfterCopying = selected;
        this.prefs.setBoolean(KEY_DEL_SRC_AFTER_COPY, this.deleteSourceFilesAfterCopying);
    }

    public SubdirectoryCreateStrategy getSubdirectoryCreateStrategy() {
        return (SubdirectoryCreateStrategy)this.comboBoxSubdirectoryCreateStrategy.getSelectedItem();
    }

    public FileRenameStrategy getFileRenameStrategy() {
        return (FileRenameStrategy)this.comboBoxFileRenameStrategy.getSelectedItem();
    }

    private void showExpertSettings() {
        this.dialogExpertSettings.pack();
        this.dialogExpertSettings.setVisible(true);
    }

    private void editRenameTemplates() {
        int selectedIndex = this.comboBoxFileRenameStrategy.getSelectedIndex();
        RenameTemplatesEditor editor = (RenameTemplatesEditor)Lookup.getDefault().lookup(RenameTemplatesEditor.class);
        editor.displayEditor((Component)((Object)this));
        this.comboBoxFileRenameStrategy.setModel(new FileRenameStrategyComboBoxModel());
        if (ComboBoxUtil.isValidIndex(this.comboBoxFileRenameStrategy, (int)selectedIndex)) {
            this.comboBoxFileRenameStrategy.setSelectedIndex(selectedIndex);
        }
    }

    private void initComponents() {
        this.panelSourceDirectory = new JXPanel();
        this.labelSourceDir = new JLabel();
        this.buttonChooseSourceDir = new JButton();
        this.panelSelectedFiles = new JXPanel();
        this.labelChoosenFiles = new JLabel();
        this.buttonChooseFiles = new JButton();
        this.dialogExpertSettings = new Dialog(ComponentUtil.findFrameWithIcon(), true);
        this.panelExpertSettingsContent = new JPanel();
        this.panelScriptFile = new JXPanel();
        this.scriptFileLabel = new JLabel();
        this.buttonRemoveScriptFile = new JButton();
        this.buttonChooseScriptFile = new JButton();
        this.labelScriptFileInfo = new JLabel();
        this.panelExpertSettingsFill = new JPanel();
        this.panelContent = new JPanel();
        this.panelSourceStrategy = new JPanel();
        this.comboBoxSourceStrategy = new JComboBox();
        this.checkBoxDeleteAfterCopy = new JCheckBox();
        this.checkBoxSkipDuplicates = new JCheckBox();
        this.panelTargetDir = new JXPanel();
        this.labelTargetDir = new JLabel();
        this.buttonChooseTargetDir = new JButton();
        this.comboBoxSubdirectoryCreateStrategy = new JComboBox();
        this.panelFileRenameStrategy = new JPanel();
        this.comboBoxFileRenameStrategy = new JComboBox();
        this.buttonEditRenameTemplates = new JButton();
        this.panelDialogControlButtons = new JXPanel();
        this.buttonEditMetadata = new JButton();
        this.buttonExpertSettings = new JButton();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.panelSourceDirectory.setLayout((LayoutManager)new GridBagLayout());
        this.labelSourceDir.setBorder(BorderFactory.createEtchedBorder());
        this.labelSourceDir.setPreferredSize(new Dimension(400, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelSourceDirectory.add((Component)this.labelSourceDir, (Object)gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/importfiles/Bundle");
        this.buttonChooseSourceDir.setText(bundle.getString("ImportImageFilesDialog.buttonChooseSourceDir.text"));
        this.buttonChooseSourceDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonChooseSourceDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSourceDirectory.add((Component)this.buttonChooseSourceDir, (Object)gridBagConstraints);
        this.panelSelectedFiles.setLayout((LayoutManager)new GridBagLayout());
        this.labelChoosenFiles.setBorder(BorderFactory.createEtchedBorder());
        this.labelChoosenFiles.setPreferredSize(new Dimension(400, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelSelectedFiles.add((Component)this.labelChoosenFiles, (Object)gridBagConstraints);
        this.buttonChooseFiles.setText(bundle.getString("ImportImageFilesDialog.buttonChooseFiles.text"));
        this.buttonChooseFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonChooseFilesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFiles.add((Component)this.buttonChooseFiles, (Object)gridBagConstraints);
        this.dialogExpertSettings.setTitle(bundle.getString("ImportImageFilesDialog.dialogExpertSettings.title"));
        this.dialogExpertSettings.getContentPane().setLayout(new GridBagLayout());
        this.panelExpertSettingsContent.setLayout(new GridBagLayout());
        this.panelScriptFile.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("ImportImageFilesDialog.panelScriptFile.border.title")));
        this.panelScriptFile.setLayout((LayoutManager)new GridBagLayout());
        this.scriptFileLabel.setBorder(BorderFactory.createEtchedBorder());
        this.scriptFileLabel.setPreferredSize(new Dimension(400, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelScriptFile.add((Component)this.scriptFileLabel, (Object)gridBagConstraints);
        this.buttonRemoveScriptFile.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jphototagger/importfiles/delete.png")));
        this.buttonRemoveScriptFile.setToolTipText(bundle.getString("ImportImageFilesDialog.buttonRemoveScriptFile.toolTipText"));
        this.buttonRemoveScriptFile.setEnabled(false);
        this.buttonRemoveScriptFile.setPreferredSize(new Dimension(16, 16));
        this.buttonRemoveScriptFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonRemoveScriptFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelScriptFile.add((Component)this.buttonRemoveScriptFile, (Object)gridBagConstraints);
        this.buttonChooseScriptFile.setText(bundle.getString("ImportImageFilesDialog.buttonChooseScriptFile.text"));
        this.buttonChooseScriptFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonChooseScriptFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelScriptFile.add((Component)this.buttonChooseScriptFile, (Object)gridBagConstraints);
        this.labelScriptFileInfo.setText(bundle.getString("ImportImageFilesDialog.labelScriptFileInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelScriptFile.add((Component)this.labelScriptFileInfo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelExpertSettingsContent.add((Component)this.panelScriptFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.dialogExpertSettings.getContentPane().add((Component)this.panelExpertSettingsContent, gridBagConstraints);
        GroupLayout panelExpertSettingsFillLayout = new GroupLayout(this.panelExpertSettingsFill);
        this.panelExpertSettingsFill.setLayout(panelExpertSettingsFillLayout);
        panelExpertSettingsFillLayout.setHorizontalGroup(panelExpertSettingsFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panelExpertSettingsFillLayout.setVerticalGroup(panelExpertSettingsFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.dialogExpertSettings.getContentPane().add((Component)this.panelExpertSettingsFill, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("ImportImageFilesDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        this.panelSourceStrategy.setBorder(BorderFactory.createTitledBorder(bundle.getString("ImportImageFilesDialog.panelSourceStrategy.border.title")));
        this.panelSourceStrategy.setLayout(new GridBagLayout());
        this.comboBoxSourceStrategy.setModel(new ComboBoxModelSourceStrategy());
        this.comboBoxSourceStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.comboBoxSourceStrategyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.panelSourceStrategy.add(this.comboBoxSourceStrategy, gridBagConstraints);
        this.checkBoxDeleteAfterCopy.setText(bundle.getString("ImportImageFilesDialog.checkBoxDeleteAfterCopy.text"));
        this.checkBoxDeleteAfterCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.checkBoxDeleteAfterCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelSourceStrategy.add((Component)this.checkBoxDeleteAfterCopy, gridBagConstraints);
        this.checkBoxSkipDuplicates.setText(bundle.getString("ImportImageFilesDialog.checkBoxSkipDuplicates.text"));
        this.checkBoxSkipDuplicates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.checkBoxSkipDuplicatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSourceStrategy.add((Component)this.checkBoxSkipDuplicates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelSourceStrategy, gridBagConstraints);
        this.panelTargetDir.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("ImportImageFilesDialog.panelTargetDir.border.title")));
        this.panelTargetDir.setLayout((LayoutManager)new GridBagLayout());
        this.labelTargetDir.setBorder(BorderFactory.createEtchedBorder());
        this.labelTargetDir.setPreferredSize(new Dimension(400, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.panelTargetDir.add((Component)this.labelTargetDir, (Object)gridBagConstraints);
        this.buttonChooseTargetDir.setText(bundle.getString("ImportImageFilesDialog.buttonChooseTargetDir.text"));
        this.buttonChooseTargetDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonChooseTargetDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.panelTargetDir.add((Component)this.buttonChooseTargetDir, (Object)gridBagConstraints);
        this.comboBoxSubdirectoryCreateStrategy.setModel(new SubdirectoryCreateStrategyComboBoxModel());
        this.comboBoxSubdirectoryCreateStrategy.setRenderer((ListCellRenderer<Object>)new DisplayNameListCellRenderer());
        this.comboBoxSubdirectoryCreateStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.comboBoxSubdirectoryCreateStrategyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTargetDir.add(this.comboBoxSubdirectoryCreateStrategy, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelTargetDir, gridBagConstraints);
        this.panelFileRenameStrategy.setBorder(BorderFactory.createTitledBorder(bundle.getString("ImportImageFilesDialog.panelFileRenameStrategy.border.title")));
        this.panelFileRenameStrategy.setLayout(new GridBagLayout());
        this.comboBoxFileRenameStrategy.setModel(new FileRenameStrategyComboBoxModel());
        this.comboBoxFileRenameStrategy.setRenderer((ListCellRenderer<Object>)new DisplayNameListCellRenderer());
        this.comboBoxFileRenameStrategy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.comboBoxFileRenameStrategyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 0);
        this.panelFileRenameStrategy.add(this.comboBoxFileRenameStrategy, gridBagConstraints);
        this.buttonEditRenameTemplates.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/jphototagger/importfiles/edit.png")));
        this.buttonEditRenameTemplates.setToolTipText(bundle.getString("ImportImageFilesDialog.buttonEditRenameTemplates.toolTipText"));
        this.buttonEditRenameTemplates.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditRenameTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonEditRenameTemplatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.panelFileRenameStrategy.add((Component)this.buttonEditRenameTemplates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelFileRenameStrategy, gridBagConstraints);
        this.panelDialogControlButtons.setLayout((LayoutManager)new GridBagLayout());
        this.buttonEditMetadata.setAction(new EditXmpAction());
        this.buttonEditMetadata.setText(bundle.getString("ImportImageFilesDialog.buttonEditMetadata.text"));
        this.buttonEditMetadata.setToolTipText(bundle.getString("ImportImageFilesDialog.buttonEditMetadata.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDialogControlButtons.add((Component)this.buttonEditMetadata, (Object)gridBagConstraints);
        this.buttonExpertSettings.setText(bundle.getString("ImportImageFilesDialog.buttonExpertSettings.text"));
        this.buttonExpertSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonExpertSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDialogControlButtons.add((Component)this.buttonExpertSettings, (Object)gridBagConstraints);
        this.buttonCancel.setText(bundle.getString("ImportImageFilesDialog.buttonCancel.text"));
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDialogControlButtons.add((Component)this.buttonCancel, (Object)gridBagConstraints);
        this.buttonOk.setText(bundle.getString("ImportImageFilesDialog.buttonOk.text"));
        this.buttonOk.setEnabled(false);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportImageFilesDialog.this.buttonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDialogControlButtons.add((Component)this.buttonOk, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelContent.add((Component)this.panelDialogControlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.setAccepted(false);
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.setAccepted(true);
    }

    private void buttonChooseSourceDirActionPerformed(ActionEvent evt) {
        this.setDir(this.buttonChooseSourceDir, this.chooseSourceDirAction, this.prevSelectedSourceDirs, this.setSourceDirFunctor);
    }

    private void buttonChooseTargetDirActionPerformed(ActionEvent evt) {
        this.setDir(this.buttonChooseTargetDir, this.chooseTargetDirAction, this.prevSelectedTargetDirs, this.setTargetDirFunctor);
    }

    private void buttonChooseFilesActionPerformed(ActionEvent evt) {
        this.chooseSourceFiles();
        this.toFront();
    }

    private void checkBoxDeleteAfterCopyActionPerformed(ActionEvent evt) {
        this.handleCheckBoxDeleteAfterCopyPerformed();
    }

    private void buttonChooseScriptFileActionPerformed(ActionEvent evt) {
        this.chooseAndSetScriptFile();
        this.toFront();
    }

    private void buttonRemoveScriptFileActionPerformed(ActionEvent evt) {
        this.removeScriptFile();
    }

    private void comboBoxSubdirectoryCreateStrategyActionPerformed(ActionEvent evt) {
        this.persistSubdirectoryCreateStrategy();
    }

    private void comboBoxFileRenameStrategyActionPerformed(ActionEvent evt) {
        this.persistFileRenameStrategy();
    }

    private void comboBoxSourceStrategyActionPerformed(ActionEvent evt) {
        this.setSourceStrategy();
    }

    private void buttonExpertSettingsActionPerformed(ActionEvent evt) {
        this.showExpertSettings();
    }

    private void buttonEditRenameTemplatesActionPerformed(ActionEvent evt) {
        this.editRenameTemplates();
    }

    private void checkBoxSkipDuplicatesActionPerformed(ActionEvent evt) {
        this.persistSkipDuplicates();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportImageFilesDialog dialog = new ImportImageFilesDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class EditXmpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private XmpEditor xmpEditor;

        private EditXmpAction() {
            super(Bundle.getString(ImportImageFilesDialog.class, (String)"ImportImageFilesDialog.EditXmpAction.Name", (Object[])new Object[0]));
            this.init();
        }

        private void init() {
            this.xmpEditor = (XmpEditor)Lookup.getDefault().lookup(XmpEditor.class);
            this.setEnabled(this.xmpEditor != null);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ImportImageFilesDialog.this.xmp == null) {
                ImportImageFilesDialog.this.xmp = this.xmpEditor.createXmp();
            } else {
                this.xmpEditor.editXmp(ImportImageFilesDialog.this.xmp);
            }
        }
    }

    private static class ComboBoxModelSourceStrategy
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;

        private ComboBoxModelSourceStrategy() {
            this.addElement(Bundle.getString(ComboBoxModelSourceStrategy.class, (String)"ComboBoxModelSourceStrategy.Item.0", (Object[])new Object[0]));
            this.addElement(Bundle.getString(ComboBoxModelSourceStrategy.class, (String)"ComboBoxModelSourceStrategy.Item.1", (Object[])new Object[0]));
        }
    }
}

