/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.file.CopyMoveFilesOptions;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.progress.ProgressListener;
import org.jphototagger.domain.DirectorySelectService;
import org.jphototagger.domain.FileCopyService;
import org.jphototagger.domain.FileImportService;
import org.jphototagger.domain.imagecollections.ImageCollectionService;
import org.jphototagger.domain.repository.ImageCollectionsRepository;
import org.jphototagger.domain.repository.SaveOrUpdate;
import org.jphototagger.domain.repository.SaveToOrUpdateFilesInRepository;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.importfiles.ExifDateTimeOriginalAscendingComparator;
import org.jphototagger.importfiles.ImportData;
import org.jphototagger.importfiles.ImportImageFilesDialog;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.SourceTargetFile;
import org.jphototagger.lib.runtime.External;
import org.jphototagger.lib.runtime.ProcessResult;
import org.jphototagger.lib.runtime.RuntimeUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.ProgressBarUpdater;
import org.openide.util.Lookup;

public final class ImportImageFiles
implements FileImportService {
    private static final String PROGRESS_BAR_STRING = Bundle.getString(ImportThread.class, (String)"ImportImageFiles.Info.ProgressBar", (Object[])new Object[0]);

    public void importFilesFromDirectory(File directory) {
        if (directory == null) {
            throw new NullPointerException("directory == null");
        }
        ImportImageFiles.importFrom(directory);
    }

    public static void importFrom(File sourceDirectory) {
        ImportThread importThread = new ImportThread(sourceDirectory);
        importThread.start();
    }

    private static ProgressEvent createIndeterminateProgressEvent(Object source) {
        return new ProgressEvent.Builder().source(source).indeterminate(true).stringPainted(true).stringToPaint(PROGRESS_BAR_STRING).build();
    }

    private static class ImportThread
    extends Thread
    implements ProgressListener {
        private static final Logger LOGGER = Logger.getLogger(ImportThread.class.getName());
        private static final int MAX_WAIT_FOR_SCRIPT_EXEC_IN_MILLIS = 240000;
        private final ProgressHandle progressHandle = ((ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class)).createProgressHandle();
        private final List<File> copiedTargetFiles = new ArrayList<File>();
        private final List<File> copiedSourceFiles = new ArrayList<File>();
        private final File sourceDirectory;
        private File targetDirectory;
        private List<SourceTargetFile> sourceTargetFiles;
        private boolean deleteSourceFilesAfterCopying;
        private File scriptFile;
        private String scriptForRuntime;
        private FileCopyService copyService;
        private ProgressBarUpdater copyServiceProgressBarUpdater;

        private ImportThread(File sourceDirectory) {
            super("JPhotoTagger: Importing Image Files, Collect + Copy");
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public void run() {
            ImportImageFilesDialog importDialog = new ImportImageFilesDialog();
            if (this.sourceDirectory != null) {
                importDialog.setSourceDirectory(this.sourceDirectory);
            }
            importDialog.setVisible(true);
            if (importDialog.isAccepted()) {
                ImportData importData = importDialog.createImportData();
                if (importData.hasSourceFiles()) {
                    this.prepareCopy(importData);
                    this.copy();
                } else {
                    MessageDisplayer.information(null, (String)Bundle.getString(ImportThread.class, (String)"ImportImageFiles.Info.NoSourceFiles", (Object[])new Object[0]));
                }
            }
        }

        private void prepareCopy(ImportData importData) {
            this.initFileRenameStrategy(importData);
            this.createSourceTargetFiles(importData);
            this.targetDirectory = importData.getTargetDirectory();
            this.deleteSourceFilesAfterCopying = importData.isDeleteSourceFilesAfterCopying();
            this.scriptFile = importData.getScriptFile();
            this.scriptForRuntime = this.scriptFile == null ? "" : RuntimeUtil.quoteForCommandLine((File[])new File[]{this.scriptFile});
        }

        private void initFileRenameStrategy(ImportData importData) {
            if (importData.hasFileRenameStrategy()) {
                importData.getFileRenameStrategy().init();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSourceTargetFiles(ImportData importData) {
            this.progressHandle.progressStarted(ImportImageFiles.createIndeterminateProgressEvent(this));
            try {
                this.sourceTargetFiles = new ArrayList<SourceTargetFile>(importData.getSourceFileCount());
                List<File> sourceFiles = importData.getSourceFiles();
                Collections.sort(sourceFiles, ExifDateTimeOriginalAscendingComparator.INSTANCE);
                for (File sourceFile : sourceFiles) {
                    File targetFile = this.createTargetFile(sourceFile, importData);
                    if (importData.isSkipDuplicates() && this.isDuplicate(sourceFile, targetFile.getParentFile())) continue;
                    this.ensureTargetDirExists(targetFile);
                    SourceTargetFile sourceTargetFile = new SourceTargetFile(sourceFile, targetFile);
                    sourceTargetFile.setUserObject((Object)importData.getXmp());
                    this.sourceTargetFiles.add(sourceTargetFile);
                }
            }
            finally {
                this.progressHandle.progressEnded();
            }
        }

        private File createTargetFile(File sourceFile, ImportData importData) {
            String targetSubdirPathname = importData.hasSubdirectoryCreateStrategy() ? importData.getSubdirectoryCreateStrategy().suggestSubdirectoryName(sourceFile) : "";
            String targetDirPathname = importData.getTargetDirectory().getAbsolutePath();
            String string = targetDirPathname = targetSubdirPathname.isEmpty() ? targetDirPathname : targetDirPathname + File.separator + targetSubdirPathname;
            if (importData.hasFileRenameStrategy()) {
                return importData.getFileRenameStrategy().suggestNewFile(sourceFile, targetDirPathname);
            }
            String sourceFilename = sourceFile.getName();
            return new File(targetDirPathname + File.separator + sourceFilename);
        }

        private boolean isDuplicate(File sourceFile, File targetDir) {
            if (targetDir == null || !targetDir.isDirectory()) {
                return false;
            }
            File[] filesInTargetDir = targetDir.listFiles();
            if (filesInTargetDir == null) {
                return false;
            }
            for (File file : filesInTargetDir) {
                try {
                    if (!FileUtil.contentEquals((File)sourceFile, (File)file)) continue;
                    return true;
                }
                catch (Throwable t) {
                    Logger.getLogger(ImportThread.class.getName()).log(Level.SEVERE, null, t);
                }
            }
            return false;
        }

        private void ensureTargetDirExists(File targetFile) {
            File parentFile = targetFile.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                try {
                    FileUtil.ensureDirectoryExists((File)parentFile);
                }
                catch (Throwable t) {
                    Logger.getLogger(ImportImageFiles.class.getName()).log(Level.SEVERE, null, t);
                }
            }
        }

        private void copy() {
            this.copyService = ((FileCopyService)Lookup.getDefault().lookup(FileCopyService.class)).createInstance(this.sourceTargetFiles, CopyMoveFilesOptions.RENAME_SOURCE_FILE_IF_TARGET_FILE_EXISTS);
            this.copyServiceProgressBarUpdater = new ProgressBarUpdater((Object)this.copyService, PROGRESS_BAR_STRING);
            this.copyService.setCopyListenerShallUpdateRepository(false);
            this.copyService.addProgressListener((ProgressListener)this);
            this.copyService.addProgressListener((ProgressListener)this.copyServiceProgressBarUpdater);
            this.copyService.copyWaitForTermination();
        }

        public void progressStarted(ProgressEvent evt) {
        }

        public void progressPerformed(ProgressEvent evt) {
            SourceTargetFile sourceTargetFile;
            File targetFile;
            boolean isXmpFile;
            Object o = evt.getInfo();
            if (o instanceof SourceTargetFile && !(isXmpFile = (targetFile = (sourceTargetFile = (SourceTargetFile)o).getTargetFile()).getName().toLowerCase().endsWith(".xmp"))) {
                this.copiedTargetFiles.add(targetFile);
                this.copiedSourceFiles.add(sourceTargetFile.getSourceFile());
            }
        }

        public void progressEnded(ProgressEvent evt) {
            this.copyServiceProgressBarUpdater.progressEnded(null);
            this.startPostCopyTask();
        }

        private void startPostCopyTask() {
            PostCopyTask postCopyTask = new PostCopyTask();
            postCopyTask.progressHandle = this.progressHandle;
            postCopyTask.sourceTargetFiles = this.sourceTargetFiles;
            postCopyTask.copiedSourceFiles = this.copiedSourceFiles;
            postCopyTask.copiedTargetFiles = this.copiedTargetFiles;
            postCopyTask.targetDirectory = this.targetDirectory;
            postCopyTask.scriptFile = this.scriptFile;
            postCopyTask.deleteSourceFilesAfterCopying = this.deleteSourceFilesAfterCopying;
            postCopyTask.scriptForRuntime = this.scriptForRuntime;
            postCopyTask.start();
        }

        private static class PostCopyTask
        extends Thread {
            private ProgressHandle progressHandle;
            private List<SourceTargetFile> sourceTargetFiles;
            private List<File> copiedSourceFiles;
            private List<File> copiedTargetFiles;
            private File targetDirectory;
            private File scriptFile;
            private boolean deleteSourceFilesAfterCopying;
            private String scriptForRuntime;

            private PostCopyTask() {
                super("JPhotoTagger: Importing Image Files, Post Copy");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.progressHandle.progressStarted(ImportImageFiles.createIndeterminateProgressEvent(this));
                    if (this.scriptFile != null) {
                        this.executeScriptFile();
                        this.selectTargetDirectory();
                    } else {
                        this.addFilesToCollection();
                    }
                    if (this.deleteSourceFilesAfterCopying) {
                        this.deleteCopiedSourceFiles();
                    }
                }
                finally {
                    this.progressHandle.progressEnded();
                }
            }

            private void executeScriptFile() {
                for (SourceTargetFile sourceTargetFile : this.sourceTargetFiles) {
                    this.executeScriptFileForCopiedFile(sourceTargetFile.getTargetFile());
                }
            }

            private void executeScriptFileForCopiedFile(File copiedFileInTarget) {
                String fileAsScriptArgument = RuntimeUtil.quoteForCommandLine((File[])new File[]{copiedFileInTarget});
                String command = this.scriptForRuntime + " " + fileAsScriptArgument;
                this.logScriptCommand(copiedFileInTarget, command);
                ProcessResult execResult = External.executeWaitForTermination((String)command, (long)240000L);
                this.logScriptErrors(execResult);
            }

            private void selectTargetDirectory() {
                DirectorySelectService service = (DirectorySelectService)Lookup.getDefault().lookup(DirectorySelectService.class);
                if (service != null) {
                    service.selectDirectory(this.targetDirectory);
                }
            }

            private void logScriptCommand(File copiedFileInTarget, String command) {
                LOGGER.log(Level.INFO, "Executing script file ''{0}'' for copied file ''{1}'' with command ''{2}'' and waiting for a maximum of {3} milliseconds", new Object[]{this.scriptFile, copiedFileInTarget, command, 240000});
            }

            private void logScriptErrors(ProcessResult execResult) {
                byte[] errorStream = execResult.getStdErrBytes();
                if (errorStream != null && errorStream.length > 0) {
                    LOGGER.log(Level.WARNING, new String(errorStream));
                }
            }

            private void addFilesToCollection() {
                if (!this.copiedTargetFiles.isEmpty()) {
                    this.insertCopiedFilesIntoDb();
                }
                this.insertCopiedFilesAsCollectionIntoDb();
                this.selectPrevImportCollection();
            }

            private void insertCopiedFilesIntoDb() {
                SaveToOrUpdateFilesInRepository inserter = ((SaveToOrUpdateFilesInRepository)Lookup.getDefault().lookup(SaveToOrUpdateFilesInRepository.class)).createInstance(this.copiedTargetFiles, new SaveOrUpdate[]{SaveOrUpdate.OUT_OF_DATE});
                inserter.saveOrUpdateWaitForTermination();
            }

            private void insertCopiedFilesAsCollectionIntoDb() {
                int delCount;
                String collectionName = "SpecialCollectionName.PreviousImport";
                ImageCollectionsRepository repo = (ImageCollectionsRepository)Lookup.getDefault().lookup(ImageCollectionsRepository.class);
                List prevCollectionFiles = repo.findImageFilesOfImageCollection(collectionName);
                if (!prevCollectionFiles.isEmpty() && (delCount = repo.deleteImagesFromImageCollection(collectionName, prevCollectionFiles)) != prevCollectionFiles.size()) {
                    LOGGER.log(Level.WARNING, "Could not delete all images from ''{0}''!", collectionName);
                    return;
                }
                repo.saveImageCollection(collectionName, this.copiedTargetFiles);
            }

            private void selectPrevImportCollection() {
                EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ImageCollectionService imageCollectionService = (ImageCollectionService)Lookup.getDefault().lookup(ImageCollectionService.class);
                        if (imageCollectionService != null) {
                            imageCollectionService.selectPreviousImportedFiles();
                            ThumbnailsDisplayer thumbnailsDisplayer = (ThumbnailsDisplayer)Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
                            if (thumbnailsDisplayer != null) {
                                thumbnailsDisplayer.refresh();
                            }
                        }
                    }
                });
            }

            private void deleteCopiedSourceFiles() {
                for (File file : this.copiedSourceFiles) {
                    LOGGER.log(Level.INFO, "Deleting after import file ''{0}''", file);
                    if (file.delete()) continue;
                    LOGGER.log(Level.WARNING, "Error while deleting file ''{0}''!", file);
                }
            }
        }
    }
}

