/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jphototagger.api.file.FileRenameStrategy;
import org.jphototagger.api.file.SubdirectoryCreateStrategy;
import org.jphototagger.domain.metadata.xmp.Xmp;

public final class ImportData {
    private final List<File> sourceFiles;
    private final File targetDirectory;
    private final SubdirectoryCreateStrategy subdirectoryCreateStrategy;
    private final FileRenameStrategy fileRenameStrategy;
    private final File scriptFile;
    private final Xmp xmp;
    private final boolean deleteSourceFilesAfterCopying;
    private final boolean skipDuplicates;

    private ImportData(Builder builder) {
        this.sourceFiles = builder.sourceFiles;
        this.targetDirectory = builder.targetDirectory;
        this.subdirectoryCreateStrategy = builder.subdirectoryCreateStrategy;
        this.fileRenameStrategy = builder.fileRenameStrategy;
        this.scriptFile = builder.scriptFile;
        this.deleteSourceFilesAfterCopying = builder.deleteSourceFilesAfterCopying;
        this.xmp = builder.xmp;
        this.skipDuplicates = builder.skipDuplicates;
    }

    public List<File> getSourceFiles() {
        return new LinkedList<File>(this.sourceFiles);
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isDeleteSourceFilesAfterCopying() {
        return this.deleteSourceFilesAfterCopying;
    }

    public SubdirectoryCreateStrategy getSubdirectoryCreateStrategy() {
        return this.subdirectoryCreateStrategy;
    }

    public FileRenameStrategy getFileRenameStrategy() {
        return this.fileRenameStrategy;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public Xmp getXmp() {
        return this.xmp;
    }

    public boolean hasSubdirectoryCreateStrategy() {
        return this.subdirectoryCreateStrategy != null;
    }

    public boolean hasFileRenameStrategy() {
        return this.fileRenameStrategy != null;
    }

    public boolean hasScriptFile() {
        return this.scriptFile != null;
    }

    public int getSourceFileCount() {
        return this.sourceFiles.size();
    }

    public boolean hasSourceFiles() {
        return !this.sourceFiles.isEmpty();
    }

    public boolean hasXmp() {
        return this.xmp != null && !this.xmp.isEmpty();
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public static class Builder {
        private final List<File> sourceFiles;
        private final File targetDirectory;
        private SubdirectoryCreateStrategy subdirectoryCreateStrategy;
        private FileRenameStrategy fileRenameStrategy;
        private File scriptFile;
        private Xmp xmp;
        private boolean deleteSourceFilesAfterCopying;
        private boolean skipDuplicates;

        public Builder(List<File> sourceFiles, File targetDirectory) {
            if (sourceFiles == null) {
                throw new NullPointerException("sourceFiles == null");
            }
            if (targetDirectory == null) {
                throw new NullPointerException("targetDirectory == null");
            }
            this.sourceFiles = sourceFiles;
            this.targetDirectory = targetDirectory;
        }

        public Builder deleteSourceFilesAfterCopying(boolean deleteSourceFilesAfterCopying) {
            this.deleteSourceFilesAfterCopying = deleteSourceFilesAfterCopying;
            return this;
        }

        public Builder fileRenameStrategy(FileRenameStrategy fileRenameStrategy) {
            this.fileRenameStrategy = fileRenameStrategy;
            return this;
        }

        public Builder subdirectoryCreateStrategy(SubdirectoryCreateStrategy subdirectoryCreateStrategy) {
            this.subdirectoryCreateStrategy = subdirectoryCreateStrategy;
            return this;
        }

        public Builder scriptFile(File scriptFile) {
            this.scriptFile = scriptFile;
            return this;
        }

        public Builder xmp(Xmp xmp) {
            this.xmp = xmp;
            return this;
        }

        public Builder skipDuplicates(boolean skip) {
            this.skipDuplicates = skip;
            return this;
        }

        public ImportData build() {
            return new ImportData(this);
        }
    }
}

