/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.importfiles;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JPanel;
import org.jphototagger.domain.filefilter.AppFileFilterProvider;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.thumbnails.ThumbnailProvider;
import org.jphototagger.image.util.ThumbnailCreatorService;
import org.jphototagger.lib.io.filefilter.FileChooserFilter;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public class ImagePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 155;
    private static final int PADDING = 5;
    private int width;
    private int height;
    private Image image;
    private final Color bg;
    private final ThumbnailProvider tnProvider = (ThumbnailProvider)Lookup.getDefault().lookup(ThumbnailProvider.class);

    public ImagePreviewPanel() {
        this.setPreferredSize(new Dimension(155, -1));
        this.bg = this.getBackground();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            return;
        }
        File selFile = (File)evt.getNewValue();
        if (selFile == null || !FileFilterUtil.isImageFile((File)selFile)) {
            this.image = null;
            this.repaint();
            return;
        }
        this.image = this.tnProvider.getThumbnail(selFile);
        if (this.image == null) {
            this.image = ThumbnailCreatorService.INSTANCE.createThumbnail(selFile);
        }
        if (this.image != null) {
            this.scaleImage();
        }
        this.repaint();
    }

    private void scaleImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        if (this.width >= this.height) {
            double ratio = 150.0 / (double)this.width;
            this.width = 150;
            this.height = (int)((double)this.height * ratio);
        } else if (this.getHeight() > 150) {
            double ratio = 150.0 / (double)this.height;
            this.height = 150;
            this.width = (int)((double)this.width * ratio);
        } else {
            double ratio = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * ratio);
        }
        this.image = this.image.getScaledInstance(this.width, this.height, 1);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.bg);
        g.fillRect(0, 0, 155, this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2 - this.width / 2 + 5, this.getHeight() / 2 - this.height / 2, this);
        }
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return ImageFileFilter.forFileChooser();
    }

    private static class ImageFileFilter
    implements FileFilter {
        private static final String DESCRIPTION = Bundle.getString(ImagePreviewPanel.class, (String)"ImagePreviewPanel.ImageFileFilter.Description", (Object[])new Object[0]);
        private static final FileFilter FILE_FILTER = ((AppFileFilterProvider)Lookup.getDefault().lookup(AppFileFilterProvider.class)).getAcceptedImageFilesFileFilter();
        private static final ImageFileFilter INSTANCE = new ImageFileFilter();

        @Override
        public boolean accept(File path) {
            return path.isDirectory() || FILE_FILTER.accept(path);
        }

        public static javax.swing.filechooser.FileFilter forFileChooser() {
            return new FileChooserFilter((FileFilter)INSTANCE, DESCRIPTION);
        }

        private ImageFileFilter() {
        }
    }
}

