/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfilters;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.UserDefinedFileFiltersRepository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.userdefinedfilters.EditUserDefinedFileFilterDialog;
import org.jphototagger.userdefinedfilters.UserDefinedFileFiltersListCellRenderer;
import org.jphototagger.userdefinedfilters.UserDefinedFileFiltersListModel;
import org.openide.util.Lookup;

public class UserDefinedFileFiltersPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private final UserDefinedFileFiltersRepository repo = (UserDefinedFileFiltersRepository)Lookup.getDefault().lookup(UserDefinedFileFiltersRepository.class);
    private JButton buttonDelete;
    private JButton buttonInsert;
    private JButton buttonUpdate;
    private JXList list;
    private JMenuItem menuItemDelete;
    private JMenuItem menuItemInsert;
    private JMenuItem menuItemUpdate;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPane;

    public UserDefinedFileFiltersPanel() {
        this.initComponents();
        MnemonicUtil.setMnemonics((Container)this);
        this.listen();
    }

    private void listen() {
        this.list.addListSelectionListener((ListSelectionListener)this);
    }

    private void insertFilter() {
        UserDefinedFileFilter newFilter;
        EditUserDefinedFileFilterDialog dlg = new EditUserDefinedFileFilterDialog();
        dlg.setVisible(true);
        if (dlg.isAccepted() && !this.repo.saveUserDefinedFileFilter(newFilter = dlg.getFilter())) {
            this.errorMessageInsert(newFilter);
        }
    }

    private void errorMessageInsert(UserDefinedFileFilter filter) {
        String message = Bundle.getString(UserDefinedFileFiltersPanel.class, (String)"UserDefinedFileFilterPanel.Error.Insert", (Object[])new Object[]{filter});
        MessageDisplayer.error((Component)this, (String)message);
    }

    private void updateFilter() {
        for (UserDefinedFileFilter filter : this.getSelectedFilters()) {
            UserDefinedFileFilter updatedFilter;
            EditUserDefinedFileFilterDialog dlg = new EditUserDefinedFileFilterDialog(filter);
            dlg.setVisible(true);
            if (!dlg.isAccepted() || this.repo.updateUserDefinedFileFilter(updatedFilter = dlg.getFilter())) continue;
            this.errorMessageUpdate(updatedFilter);
        }
    }

    private void errorMessageUpdate(UserDefinedFileFilter filter) {
        String message = Bundle.getString(UserDefinedFileFiltersPanel.class, (String)"UserDefinedFileFilterPanel.Error.Update", (Object[])new Object[]{filter});
        MessageDisplayer.error((Component)this, (String)message);
    }

    private void deleteFilter() {
        if (this.confirmDelete()) {
            for (UserDefinedFileFilter filter : this.getSelectedFilters()) {
                if (this.repo.deleteUserDefinedFileFilter(filter)) continue;
                this.errorMessageDelete(filter);
            }
        }
    }

    private void errorMessageDelete(UserDefinedFileFilter filter) {
        String message = Bundle.getString(UserDefinedFileFiltersPanel.class, (String)"UserDefinedFileFilterPanel.Error.Delete", (Object[])new Object[]{filter});
        MessageDisplayer.error((Component)this, (String)message);
    }

    private boolean confirmDelete() {
        String message = Bundle.getString(UserDefinedFileFiltersPanel.class, (String)"UserDefinedFileFilterPanel.Confirm.Delete", (Object[])new Object[0]);
        return MessageDisplayer.confirmYesNo((Component)this, (String)message);
    }

    private List<UserDefinedFileFilter> getSelectedFilters() {
        Object[] selValues = this.list.getSelectedValues();
        ArrayList<UserDefinedFileFilter> filter = new ArrayList<UserDefinedFileFilter>(selValues.length);
        for (Object selValue : selValues) {
            if (!(selValue instanceof UserDefinedFileFilter)) continue;
            filter.add((UserDefinedFileFilter)selValue);
        }
        return filter;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setEnabledButtons();
        }
    }

    private void handleMouseClickedInList(MouseEvent evt) {
        if (MouseEventUtil.isDoubleClick((MouseEvent)evt)) {
            this.updateFilter();
        }
    }

    private boolean isItemSelected() {
        return this.list.getSelectedIndex() >= 0;
    }

    private void setEnabledButtons() {
        boolean selected = this.isItemSelected();
        this.buttonDelete.setEnabled(selected);
        this.buttonUpdate.setEnabled(selected);
    }

    private void setEnabledPopupMenuItems() {
        boolean selected = this.isItemSelected();
        this.menuItemDelete.setEnabled(selected);
        this.menuItemUpdate.setEnabled(selected);
    }

    private void handleListKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 155) {
            this.insertFilter();
        } else if (keyCode == 10) {
            this.updateFilter();
        } else if (keyCode == 127) {
            this.deleteFilter();
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItemInsert = new JMenuItem();
        this.menuItemUpdate = new JMenuItem();
        this.menuItemDelete = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.list = new JXList();
        this.buttonInsert = new JButton();
        this.buttonUpdate = new JButton();
        this.buttonDelete = new JButton();
        this.popupMenu.setName("popupMenu");
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                UserDefinedFileFiltersPanel.this.popupMenuPopupMenuWillBecomeVisible(evt);
            }
        });
        this.menuItemInsert.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/userdefinedfilters/Bundle");
        this.menuItemInsert.setText(bundle.getString("UserDefinedFileFiltersPanel.menuItemInsert.text"));
        this.menuItemInsert.setName("menuItemInsert");
        this.menuItemInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.menuItemInsertActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemInsert);
        this.menuItemUpdate.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.menuItemUpdate.setText(bundle.getString("UserDefinedFileFiltersPanel.menuItemUpdate.text"));
        this.menuItemUpdate.setName("menuItemUpdate");
        this.menuItemUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.menuItemUpdateActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemUpdate);
        this.menuItemDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menuItemDelete.setText(bundle.getString("UserDefinedFileFiltersPanel.menuItemDelete.text"));
        this.menuItemDelete.setName("menuItemDelete");
        this.menuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.menuItemDeleteActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItemDelete);
        this.setName("Form");
        this.scrollPane.setName("scrollPane");
        this.list.setModel((ListModel)new UserDefinedFileFiltersListModel());
        this.list.setCellRenderer((ListCellRenderer)new UserDefinedFileFiltersListCellRenderer());
        this.list.setComponentPopupMenu(this.popupMenu);
        this.list.setName("list");
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserDefinedFileFiltersPanel.this.listMouseClicked(evt);
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                UserDefinedFileFiltersPanel.this.listKeyPressed(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.list);
        this.buttonInsert.setText(bundle.getString("UserDefinedFileFiltersPanel.buttonInsert.text"));
        this.buttonInsert.setName("buttonInsert");
        this.buttonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.buttonInsertActionPerformed(evt);
            }
        });
        this.buttonUpdate.setText(bundle.getString("UserDefinedFileFiltersPanel.buttonUpdate.text"));
        this.buttonUpdate.setEnabled(false);
        this.buttonUpdate.setName("buttonUpdate");
        this.buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.buttonUpdateActionPerformed(evt);
            }
        });
        this.buttonDelete.setText(bundle.getString("UserDefinedFileFiltersPanel.buttonDelete.text"));
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setName("buttonDelete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserDefinedFileFiltersPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.buttonInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete)).addComponent(this.scrollPane, -1, 312, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPane, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonInsert).addComponent(this.buttonUpdate).addComponent(this.buttonDelete))));
    }

    private void buttonInsertActionPerformed(ActionEvent evt) {
        this.insertFilter();
    }

    private void buttonUpdateActionPerformed(ActionEvent evt) {
        this.updateFilter();
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.deleteFilter();
    }

    private void listMouseClicked(MouseEvent evt) {
        this.handleMouseClickedInList(evt);
    }

    private void menuItemInsertActionPerformed(ActionEvent evt) {
        this.insertFilter();
    }

    private void menuItemUpdateActionPerformed(ActionEvent evt) {
        this.updateFilter();
    }

    private void menuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteFilter();
    }

    private void popupMenuPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setEnabledPopupMenuItems();
    }

    private void listKeyPressed(KeyEvent evt) {
        this.handleListKeyPressed(evt);
    }
}

