/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfilters;

import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.UserDefinedFileFiltersRepository;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterUpdatedEvent;
import org.openide.util.Lookup;

public final class UserDefinedFileFiltersListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final UserDefinedFileFiltersRepository udffRepo = (UserDefinedFileFiltersRepository)Lookup.getDefault().lookup(UserDefinedFileFiltersRepository.class);

    public UserDefinedFileFiltersListModel() {
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    private void addElements() {
        Repository repo = (Repository)Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        for (UserDefinedFileFilter filter : this.udffRepo.findAllUserDefinedFileFilters()) {
            this.addElement(filter);
        }
    }

    private void updateFilter(UserDefinedFileFilter filter) {
        int index = this.indexOf(filter);
        if (index >= 0) {
            ((UserDefinedFileFilter)this.getElementAt(index)).set(filter);
            this.fireContentsChanged(this, index, index);
        }
    }

    private void deleteFilter(UserDefinedFileFilter filter) {
        this.removeElement(filter);
    }

    private void insertFilter(UserDefinedFileFilter filter) {
        this.addElement(filter);
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterInsertedEvent.class)
    public void filterInserted(UserDefinedFileFilterInsertedEvent evt) {
        this.insertFilter(evt.getFilter());
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterDeletedEvent.class)
    public void filterDeleted(UserDefinedFileFilterDeletedEvent evt) {
        this.deleteFilter(evt.getFilter());
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterUpdatedEvent.class)
    public synchronized void filterUpdated(UserDefinedFileFilterUpdatedEvent evt) {
        this.updateFilter(evt.getFilter());
    }
}

