/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.userdefinedfilters;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.UserDefinedFileFiltersRepository;
import org.jphototagger.lib.beansbinding.MaxLengthValidator;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.userdefinedfilters.UserDefinedFileFiltersListCellRenderer;
import org.openide.util.Lookup;

public class EditUserDefinedFileFilterDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private boolean accepted;
    private final UserDefinedFileFilter udf = new UserDefinedFileFilter();
    private final UserDefinedFileFiltersRepository repo = (UserDefinedFileFiltersRepository)Lookup.getDefault().lookup(UserDefinedFileFiltersRepository.class);
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkBoxNot;
    private JComboBox<Object> comboBoxType;
    private UserDefinedFileFilter filter;
    private JLabel labelName;
    private JTextField textFieldExpression;
    private JTextField textFieldName;
    private BindingGroup bindingGroup;

    public EditUserDefinedFileFilterDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    public EditUserDefinedFileFilterDialog(UserDefinedFileFilter filter) {
        super(ComponentUtil.findFrameWithIcon(), true);
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        this.udf.set(filter);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setHelpPage();
        MnemonicUtil.setMnemonics((Container)((Object)this));
    }

    private void setHelpPage() {
        this.setHelpPageUrl(Bundle.getString(EditUserDefinedFileFilterDialog.class, (String)"EditUserDefinedFileFilterDialog.HelpPage", (Object[])new Object[0]));
    }

    public UserDefinedFileFilter getFilter() {
        return new UserDefinedFileFilter(this.filter);
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    private void handleOkButtonClicked() {
        if (this.filter.isValid()) {
            if (this.checkName(this.textFieldName.getText())) {
                this.accepted = true;
                this.setVisible(false);
            }
        } else {
            String message = Bundle.getString(EditUserDefinedFileFilterDialog.class, (String)"EditUserDefinedFileFilterDialog.Error.Valid", (Object[])new Object[0]);
            MessageDisplayer.error((Component)((Object)this), (String)message);
        }
    }

    private boolean checkName(String name) {
        if (this.repo.existsUserDefinedFileFilter(name)) {
            String message = Bundle.getString(EditUserDefinedFileFilterDialog.class, (String)"EditUserDefinedFileFilterDialog.Error.NameExists", (Object[])new Object[]{name});
            MessageDisplayer.error((Component)((Object)this), (String)message);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.filter = this.udf;
        this.labelName = new JLabel();
        this.textFieldName = new JTextField();
        this.comboBoxType = new JComboBox();
        this.textFieldExpression = new JTextField();
        this.checkBoxNot = new JCheckBox();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/userdefinedfilters/Bundle");
        this.setTitle(bundle.getString("EditUserDefinedFileFilterDialog.title"));
        this.setName("Form");
        this.labelName.setLabelFor(this.textFieldName);
        this.labelName.setText(bundle.getString("EditUserDefinedFileFilterDialog.labelName.text"));
        this.labelName.setName("labelName");
        this.textFieldName.setColumns(45);
        this.textFieldName.setName("textFieldName");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.filter, (Property)ELProperty.create((String)"${name}"), (Object)this.textFieldName, (Property)BeanProperty.create((String)"text"));
        binding.setValidator((Validator)new MaxLengthValidator(45));
        this.bindingGroup.addBinding((Binding)binding);
        this.comboBoxType.setModel(new ComboBoxModel());
        this.comboBoxType.setName("comboBoxType");
        this.comboBoxType.setRenderer(new UserDefinedFileFiltersListCellRenderer());
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.filter, (Property)ELProperty.create((String)"${type}"), this.comboBoxType, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.textFieldExpression.setName("textFieldExpression");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.filter, (Property)ELProperty.create((String)"${expression}"), (Object)this.textFieldExpression, (Property)BeanProperty.create((String)"text"));
        binding.setValidator((Validator)new MaxLengthValidator(128));
        this.bindingGroup.addBinding((Binding)binding);
        this.checkBoxNot.setText(bundle.getString("EditUserDefinedFileFilterDialog.checkBoxNot.text"));
        this.checkBoxNot.setName("checkBoxNot");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.filter, (Property)ELProperty.create((String)"${isNot}"), (Object)this.checkBoxNot, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        this.buttonCancel.setText(bundle.getString("EditUserDefinedFileFilterDialog.buttonCancel.text"));
        this.buttonCancel.setName("buttonCancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUserDefinedFileFilterDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.buttonOk.setText(bundle.getString("EditUserDefinedFileFilterDialog.buttonOk.text"));
        this.buttonOk.setName("buttonOk");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditUserDefinedFileFilterDialog.this.buttonOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.comboBoxType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldExpression, -1, 520, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxNot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 293, Short.MAX_VALUE).addComponent(this.buttonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk)).addGroup(layout.createSequentialGroup().addComponent(this.labelName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldName, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelName).addComponent(this.textFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textFieldExpression, -2, -1, -2).addComponent(this.comboBoxType, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxNot)).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonOk).addComponent(this.buttonCancel)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
        this.pack();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.handleOkButtonClicked();
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.accepted = false;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditUserDefinedFileFilterDialog dialog = new EditUserDefinedFileFilterDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static class ComboBoxModel
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;

        private ComboBoxModel() {
            this.addElements();
        }

        private void addElements() {
            for (UserDefinedFileFilter.Type type : UserDefinedFileFilter.Type.values()) {
                this.addElement(type);
            }
        }
    }
}

