/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.kml;

import org.jphototagger.kml.KMLElement;

public final class KMLPoint
implements KMLElement {
    private static final double VALUE_NO_ALTITUDE = Double.MIN_VALUE;
    private final double longitude;
    private final double latitude;
    private final double altitude;

    public KMLPoint(double longitude, double latitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Illegal longitude: " + longitude);
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Illegal latitude: " + latitude);
        }
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = Double.MIN_VALUE;
    }

    public KMLPoint(double longitude, double latitude, double altitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Illegal longitude: " + longitude);
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Illegal latitude: " + latitude);
        }
        if (altitude < 0.0) {
            throw new IllegalArgumentException("Illegal altitude: " + altitude);
        }
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    public double getAltitude() {
        if (!this.hasAltitude()) {
            throw new IllegalStateException("No altitude has been set!");
        }
        return this.altitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public boolean hasAltitude() {
        return this.altitude != Double.MIN_VALUE;
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Point><coordinates>");
        sb.append(this.longitude);
        sb.append(",");
        sb.append(this.latitude);
        this.appendAltitude(sb);
        sb.append("</coordinates></Point>");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.longitude);
        sb.append(",");
        sb.append(this.latitude);
        this.appendAltitude(sb);
        return sb.toString();
    }

    @Override
    public boolean isTopLevelElement() {
        return false;
    }

    private void appendAltitude(StringBuilder sb) {
        if (this.hasAltitude()) {
            sb.append(",");
            sb.append(this.altitude);
        }
    }
}

