/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.kml;

import org.jphototagger.kml.KMLElement;
import org.jphototagger.kml.KMLPoint;

public final class KMLPlacemark
implements KMLElement {
    private final KMLPoint point;
    private String name;

    public KMLPlacemark(KMLPoint point) {
        if (point == null) {
            throw new NullPointerException("point == null");
        }
        this.point = point;
    }

    public KMLPoint getPoint() {
        return this.point;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Placemark>");
        this.appendName(sb);
        sb.append(this.point.toXML());
        sb.append("</Placemark>");
        return sb.toString();
    }

    @Override
    public boolean isTopLevelElement() {
        return true;
    }

    private void appendName(StringBuilder sb) {
        if (this.name != null && !this.name.trim().isEmpty()) {
            sb.append("<name>");
            sb.append(this.name.trim());
            sb.append("</name>");
        }
    }
}

