/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jphototagger.kml.KMLElement;

public final class KMLDocument {
    private static final String CHARSET = "UTF-8";
    private static final String NEWLINE = System.getProperty("line.separator");
    private String generator;
    private final List<KMLElement> elements = new ArrayList<KMLElement>();

    public void setGenerator(String generator) {
        if (generator == null) {
            throw new NullPointerException("generator == null");
        }
        this.generator = generator;
    }

    public void addElement(KMLElement element) {
        if (element == null) {
            throw new NullPointerException("element == null");
        }
        if (!element.isTopLevelElement()) {
            throw new IllegalArgumentException("Not a top level element: " + element.getClass());
        }
        this.elements.add(element);
    }

    public void write(OutputStream os) throws UnsupportedEncodingException, IOException {
        this.writeHeader(os);
        this.writeElements(os);
        this.writeFooter(os);
    }

    private void writeHeader(OutputStream os) throws IOException {
        KMLDocument.write(os, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        KMLDocument.writeLine(os, "<kml xmlns=\"http://www.opengis.net/kml/2.2\">");
        this.writeGenerator(os);
        KMLDocument.writeLine(os, "<Document>");
    }

    private void writeGenerator(OutputStream os) throws IOException {
        if (this.generator != null && !this.generator.trim().isEmpty()) {
            KMLDocument.writeLine(os, "<!--Generated by " + this.generator.trim() + "-->");
        }
    }

    private void writeFooter(OutputStream os) throws IOException {
        KMLDocument.writeLine(os, "</Document>");
        KMLDocument.writeLine(os, "</kml>");
    }

    private void writeElements(OutputStream os) throws UnsupportedEncodingException, IOException {
        for (KMLElement element : this.elements) {
            KMLDocument.writeLine(os, element.toXML());
        }
    }

    private static void write(OutputStream os, String s) throws UnsupportedEncodingException, IOException {
        os.write(s.getBytes(CHARSET));
    }

    private static void writeLine(OutputStream os, String s) throws UnsupportedEncodingException, IOException {
        os.write(NEWLINE.getBytes(CHARSET));
        KMLDocument.write(os, s);
    }
}

