/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.fileeventhooks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXLabel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.FileChooserHelper;
import org.jphototagger.lib.swing.FileChooserProperties;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class UserScriptsSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color TEXTFIELD_FOREGROUND = UserScriptsSettingsPanel.getTextFieldForeground();
    private static final String LAST_CHOOSEN_DIR_KEY = "Module.FileEventHooks.LastChoosenDir";
    private final Map<JTextField, String> keyOfTextField = new HashMap<JTextField, String>(4);
    private final Map<JButton, JTextField> textFieldOfRemoveButton = new HashMap<JButton, JTextField>(4);
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private String lastChoosenDirectory;
    private final Action removeScriptFileAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JButton) {
                JButton button = (JButton)source;
                JTextField textField = (JTextField)UserScriptsSettingsPanel.this.textFieldOfRemoveButton.get(button);
                if (textField != null) {
                    textField.setText("");
                    String key = (String)UserScriptsSettingsPanel.this.keyOfTextField.get(textField);
                    if (key != null) {
                        Preferences preferences = (Preferences)Lookup.getDefault().lookup(Preferences.class);
                        preferences.removeKey(key);
                    }
                    UserScriptsSettingsPanel.this.setRemoveButtonsEnabled();
                }
            }
        }
    };
    private JButton buttonChooseScriptFileCopied;
    private JButton buttonChooseScriptFileDeleted;
    private JButton buttonChooseScriptFileMoved;
    private JButton buttonChooseScriptFileRenamed;
    private JButton buttonRemoveScriptFileCopied;
    private JButton buttonRemoveScriptFileDeleted;
    private JButton buttonRemoveScriptFileMoved;
    private JButton buttonRemoveScriptFileRenamed;
    private JXLabel labelGeneralInfo;
    private JXLabel labelParameterInfoFileCopied;
    private JXLabel labelParameterInfoFileDeleted;
    private JXLabel labelParameterInfoFileMoved;
    private JXLabel labelParameterInfoFileRenamed;
    private JXLabel labelPathInfo;
    private JPanel panelFileCopied;
    private JPanel panelFileDeleted;
    private JPanel panelFileMoved;
    private JPanel panelFileRenamed;
    private JTextField textFieldFileCopied;
    private JTextField textFieldFileDeleted;
    private JTextField textFieldFileMoved;
    private JTextField textFieldFileRenamed;

    public UserScriptsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initKeyOfTextFieldMap();
        this.initTextFieldOfRemoveButtonMap();
        this.initLastChoosenDirectory();
        this.setScriptsToTextFields();
        MnemonicUtil.setMnemonics((Container)this);
    }

    private static Color getTextFieldForeground() {
        Color foreground = UIManager.getColor("TextField.foreground");
        return foreground == null ? Color.BLACK : foreground;
    }

    private void initKeyOfTextFieldMap() {
        if (this.prefs != null) {
            this.keyOfTextField.put(this.textFieldFileCopied, "Module.FileActionHooks.Hook.FileCopied");
            this.keyOfTextField.put(this.textFieldFileDeleted, "Module.FileActionHooks.Hook.FileDeleted");
            this.keyOfTextField.put(this.textFieldFileMoved, "Module.FileActionHooks.Hook.FileMoved");
            this.keyOfTextField.put(this.textFieldFileRenamed, "Module.FileActionHooks.Hook.FileRenamed");
        }
    }

    private void initTextFieldOfRemoveButtonMap() {
        this.textFieldOfRemoveButton.put(this.buttonRemoveScriptFileCopied, this.textFieldFileCopied);
        this.textFieldOfRemoveButton.put(this.buttonRemoveScriptFileDeleted, this.textFieldFileDeleted);
        this.textFieldOfRemoveButton.put(this.buttonRemoveScriptFileMoved, this.textFieldFileMoved);
        this.textFieldOfRemoveButton.put(this.buttonRemoveScriptFileRenamed, this.textFieldFileRenamed);
    }

    private void initLastChoosenDirectory() {
        if (this.prefs != null) {
            String prefString = this.prefs.getString(LAST_CHOOSEN_DIR_KEY);
            this.lastChoosenDirectory = StringUtil.hasContent((String)prefString) ? prefString : "";
        }
    }

    private void setScriptsToTextFields() {
        if (this.prefs != null) {
            this.setScriptToTextField(this.prefs.getString("Module.FileActionHooks.Hook.FileCopied"), this.textFieldFileCopied);
            this.setScriptToTextField(this.prefs.getString("Module.FileActionHooks.Hook.FileDeleted"), this.textFieldFileDeleted);
            this.setScriptToTextField(this.prefs.getString("Module.FileActionHooks.Hook.FileMoved"), this.textFieldFileMoved);
            this.setScriptToTextField(this.prefs.getString("Module.FileActionHooks.Hook.FileRenamed"), this.textFieldFileRenamed);
        }
        this.setRemoveButtonsEnabled();
    }

    private void setScriptToTextField(String script, JTextField textField) {
        if (!StringUtil.hasContent((String)script)) {
            return;
        }
        boolean fileExists = FileUtil.existsFile((File)new File(script));
        textField.setText(script);
        textField.setForeground(fileExists ? TEXTFIELD_FOREGROUND : Color.RED);
    }

    private void chooseScript(JTextField textField) {
        File scriptFile = this.chooseScriptFile();
        if (scriptFile == null) {
            return;
        }
        String key = this.keyOfTextField.get(textField);
        String scriptFilePath = scriptFile.getAbsolutePath();
        this.prefs.setString(key, scriptFilePath);
        textField.setText(scriptFilePath);
        this.setRemoveButtonsEnabled();
    }

    private File chooseScriptFile() {
        String dirOfScriptFile;
        FileChooserProperties props = this.createFileChooserProperties();
        File scriptFile = FileChooserHelper.chooseFile((FileChooserProperties)props);
        if (scriptFile != null && (dirOfScriptFile = scriptFile.getParent()) != null) {
            this.lastChoosenDirectory = dirOfScriptFile;
            this.prefs.setString(LAST_CHOOSEN_DIR_KEY, this.lastChoosenDirectory);
        }
        return scriptFile;
    }

    private FileChooserProperties createFileChooserProperties() {
        FileChooserProperties props = new FileChooserProperties();
        props.currentDirectoryPath(this.lastChoosenDirectory);
        props.dialogTitle(Bundle.getString(UserScriptsSettingsPanel.class, (String)"SettingsPanel.FileChooser.Title", (Object[])new Object[0]));
        props.multiSelectionEnabled(false);
        props.fileSelectionMode(0);
        props.propertyKeyPrefix("Module.FileEventHooks.FileChooser");
        return props;
    }

    private void setRemoveButtonsEnabled() {
        for (JButton button : this.textFieldOfRemoveButton.keySet()) {
            JTextField textField = this.textFieldOfRemoveButton.get(button);
            String script = textField.getText();
            button.setEnabled(StringUtil.hasContent((String)script));
        }
    }

    private void initComponents() {
        this.labelGeneralInfo = new JXLabel();
        this.panelFileCopied = new JPanel();
        this.textFieldFileCopied = new JTextField();
        this.buttonChooseScriptFileCopied = new JButton();
        this.buttonRemoveScriptFileCopied = new JButton();
        this.labelParameterInfoFileCopied = new JXLabel();
        this.panelFileRenamed = new JPanel();
        this.textFieldFileRenamed = new JTextField();
        this.buttonChooseScriptFileRenamed = new JButton();
        this.buttonRemoveScriptFileRenamed = new JButton();
        this.labelParameterInfoFileRenamed = new JXLabel();
        this.panelFileMoved = new JPanel();
        this.textFieldFileMoved = new JTextField();
        this.buttonChooseScriptFileMoved = new JButton();
        this.buttonRemoveScriptFileMoved = new JButton();
        this.labelParameterInfoFileMoved = new JXLabel();
        this.panelFileDeleted = new JPanel();
        this.textFieldFileDeleted = new JTextField();
        this.buttonChooseScriptFileDeleted = new JButton();
        this.buttonRemoveScriptFileDeleted = new JButton();
        this.labelParameterInfoFileDeleted = new JXLabel();
        this.labelPathInfo = new JXLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                UserScriptsSettingsPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/fileeventhooks/Bundle");
        this.labelGeneralInfo.setText(bundle.getString("UserScriptsSettingsPanel.labelGeneralInfo.text"));
        this.labelGeneralInfo.setLineWrap(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.labelGeneralInfo, gridBagConstraints);
        this.panelFileCopied.setBorder(BorderFactory.createTitledBorder(bundle.getString("UserScriptsSettingsPanel.panelFileCopied.border.title")));
        this.panelFileCopied.setLayout(new GridBagLayout());
        this.textFieldFileCopied.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileCopied.add((Component)this.textFieldFileCopied, gridBagConstraints);
        this.buttonChooseScriptFileCopied.setText(bundle.getString("UserScriptsSettingsPanel.buttonChooseScriptFileCopied.text"));
        this.buttonChooseScriptFileCopied.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserScriptsSettingsPanel.this.buttonChooseScriptFileCopiedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileCopied.add((Component)this.buttonChooseScriptFileCopied, gridBagConstraints);
        this.buttonRemoveScriptFileCopied.setAction(this.removeScriptFileAction);
        this.buttonRemoveScriptFileCopied.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/fileeventhooks/delete.png")));
        this.buttonRemoveScriptFileCopied.setToolTipText(bundle.getString("UserScriptsSettingsPanel.buttonRemoveScriptFileCopied.toolTipText"));
        this.buttonRemoveScriptFileCopied.setEnabled(false);
        this.buttonRemoveScriptFileCopied.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveScriptFileCopied.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileCopied.add((Component)this.buttonRemoveScriptFileCopied, gridBagConstraints);
        this.labelParameterInfoFileCopied.setText(bundle.getString("UserScriptsSettingsPanel.labelParameterInfoFileCopied.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileCopied.add((Component)this.labelParameterInfoFileCopied, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelFileCopied, gridBagConstraints);
        this.panelFileRenamed.setBorder(BorderFactory.createTitledBorder(bundle.getString("UserScriptsSettingsPanel.panelFileRenamed.border.title")));
        this.panelFileRenamed.setLayout(new GridBagLayout());
        this.textFieldFileRenamed.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileRenamed.add((Component)this.textFieldFileRenamed, gridBagConstraints);
        this.buttonChooseScriptFileRenamed.setText(bundle.getString("UserScriptsSettingsPanel.buttonChooseScriptFileRenamed.text"));
        this.buttonChooseScriptFileRenamed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserScriptsSettingsPanel.this.buttonChooseScriptFileRenamedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileRenamed.add((Component)this.buttonChooseScriptFileRenamed, gridBagConstraints);
        this.buttonRemoveScriptFileRenamed.setAction(this.removeScriptFileAction);
        this.buttonRemoveScriptFileRenamed.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/fileeventhooks/delete.png")));
        this.buttonRemoveScriptFileRenamed.setToolTipText(bundle.getString("UserScriptsSettingsPanel.buttonRemoveScriptFileRenamed.toolTipText"));
        this.buttonRemoveScriptFileRenamed.setEnabled(false);
        this.buttonRemoveScriptFileRenamed.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveScriptFileRenamed.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileRenamed.add((Component)this.buttonRemoveScriptFileRenamed, gridBagConstraints);
        this.labelParameterInfoFileRenamed.setText(bundle.getString("UserScriptsSettingsPanel.labelParameterInfoFileRenamed.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileRenamed.add((Component)this.labelParameterInfoFileRenamed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelFileRenamed, gridBagConstraints);
        this.panelFileMoved.setBorder(BorderFactory.createTitledBorder(bundle.getString("UserScriptsSettingsPanel.panelFileMoved.border.title")));
        this.panelFileMoved.setLayout(new GridBagLayout());
        this.textFieldFileMoved.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileMoved.add((Component)this.textFieldFileMoved, gridBagConstraints);
        this.buttonChooseScriptFileMoved.setText(bundle.getString("UserScriptsSettingsPanel.buttonChooseScriptFileMoved.text"));
        this.buttonChooseScriptFileMoved.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserScriptsSettingsPanel.this.buttonChooseScriptFileMovedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileMoved.add((Component)this.buttonChooseScriptFileMoved, gridBagConstraints);
        this.buttonRemoveScriptFileMoved.setAction(this.removeScriptFileAction);
        this.buttonRemoveScriptFileMoved.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/fileeventhooks/delete.png")));
        this.buttonRemoveScriptFileMoved.setToolTipText(bundle.getString("UserScriptsSettingsPanel.buttonRemoveScriptFileMoved.toolTipText"));
        this.buttonRemoveScriptFileMoved.setEnabled(false);
        this.buttonRemoveScriptFileMoved.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveScriptFileMoved.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileMoved.add((Component)this.buttonRemoveScriptFileMoved, gridBagConstraints);
        this.labelParameterInfoFileMoved.setText(bundle.getString("UserScriptsSettingsPanel.labelParameterInfoFileMoved.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileMoved.add((Component)this.labelParameterInfoFileMoved, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelFileMoved, gridBagConstraints);
        this.panelFileDeleted.setBorder(BorderFactory.createTitledBorder(bundle.getString("UserScriptsSettingsPanel.panelFileDeleted.border.title")));
        this.panelFileDeleted.setLayout(new GridBagLayout());
        this.textFieldFileDeleted.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileDeleted.add((Component)this.textFieldFileDeleted, gridBagConstraints);
        this.buttonChooseScriptFileDeleted.setText(bundle.getString("UserScriptsSettingsPanel.buttonChooseScriptFileDeleted.text"));
        this.buttonChooseScriptFileDeleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserScriptsSettingsPanel.this.buttonChooseScriptFileDeletedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelFileDeleted.add((Component)this.buttonChooseScriptFileDeleted, gridBagConstraints);
        this.buttonRemoveScriptFileDeleted.setAction(this.removeScriptFileAction);
        this.buttonRemoveScriptFileDeleted.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/fileeventhooks/delete.png")));
        this.buttonRemoveScriptFileDeleted.setToolTipText(bundle.getString("UserScriptsSettingsPanel.buttonRemoveScriptFileDeleted.toolTipText"));
        this.buttonRemoveScriptFileDeleted.setEnabled(false);
        this.buttonRemoveScriptFileDeleted.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveScriptFileDeleted.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileDeleted.add((Component)this.buttonRemoveScriptFileDeleted, gridBagConstraints);
        this.labelParameterInfoFileDeleted.setText(bundle.getString("UserScriptsSettingsPanel.labelParameterInfoFileDeleted.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileDeleted.add((Component)this.labelParameterInfoFileDeleted, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelFileDeleted, gridBagConstraints);
        this.labelPathInfo.setText(bundle.getString("UserScriptsSettingsPanel.labelPathInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.labelPathInfo, gridBagConstraints);
    }

    private void buttonChooseScriptFileCopiedActionPerformed(ActionEvent evt) {
        this.chooseScript(this.textFieldFileCopied);
    }

    private void buttonChooseScriptFileRenamedActionPerformed(ActionEvent evt) {
        this.chooseScript(this.textFieldFileRenamed);
    }

    private void buttonChooseScriptFileMovedActionPerformed(ActionEvent evt) {
        this.chooseScript(this.textFieldFileMoved);
    }

    private void buttonChooseScriptFileDeletedActionPerformed(ActionEvent evt) {
        this.chooseScript(this.textFieldFileDeleted);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.setScriptsToTextFields();
    }
}

