/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.fileeventhooks;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.event.FileCopiedEvent;
import org.jphototagger.api.file.event.FileDeletedEvent;
import org.jphototagger.api.file.event.FileMovedEvent;
import org.jphototagger.api.file.event.FileRenamedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public final class UserScriptsExecutor {
    private static final Logger LOGGER = Logger.getLogger(UserScriptsExecutor.class.getName());
    private String fileCopiedScript;
    private String fileDeletedScript;
    private String fileMovedScript;
    private String fileRenamedScript;
    private final Object monitor = new Object();

    public UserScriptsExecutor() {
        this.initScriptFiles();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    private void initScriptFiles() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        this.fileCopiedScript = prefs.getString("Module.FileActionHooks.Hook.FileCopied");
        this.fileDeletedScript = prefs.getString("Module.FileActionHooks.Hook.FileDeleted");
        this.fileMovedScript = prefs.getString("Module.FileActionHooks.Hook.FileMoved");
        this.fileRenamedScript = prefs.getString("Module.FileActionHooks.Hook.FileRenamed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPreferenceChanged(PreferencesChangedEvent evt) {
        String stringValue;
        String key = evt.getKey();
        String string = stringValue = evt.getNewValue() == null ? null : evt.getNewValue().toString();
        if ("Module.FileActionHooks.Hook.FileCopied".equals(key)) {
            Object object = this.monitor;
            synchronized (object) {
                this.fileCopiedScript = stringValue;
            }
        }
        if ("Module.FileActionHooks.Hook.FileDeleted".equals(key)) {
            Object object = this.monitor;
            synchronized (object) {
                this.fileDeletedScript = stringValue;
            }
        }
        if ("Module.FileActionHooks.Hook.FileMoved".equals(key)) {
            Object object = this.monitor;
            synchronized (object) {
                this.fileMovedScript = stringValue;
            }
        }
        if ("Module.FileActionHooks.Hook.FileRenamed".equals(key)) {
            Object object = this.monitor;
            synchronized (object) {
                this.fileRenamedScript = stringValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileCopiedEvent.class)
    public void fileCopied(FileCopiedEvent evt) {
        File sourceFile = evt.getSourceFile();
        File targetFile = evt.getTargetFile();
        Object object = this.monitor;
        synchronized (object) {
            this.executeScript(this.fileCopiedScript, sourceFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileDeletedEvent.class)
    public void fileDeleted(FileDeletedEvent evt) {
        File file = evt.getFile();
        Object object = this.monitor;
        synchronized (object) {
            this.executeScript(this.fileDeletedScript, file, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileMovedEvent.class)
    public void fileMoved(FileMovedEvent evt) {
        File sourceFile = evt.getSourceFile();
        File targetFile = evt.getTargetFile();
        Object object = this.monitor;
        synchronized (object) {
            this.executeScript(this.fileMovedScript, sourceFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileRenamedEvent.class)
    public void fileRenamed(FileRenamedEvent evt) {
        File sourceFile = evt.getSourceFile();
        File targetFile = evt.getTargetFile();
        Object object = this.monitor;
        synchronized (object) {
            this.executeScript(this.fileRenamedScript, sourceFile, targetFile);
        }
    }

    private void executeScript(String script, File fromFile, File toFile) {
        if (!StringUtil.hasContent((String)script) || this.isSidecarFile(fromFile)) {
            return;
        }
        if (!this.checkScriptExists(script)) {
            return;
        }
        String[] commandArray = this.createCommandArray(script, fromFile, toFile);
        Runtime runtime = Runtime.getRuntime();
        this.logCommand(commandArray);
        try {
            runtime.exec(commandArray);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private String[] createCommandArray(String script, File fromFile, File toFile) {
        String[] command = new String[toFile == null ? 2 : 3];
        String fromFilePath = fromFile.getAbsolutePath();
        command[0] = script;
        command[1] = fromFilePath;
        if (toFile != null) {
            String toFilePath;
            command[2] = toFilePath = toFile.getAbsolutePath();
        }
        return command;
    }

    private boolean isSidecarFile(File fromFile) {
        String filenameLowercase = fromFile.getName().toLowerCase();
        return filenameLowercase.endsWith(".xmp");
    }

    private void logCommand(String[] commandArray) {
        StringBuilder command = new StringBuilder();
        for (String token : commandArray) {
            command.append('\"');
            command.append(token);
            command.append('\"');
            command.append(" ");
        }
        LOGGER.log(Level.INFO, "Executing file hook command {0}", command.toString());
    }

    private boolean checkScriptExists(String script) {
        if (script == null) {
            return false;
        }
        if (!new File(script).isFile()) {
            LOGGER.log(Level.WARNING, "File Hook script ''{0}'' does not exist", script);
            return false;
        }
        return true;
    }
}

