/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.fileeventhooks;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.DocumentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.openide.util.Lookup;

public class JPhotoTaggerActionsSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final FilenameSuffixesListModel filenameSuffixesListModel = new FilenameSuffixesListModel();
    private String selectedFilenameSuffix;
    private final ListCellRenderer<?> suffixesListCellRenderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = 1L;
        private final Icon ICON_FILE = IconUtil.getImageIcon(JPhotoTaggerActionsSettingsPanel.class, (String)"file.png");

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon(this.ICON_FILE);
            return label;
        }
    };
    private final DocumentListener filenameSuffixDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setAddButtonEnabled(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setAddButtonEnabled(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setAddButtonEnabled(e);
        }

        private void setAddButtonEnabled(DocumentEvent e) {
            String suffix = DocumentUtil.getText((DocumentEvent)e);
            JPhotoTaggerActionsSettingsPanel.this.buttonAddFilenameSuffix.setEnabled(StringUtil.hasContent((String)suffix));
        }
    };
    private JButton buttonAddFilenameSuffix;
    private JButton buttonRemoveSelectedFilenameSuffix;
    private JButton buttonRenameSelectedFilenameSuffix;
    private JLabel labelAttentionJptActions;
    private JLabel labelFilenameSuffix;
    private JLabel labelFilenameSuffixExample;
    private JXLabel labelInfoJPhotoTaggerFilenameSuffixes;
    private JXList listFilenameSuffixes;
    private JPanel panelButtonsFilenameSuffixes;
    private JPanel panelEditFilenameSuffix;
    private JPanel panelListFilenameSuffixes;
    private JPanel panelSuffixes;
    private JScrollPane scrollPaneListFilenameSuffixes;
    private JTextField textFieldFilenameSuffix;
    private BindingGroup bindingGroup;

    public JPhotoTaggerActionsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics((Container)this);
        this.textFieldFilenameSuffix.getDocument().addDocumentListener(this.filenameSuffixDocumentListener);
    }

    private void filenameSuffixTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.addFilenameSuffix();
        }
    }

    private void addFilenameSuffix() {
        String filenameSuffix = this.textFieldFilenameSuffix.getText().trim();
        if (!filenameSuffix.isEmpty()) {
            this.filenameSuffixesListModel.addSuffix(filenameSuffix);
            ComponentUtil.parentWindowToFront((Component)this);
        }
    }

    public String getSelectedFilenameSuffix() {
        return this.selectedFilenameSuffix;
    }

    public void setSelectedFilenameSuffix(String selectedFilenameSuffix) {
        this.selectedFilenameSuffix = selectedFilenameSuffix;
        boolean suffixSelected = StringUtil.hasContent((String)selectedFilenameSuffix);
        this.buttonRenameSelectedFilenameSuffix.setEnabled(suffixSelected);
        this.buttonRemoveSelectedFilenameSuffix.setEnabled(suffixSelected);
    }

    private void removeSelectedFilenameSuffix() {
        if (this.selectedFilenameSuffix != null && MessageDisplayer.confirmYesNo((Component)this, (String)Bundle.getString(JPhotoTaggerActionsSettingsPanel.class, (String)"SettingsPanel.Confirm.RemoveSelectedFilenameSuffix", (Object[])new Object[]{this.selectedFilenameSuffix}))) {
            this.filenameSuffixesListModel.removeSuffix(this.selectedFilenameSuffix);
            ComponentUtil.parentWindowToFront((Component)this);
            this.textFieldFilenameSuffix.requestFocusInWindow();
        }
    }

    private void renameSelectedFilenameSuffix() {
        String message;
        String input;
        if (this.selectedFilenameSuffix != null && StringUtil.hasContent((String)(input = MessageDisplayer.input((String)(message = Bundle.getString(JPhotoTaggerActionsSettingsPanel.class, (String)"SettingsPanel.Input.RenameSelectedFilenameSuffix", (Object[])new Object[0])), (String)this.selectedFilenameSuffix)))) {
            if (this.filenameSuffixesListModel.renameSuffix(this.selectedFilenameSuffix, input)) {
                this.selectedFilenameSuffix = input;
            }
            ComponentUtil.parentWindowToFront((Component)this);
            this.textFieldFilenameSuffix.requestFocusInWindow();
        }
    }

    private void keyInFilenameSuffixesListPressed(int keyCode) {
        switch (keyCode) {
            case 127: {
                this.removeSelectedFilenameSuffix();
                this.listFilenameSuffixes.requestFocusInWindow();
                break;
            }
            case 113: {
                this.renameSelectedFilenameSuffix();
                this.listFilenameSuffixes.requestFocusInWindow();
                break;
            }
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.labelInfoJPhotoTaggerFilenameSuffixes = new JXLabel();
        this.panelSuffixes = new JPanel();
        this.panelListFilenameSuffixes = new JPanel();
        this.scrollPaneListFilenameSuffixes = new JScrollPane();
        this.listFilenameSuffixes = new JXList();
        this.panelEditFilenameSuffix = new JPanel();
        this.labelFilenameSuffix = new JLabel();
        this.textFieldFilenameSuffix = new JTextField();
        this.buttonAddFilenameSuffix = new JButton();
        this.labelFilenameSuffixExample = new JLabel();
        this.panelButtonsFilenameSuffixes = new JPanel();
        this.buttonRenameSelectedFilenameSuffix = new JButton();
        this.buttonRemoveSelectedFilenameSuffix = new JButton();
        this.labelAttentionJptActions = new JLabel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/fileeventhooks/Bundle");
        this.labelInfoJPhotoTaggerFilenameSuffixes.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.labelInfoJPhotoTaggerFilenameSuffixes.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.labelInfoJPhotoTaggerFilenameSuffixes, gridBagConstraints);
        this.panelSuffixes.setBorder(BorderFactory.createTitledBorder(bundle.getString("JPhotoTaggerActionsSettingsPanel.panelSuffixes.border.title")));
        this.panelSuffixes.setLayout(new GridBagLayout());
        this.panelListFilenameSuffixes.setLayout(new GridBagLayout());
        this.listFilenameSuffixes.setModel((ListModel)this.filenameSuffixesListModel);
        this.listFilenameSuffixes.setSelectionMode(0);
        this.listFilenameSuffixes.setCellRenderer(this.suffixesListCellRenderer);
        this.listFilenameSuffixes.setLayoutOrientation(2);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${selectedFilenameSuffix}"), (Object)this.listFilenameSuffixes, (Property)BeanProperty.create((String)"selectedElement"));
        this.bindingGroup.addBinding((Binding)binding);
        this.listFilenameSuffixes.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPhotoTaggerActionsSettingsPanel.this.listFilenameSuffixesKeyPressed(evt);
            }
        });
        this.scrollPaneListFilenameSuffixes.setViewportView((Component)this.listFilenameSuffixes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelListFilenameSuffixes.add((Component)this.scrollPaneListFilenameSuffixes, gridBagConstraints);
        this.panelEditFilenameSuffix.setLayout(new GridBagLayout());
        this.labelFilenameSuffix.setLabelFor(this.textFieldFilenameSuffix);
        this.labelFilenameSuffix.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.labelFilenameSuffix.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelEditFilenameSuffix.add((Component)this.labelFilenameSuffix, gridBagConstraints);
        this.textFieldFilenameSuffix.setColumns(5);
        this.textFieldFilenameSuffix.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPhotoTaggerActionsSettingsPanel.this.textFieldFilenameSuffixKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEditFilenameSuffix.add((Component)this.textFieldFilenameSuffix, gridBagConstraints);
        this.buttonAddFilenameSuffix.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.buttonAddFilenameSuffix.text"));
        this.buttonAddFilenameSuffix.setEnabled(false);
        this.buttonAddFilenameSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPhotoTaggerActionsSettingsPanel.this.buttonAddFilenameSuffixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEditFilenameSuffix.add((Component)this.buttonAddFilenameSuffix, gridBagConstraints);
        this.labelFilenameSuffixExample.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.labelFilenameSuffixExample.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelEditFilenameSuffix.add((Component)this.labelFilenameSuffixExample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelListFilenameSuffixes.add((Component)this.panelEditFilenameSuffix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelSuffixes.add((Component)this.panelListFilenameSuffixes, gridBagConstraints);
        this.panelButtonsFilenameSuffixes.setLayout(new GridLayout(2, 0, 0, 5));
        this.buttonRenameSelectedFilenameSuffix.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.buttonRenameSelectedFilenameSuffix.text"));
        this.buttonRenameSelectedFilenameSuffix.setEnabled(false);
        this.buttonRenameSelectedFilenameSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPhotoTaggerActionsSettingsPanel.this.buttonRenameSelectedFilenameSuffixActionPerformed(evt);
            }
        });
        this.panelButtonsFilenameSuffixes.add(this.buttonRenameSelectedFilenameSuffix);
        this.buttonRemoveSelectedFilenameSuffix.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.buttonRemoveSelectedFilenameSuffix.text"));
        this.buttonRemoveSelectedFilenameSuffix.setEnabled(false);
        this.buttonRemoveSelectedFilenameSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPhotoTaggerActionsSettingsPanel.this.buttonRemoveSelectedFilenameSuffixActionPerformed(evt);
            }
        });
        this.panelButtonsFilenameSuffixes.add(this.buttonRemoveSelectedFilenameSuffix);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelSuffixes.add((Component)this.panelButtonsFilenameSuffixes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelSuffixes, gridBagConstraints);
        this.labelAttentionJptActions.setText(bundle.getString("JPhotoTaggerActionsSettingsPanel.labelAttentionJptActions.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.labelAttentionJptActions, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void buttonAddFilenameSuffixActionPerformed(ActionEvent evt) {
        this.addFilenameSuffix();
        this.textFieldFilenameSuffix.requestFocusInWindow();
    }

    private void buttonRemoveSelectedFilenameSuffixActionPerformed(ActionEvent evt) {
        this.removeSelectedFilenameSuffix();
        this.textFieldFilenameSuffix.requestFocusInWindow();
    }

    private void buttonRenameSelectedFilenameSuffixActionPerformed(ActionEvent evt) {
        this.renameSelectedFilenameSuffix();
    }

    private void listFilenameSuffixesKeyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        this.keyInFilenameSuffixesListPressed(keyCode);
    }

    private void textFieldFilenameSuffixKeyTyped(KeyEvent evt) {
        this.filenameSuffixTyped(evt);
    }

    private static class FilenameSuffixesListModel
    extends DefaultListModel<String> {
        private static final long serialVersionUID = 1L;

        private FilenameSuffixesListModel() {
            this.addElements();
        }

        private void addElements() {
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            if (prefs != null) {
                HashSet suffixes = new HashSet(prefs.getStringCollection("FileEventHooks.JPhotoTagger.FilenameSuffixes"));
                for (String suffix : suffixes) {
                    this.addElement(suffix);
                }
            }
        }

        public void addSuffix(String suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix == null");
            }
            String trimmedSuffix = suffix.trim();
            if (trimmedSuffix.length() > 1 && trimmedSuffix.startsWith(".")) {
                trimmedSuffix = trimmedSuffix.replaceFirst("[\\.]+", "");
            }
            if (!(trimmedSuffix.isEmpty() || this.contains(trimmedSuffix) || "xmp".equalsIgnoreCase(suffix))) {
                this.addElement(trimmedSuffix);
                this.updatePreferences();
            }
        }

        public void removeSuffix(String suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix == null");
            }
            boolean removed = this.removeElement(suffix);
            if (removed) {
                this.updatePreferences();
            }
        }

        public boolean renameSuffix(String oldName, String newName) {
            if (oldName == null) {
                throw new NullPointerException("oldName == null");
            }
            if (newName == null) {
                throw new NullPointerException("newName == null");
            }
            if (oldName.equals(newName)) {
                return false;
            }
            int oldNameIndex = this.indexOf(oldName);
            if (oldNameIndex >= 0) {
                this.set(oldNameIndex, newName);
                this.updatePreferences();
                return true;
            }
            return false;
        }

        private void updatePreferences() {
            Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
            prefs.setStringCollection("FileEventHooks.JPhotoTagger.FilenameSuffixes", Collections.list(this.elements()));
        }
    }
}

