/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.fileeventhooks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.file.event.FileCopiedEvent;
import org.jphototagger.api.file.event.FileDeletedEvent;
import org.jphototagger.api.file.event.FileMovedEvent;
import org.jphototagger.api.file.event.FileRenamedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.lib.io.FileUtil;
import org.openide.util.Lookup;

public final class JPhotoTaggerActionsExecutor {
    private static final Logger LOGGER = Logger.getLogger(JPhotoTaggerActionsExecutor.class.getName());
    private final Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
    private final Set<String> filenameSuffixes = new HashSet<String>();

    public JPhotoTaggerActionsExecutor() {
        this.filenameSuffixes.addAll(this.prefs.getStringCollection("FileEventHooks.JPhotoTagger.FilenameSuffixes"));
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileCopiedEvent.class)
    public void fileCopied(FileCopiedEvent evt) {
        File sourceFile = evt.getSourceFile();
        if (this.isSidecarFile(sourceFile)) {
            return;
        }
        File targetFile = evt.getTargetFile();
        Set<String> set = this.filenameSuffixes;
        synchronized (set) {
            for (String suffix : this.filenameSuffixes) {
                File targetFileWithSuffix;
                File sourceFileWithSuffix = this.createFileWithSuffix(sourceFile, suffix);
                if (sourceFileWithSuffix == null || !sourceFileWithSuffix.isFile() || (targetFileWithSuffix = this.createFileWithSuffix(targetFile, suffix)) == null) continue;
                LOGGER.log(Level.INFO, "Copying also ''{0}'' to ''{1}''", new Object[]{sourceFileWithSuffix, targetFileWithSuffix});
                try {
                    FileUtil.copyFile((File)sourceFileWithSuffix, (File)targetFileWithSuffix);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Error while copying ''{0}'' to ''{1}''", new Object[]{sourceFileWithSuffix, targetFileWithSuffix});
                }
            }
        }
    }

    @EventSubscriber(eventClass=FileDeletedEvent.class)
    public void fileDeleted(FileDeletedEvent evt) {
        File file = evt.getFile();
        if (this.isSidecarFile(file)) {
            return;
        }
        for (File fileWithSuffix : this.createFilesWithSuffixes(file)) {
            if (!fileWithSuffix.isFile()) continue;
            LOGGER.log(Level.INFO, "Deleting also file ''{0}''", fileWithSuffix);
            if (fileWithSuffix.delete()) continue;
            LOGGER.log(Level.WARNING, "Couldn''t delete file: ''{0}''", fileWithSuffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileMovedEvent.class)
    public void fileMoved(FileMovedEvent evt) {
        File sourceFile = evt.getSourceFile();
        if (this.isSidecarFile(sourceFile)) {
            return;
        }
        File targetFile = evt.getTargetFile();
        Set<String> set = this.filenameSuffixes;
        synchronized (set) {
            for (String suffix : this.filenameSuffixes) {
                this.moveFile(sourceFile, targetFile, suffix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=FileRenamedEvent.class)
    public void fileRenamed(FileRenamedEvent evt) {
        File sourceFile = evt.getSourceFile();
        if (this.isSidecarFile(sourceFile)) {
            return;
        }
        File targetFile = evt.getTargetFile();
        Set<String> set = this.filenameSuffixes;
        synchronized (set) {
            for (String suffix : this.filenameSuffixes) {
                this.moveFile(sourceFile, targetFile, suffix);
            }
        }
    }

    private void moveFile(File sourceFile, File targetFile, String suffix) {
        File targetFileWithSuffix;
        File sourceFileWithSuffix = this.createFileWithSuffix(sourceFile, suffix);
        if (sourceFileWithSuffix != null && sourceFileWithSuffix.isFile() && (targetFileWithSuffix = this.createFileWithSuffix(targetFile, suffix)) != null) {
            LOGGER.log(Level.INFO, "Moving also ''{0}'' to ''{1}''", new Object[]{sourceFileWithSuffix, targetFileWithSuffix});
            if (!sourceFileWithSuffix.renameTo(targetFileWithSuffix)) {
                LOGGER.log(Level.WARNING, "Error while moving ''{0}'' to ''{1}''", new Object[]{sourceFileWithSuffix, targetFileWithSuffix});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> createFilesWithSuffixes(File file) {
        ArrayList<File> filesWithSuffixes;
        Set<String> set = this.filenameSuffixes;
        synchronized (set) {
            filesWithSuffixes = new ArrayList<File>(this.filenameSuffixes.size());
            for (String suffix : this.filenameSuffixes) {
                File fileWithSuffix = this.createFileWithSuffix(file, suffix);
                if (fileWithSuffix == null) continue;
                filesWithSuffixes.add(fileWithSuffix);
            }
        }
        return filesWithSuffixes;
    }

    private File createFileWithSuffix(File file, String suffix) {
        String filePathname = file.getAbsolutePath();
        int lastDotIndex = filePathname.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < filePathname.length() - 1) {
            String pathnameForFileWithSuffix = filePathname.substring(0, lastDotIndex + 1) + suffix;
            return new File(pathnameForFileWithSuffix);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPreferenceChanged(PreferencesChangedEvent evt) {
        String key = evt.getKey();
        if ("FileEventHooks.JPhotoTagger.FilenameSuffixes".equals(key)) {
            Set<String> set = this.filenameSuffixes;
            synchronized (set) {
                this.filenameSuffixes.clear();
                this.filenameSuffixes.addAll(this.prefs.getStringCollection("FileEventHooks.JPhotoTagger.FilenameSuffixes"));
            }
        }
    }

    private boolean isSidecarFile(File file) {
        String filenameLowercase = file.getName().toLowerCase();
        return filenameLowercase.endsWith(".xmp");
    }
}

