/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.plugin.cftc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.help.HelpUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.plugin.cftc.CopyFilenamesToClipboard;
import org.openide.util.Lookup;

public class SettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DelimiterModel model = new DelimiterModel();
    private final DelimiterRenderer renderer = new DelimiterRenderer();
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private JButton buttonHelp;
    private JComboBox<Object> comboBoxDelimiter;
    private JLabel label;
    private JLabel labelVersion;
    private JPanel panelDelimiter;
    private JPanel panelFill;
    private JPanel panelVersion;

    public SettingsPanel() {
        this.initComponents();
        this.setPersistentModelValue();
        MnemonicUtil.setMnemonics(this);
    }

    private void setPersistentModelValue() {
        if (this.prefs != null) {
            String delim = this.prefs.getString(CopyFilenamesToClipboard.KEY_FILENAME_DELIMITER);
            if (delim == null) {
                delim = "\n";
            }
            this.comboBoxDelimiter.setSelectedItem(delim);
        }
    }

    private void showHelp() {
        HelpUtil.showHelp("/org/jphototagger/plugin/cftc/help/index.html");
    }

    private void writeDelimiter() {
        if (this.prefs != null) {
            this.prefs.setString(CopyFilenamesToClipboard.KEY_FILENAME_DELIMITER, this.model.getSelectedItem().toString());
        }
    }

    private void initComponents() {
        this.panelDelimiter = new JPanel();
        this.label = new JLabel();
        this.comboBoxDelimiter = new JComboBox();
        this.panelFill = new JPanel();
        this.panelVersion = new JPanel();
        this.labelVersion = new JLabel();
        this.buttonHelp = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelDelimiter.setName("panelDelimiter");
        this.panelDelimiter.setLayout(new GridBagLayout());
        this.label.setDisplayedMnemonic('t');
        this.label.setLabelFor(this.comboBoxDelimiter);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/plugin/cftc/Bundle");
        this.label.setText(bundle.getString("SettingsPanel.label.text"));
        this.label.setName("label");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelDelimiter.add((Component)this.label, gridBagConstraints);
        this.comboBoxDelimiter.setModel(this.model);
        this.comboBoxDelimiter.setName("comboBoxDelimiter");
        this.comboBoxDelimiter.setRenderer(this.renderer);
        this.comboBoxDelimiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.comboBoxDelimiterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDelimiter.add(this.comboBoxDelimiter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelDelimiter, gridBagConstraints);
        this.panelFill.setName("panelFill");
        GroupLayout panelFillLayout = new GroupLayout(this.panelFill);
        this.panelFill.setLayout(panelFillLayout);
        panelFillLayout.setHorizontalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 645, Short.MAX_VALUE));
        panelFillLayout.setVerticalGroup(panelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 162, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelFill, gridBagConstraints);
        this.panelVersion.setName("panelVersion");
        this.panelVersion.setLayout(new GridBagLayout());
        this.labelVersion.setText(bundle.getString("SettingsPanel.labelVersion.text"));
        this.labelVersion.setName("labelVersion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelVersion.add((Component)this.labelVersion, gridBagConstraints);
        this.buttonHelp.setText(bundle.getString("SettingsPanel.buttonHelp.text"));
        this.buttonHelp.setName("buttonHelp");
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.buttonHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelVersion.add((Component)this.buttonHelp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panelVersion, gridBagConstraints);
    }

    private void comboBoxDelimiterActionPerformed(ActionEvent evt) {
        this.writeDelimiter();
    }

    private void buttonHelpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private class DelimiterRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private DelimiterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof String) {
                String delimiter = (String)value;
                String description = SettingsPanel.this.model.getDescription(delimiter);
                assert (description != null) : "No description of delimiter " + delimiter;
                if (description != null) {
                    label.setText(description);
                }
            }
            return label;
        }
    }

    private static class DelimiterModel
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> descriptionOfDelimiter = new LinkedHashMap<String, String>();

        DelimiterModel() {
            this.addElements();
        }

        private void addElements() {
            this.descriptionOfDelimiter.put("\n", Bundle.getString(SettingsPanel.class, "DelimiterModel.Description.Newline", new Object[0]));
            this.descriptionOfDelimiter.put(" ", Bundle.getString(SettingsPanel.class, "DelimiterModel.Description.Space", new Object[0]));
            this.descriptionOfDelimiter.put("\t", Bundle.getString(SettingsPanel.class, "DelimiterModel.Description.Tab", new Object[0]));
            this.descriptionOfDelimiter.put(";", Bundle.getString(SettingsPanel.class, "DelimiterModel.Description.Semicolon", new Object[0]));
            this.descriptionOfDelimiter.put(":", Bundle.getString(SettingsPanel.class, "DelimiterModel.Description.Colon", new Object[0]));
            for (String key : this.descriptionOfDelimiter.keySet()) {
                this.addElement(key);
            }
        }

        public String getDescription(String delimiter) {
            return this.descriptionOfDelimiter.get(delimiter);
        }
    }
}

