/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.xml.bind;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jphototagger.lib.io.IoUtil;

public final class XmlObjectExporter {
    public static final String ENCODING = "UTF-8";

    public static void export(Object object, File file) throws JAXBException, IOException {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Writer writer = XmlObjectExporter.createWriter(file);
        if (writer == null) {
            return;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)ENCODING);
        marshaller.marshal(object, writer);
        XmlObjectExporter.close(writer);
    }

    private static Writer createWriter(File file) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING);
        }
        catch (IOException ex) {
            XmlObjectExporter.close(writer);
            throw ex;
        }
        return writer;
    }

    private static void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (Throwable t) {
            Logger.getLogger(XmlObjectExporter.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshal(Object object) throws JAXBException {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        StringWriter sw = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)ENCODING);
            marshaller.marshal(object, (Writer)sw);
        }
        finally {
            IoUtil.close(sw);
        }
        return sw.toString();
    }

    public static void marshal(Object object, OutputStream os) throws JAXBException {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        if (os == null) {
            throw new NullPointerException("os == null");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)ENCODING);
        marshaller.marshal(object, os);
    }

    private XmlObjectExporter() {
    }
}

