/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util.logging;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.jphototagger.lib.swing.TableModelExt;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.lib.util.logging.LogfileRecord;

public final class LogfilesTableModel
extends TableModelExt {
    private static final long serialVersionUID = 1L;
    private final List<LogfileRecord> records = new ArrayList<LogfileRecord>();
    private final List<Level> visibleLevels;
    private final String filter;

    public LogfilesTableModel(String filter, List<Level> visibleLevels) {
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        if (visibleLevels == null) {
            throw new NullPointerException("visibleLevels == null");
        }
        this.filter = filter;
        this.visibleLevels = visibleLevels;
        this.addColumns();
    }

    private void addRecord(LogfileRecord record) {
        if (record == null) {
            throw new NullPointerException("record == null");
        }
        if ((this.visibleLevels.contains(Level.ALL) || this.visibleLevels.contains(record.getLevel())) && (this.filter.isEmpty() || record.contains(this.filter))) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(record.getLevel());
            row.add(new Date(record.getMillis()));
            String message = record.getMessage();
            row.add(message == null ? Bundle.getString(LogfilesTableModel.class, "LogfilesTableModel.Error.MessageIsNull", new Object[0]) : message);
            this.records.add(record);
            this.addRow(row.toArray(new Object[row.size()]));
        }
    }

    public LogfileRecord getLogfileRecord(int index) {
        if (!CollectionUtil.isValidIndex(this.records, index)) {
            throw new IllegalArgumentException("Invalid index: " + index + " element count: " + this.records.size());
        }
        return this.records.get(index);
    }

    private void addColumns() {
        this.addColumn(Bundle.getString(LogfilesTableModel.class, "LogfilesTableModel.HeaderColumn.1", new Object[0]));
        this.addColumn(Bundle.getString(LogfilesTableModel.class, "LogfilesTableModel.HeaderColumn.2", new Object[0]));
        this.addColumn(Bundle.getString(LogfilesTableModel.class, "LogfilesTableModel.HeaderColumn.3", new Object[0]));
    }

    public void setRecords(List<LogfileRecord> records) {
        if (records == null) {
            throw new NullPointerException("records == null");
        }
        this.clear();
        for (LogfileRecord record : records) {
            this.addRecord(record);
        }
        this.fireTableDataChanged();
    }

    private void clear() {
        this.records.clear();
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }
}

